/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.commons.ui;

import org.eclipse.mylyn.commons.ui.ShellDragSupport;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;

public class ShellDragSupportTest {
    private final Composite composite = (Composite)Mockito.mock(Composite.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
    private final Shell shell = (Shell)Mockito.spy((Object)new Shell());
    private ShellDragSupport support;

    @Before
    public void setUp() {
        this.shell.setLocation(100, 150);
        Mockito.when((Object)this.composite.getShell()).thenReturn((Object)this.shell);
        this.support = new ShellDragSupport(this.composite);
    }

    @Test
    public void shellDragSupport() {
        ((Composite)Mockito.verify((Object)this.composite)).getDisplay();
        ((Composite)Mockito.verify((Object)this.composite)).getShell();
        ((Composite)Mockito.verify((Object)this.composite)).addListener(6, (Listener)this.support);
        ((Composite)Mockito.verify((Object)this.composite)).addListener(7, (Listener)this.support);
        ((Composite)Mockito.verify((Object)this.composite)).addListener(5, (Listener)this.support);
        ((Composite)Mockito.verify((Object)this.composite)).addListener(3, (Listener)this.support);
        ((Composite)Mockito.verify((Object)this.composite)).addListener(4, (Listener)this.support);
        ((Composite)Mockito.verify((Object)this.composite)).addListener(12, (Listener)this.support);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.composite});
    }

    @Test
    public void handleDisposeEnter() {
        this.handleEvent(12);
        Assert.assertTrue((boolean)this.support.getMoveCursor().isDisposed());
    }

    @Test
    public void handleMouseEnter() {
        this.handleEvent(6);
        ((Shell)Mockito.verify((Object)this.shell)).setCursor((Cursor)ArgumentMatchers.eq((Object)this.support.getMoveCursor()));
    }

    @Test
    public void handleMouseExit() {
        this.handleEvent(7);
    }

    @Test
    public void handleMouseMove() {
        this.handleEvent(5, 110, 160);
        Assert.assertEquals((Object)new Point(100, 150), (Object)this.shell.getLocation());
        this.handleEvent(3, 105, 160);
        this.handleEvent(5, 109, 167);
        ((Shell)Mockito.verify((Object)this.shell)).setLocation(104, 157);
        this.handleEvent(5, 111, 170);
        ((Shell)Mockito.verify((Object)this.shell)).setLocation(106, 160);
        this.handleEvent(5, 110, 174);
        ((Shell)Mockito.verify((Object)this.shell)).setLocation(105, 164);
        this.handleEvent(4);
        this.handleEvent(5, 112, 176);
        Assert.assertEquals((Object)new Point(105, 164), (Object)this.shell.getLocation());
    }

    private void handleEvent(int type) {
        this.handleEvent(type, 0, 0);
    }

    private void handleEvent(int type, int x, int y) {
        Event event = new Event();
        event.type = type;
        Point pt = this.shell.toControl(x, y);
        event.x = pt.x;
        event.y = pt.y;
        this.support.handleEvent(event);
    }
}

