/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.commons.ui;

import org.eclipse.mylyn.internal.commons.ui.E4ThemeColor;
import org.eclipse.swt.graphics.RGB;
import org.junit.Assert;
import org.junit.Test;

public class E4ThemeColorTest {
    @Test
    public void testRgbHex() {
        RGB rgb = E4ThemeColor.getRGBFromCssString((String)"#00FF00");
        Assert.assertEquals((Object)new RGB(0, 255, 0), (Object)rgb);
    }

    @Test
    public void testHexGradient() {
        RGB rgb = E4ThemeColor.getRGBFromCssString((String)"#FF0000 #0000FF");
        Assert.assertEquals((Object)new RGB(0, 0, 255), (Object)rgb);
    }

    @Test
    public void testHexGradientWithPercent() {
        RGB rgb = E4ThemeColor.getRGBFromCssString((String)"#FF0000 #00FF00 100%");
        Assert.assertEquals((Object)new RGB(0, 255, 0), (Object)rgb);
    }

    @Test
    public void testHexGradientWithPercentVertical() {
        RGB rgb = E4ThemeColor.getRGBFromCssString((String)"#00FF00 #FF0000 100% false");
        Assert.assertEquals((Object)new RGB(255, 0, 0), (Object)rgb);
    }

    @Test
    public void testRgb() {
        RGB rgb = E4ThemeColor.getRGBFromCssString((String)"rgb(238, 238, 238)");
        Assert.assertEquals((Object)new RGB(238, 238, 238), (Object)rgb);
    }

    @Test
    public void testRGBGradient() {
        RGB rgb = E4ThemeColor.getRGBFromCssString((String)"rgb(210, 210, 210) rgb(238, 238, 238)");
        Assert.assertEquals((Object)new RGB(238, 238, 238), (Object)rgb);
    }

    @Test
    public void testRGBGradientWithPercent() {
        RGB rgb = E4ThemeColor.getRGBFromCssString((String)"rgb(210, 210, 210) rgb(238, 238, 238) 100.0%");
        Assert.assertEquals((Object)new RGB(238, 238, 238), (Object)rgb);
    }
}

