/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.commons.ui;

import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.mylyn.commons.ui.AbstractColumnViewerSorter;
import org.eclipse.swt.widgets.Item;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class ColumnViewerSorterTest {
    private StubColumnViewerSorter sorter;

    @Before
    public void setUp() {
        this.sorter = new StubColumnViewerSorter();
    }

    @Test
    public void testCompare() {
        ColumnViewer viewer = (ColumnViewer)Mockito.mock(ColumnViewer.class);
        Assert.assertEquals((long)-1L, (long)this.sorter.compare((Viewer)viewer, "a", "b"));
        Assert.assertEquals((long)0L, (long)this.sorter.compare((Viewer)viewer, "a", "a"));
        Assert.assertEquals((long)1L, (long)this.sorter.compare((Viewer)viewer, 2, 1));
    }

    @Test
    public void testCompareSortColumn() {
        ColumnViewer viewer = (ColumnViewer)Mockito.mock(ColumnViewer.class);
        this.sorter.sortColumn = (Item)Mockito.mock(Item.class);
        Assert.assertEquals((long)-1L, (long)this.sorter.compare((Viewer)viewer, "a", "b"));
        Assert.assertEquals((long)0L, (long)this.sorter.compare((Viewer)viewer, "a", "a"));
        Assert.assertEquals((long)1L, (long)this.sorter.compare((Viewer)viewer, 2, 1));
    }

    @Test
    public void testCompareSortColumnLabelProvider() {
        ColumnViewer viewer = (ColumnViewer)Mockito.mock(ColumnViewer.class);
        this.sorter.sortColumn = (Item)Mockito.mock(Item.class);
        Assert.assertEquals((long)-1L, (long)this.sorter.compare((Viewer)viewer, "a", "b"));
        Assert.assertEquals((long)0L, (long)this.sorter.compare((Viewer)viewer, "a", "a"));
        Assert.assertEquals((long)1L, (long)this.sorter.compare((Viewer)viewer, 2, 1));
    }

    @Test
    public void testCompareColumn() {
        Assert.assertEquals((long)-1L, (long)this.sorter.compare(null, "a", "b", 0));
    }

    @Test
    public void testCompareDefault() {
        ColumnViewer viewer = (ColumnViewer)Mockito.mock(ColumnViewer.class);
        Assert.assertEquals((long)-1L, (long)this.sorter.compareDefault(viewer, "a", "b"));
    }

    @Test
    public void testCompareDirection() {
        ColumnViewer viewer = (ColumnViewer)Mockito.mock(ColumnViewer.class);
        this.sorter.sortColumn = (Item)Mockito.mock(Item.class);
        this.sorter.sortDirection = 128;
        Assert.assertEquals((long)-1L, (long)this.sorter.compare((Viewer)viewer, "a", "b"));
        this.sorter.sortDirection = 1024;
        Assert.assertEquals((long)1L, (long)this.sorter.compare((Viewer)viewer, "a", "b"));
    }

    class StubColumnViewerSorter
    extends AbstractColumnViewerSorter<ColumnViewer, Item> {
        Item sortColumn;
        int sortDirection;
        int columnIndex;

        StubColumnViewerSorter() {
        }

        Item getSortColumn(ColumnViewer viewer) {
            return this.sortColumn;
        }

        int getSortDirection(ColumnViewer viewer) {
            return this.sortDirection;
        }

        int getColumnIndex(ColumnViewer viewer, Item column) {
            return this.columnIndex;
        }
    }
}

