/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.commons.tests.workbench.browser;

import junit.framework.TestCase;
import org.eclipse.mylyn.commons.sdk.util.CommonTestUtil;
import org.eclipse.mylyn.commons.workbench.WorkbenchUtil;
import org.eclipse.mylyn.commons.workbench.browser.WebBrowserDialog;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class WebBrowserDialogTest
extends TestCase {
    public void testCreate() {
        if (CommonTestUtil.skipBrowserTests()) {
            System.err.println("Skipping WebBrowserDialogTest.testCreate()");
            return;
        }
        TestWebBrowserDialog dialog = new TestWebBrowserDialog(WorkbenchUtil.getShell(), "title", null, "message", 0, new String[0], 0);
        dialog.create();
        WebBrowserDialogTest.assertEquals((int)3, (int)dialog.getParent().getChildren().length);
        WebBrowserDialogTest.assertEquals(Text.class, dialog.getParent().getChildren()[0].getClass());
        WebBrowserDialogTest.assertEquals(Browser.class, dialog.getParent().getChildren()[1].getClass());
        WebBrowserDialogTest.assertEquals(Label.class, dialog.getParent().getChildren()[2].getClass());
    }

    public void testSetShow() {
        if (CommonTestUtil.skipBrowserTests()) {
            System.err.println("Skipping WebBrowserDialogTest.testSetShow()");
            return;
        }
        TestWebBrowserDialog dialog = new TestWebBrowserDialog(WorkbenchUtil.getShell(), "title", null, "message", 0, new String[0], 0);
        dialog.setShowLocation(false);
        dialog.setShowStatus(false);
        dialog.create();
        WebBrowserDialogTest.assertEquals((int)1, (int)dialog.getParent().getChildren().length);
        WebBrowserDialogTest.assertEquals(Browser.class, dialog.getParent().getChildren()[0].getClass());
    }

    public void testSetShowAfterCreate() {
        if (CommonTestUtil.skipBrowserTests()) {
            System.err.println("Skipping WebBrowserDialogTest.testSetShowAfterCreate()");
            return;
        }
        WebBrowserDialog dialog = new WebBrowserDialog(WorkbenchUtil.getShell(), "title", null, "message", 0, new String[0], 0);
        dialog.create();
        try {
            dialog.setShowLocation(false);
            WebBrowserDialogTest.fail((String)"Expected exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            dialog.setShowStatus(false);
            WebBrowserDialogTest.fail((String)"Expected exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    private class TestWebBrowserDialog
    extends WebBrowserDialog {
        private Composite parent;

        public TestWebBrowserDialog(Shell parentShell, String dialogTitle, Image dialogTitleImage, String dialogMessage, int dialogImageType, String[] dialogButtonLabels, int defaultIndex) {
            super(parentShell, dialogTitle, dialogTitleImage, dialogMessage, dialogImageType, dialogButtonLabels, defaultIndex);
        }

        public Control createCustomArea(Composite parent) {
            this.parent = parent;
            return super.createCustomArea(parent);
        }

        public Composite getParent() {
            return this.parent;
        }
    }
}

