/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.commons.tests.workbench.browser;

import junit.framework.TestCase;
import org.eclipse.mylyn.commons.sdk.util.CommonTestUtil;
import org.eclipse.mylyn.commons.workbench.EditorHandle;
import org.eclipse.mylyn.commons.workbench.browser.AbstractUrlHandler;
import org.eclipse.mylyn.commons.workbench.browser.BrowserUtil;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;

public class BrowserUtilTest
extends TestCase {
    protected void setUp() throws Exception {
        HighPriorityHandler.handle = null;
        HighPriorityHandler.queried = false;
        LowPriorityHandler.handle = null;
        LowPriorityHandler.queried = false;
    }

    protected void tearDown() throws Exception {
        HighPriorityHandler.handle = null;
        LowPriorityHandler.handle = null;
    }

    public void testUrlHandlerPriorityNullHandle() {
        if (CommonTestUtil.skipBrowserTests()) {
            System.err.println("Skipping BrowserUtilTest.testUrlHandlerPriorityNullHandle() to avoid browser crash");
            return;
        }
        BrowserUtil.openUrl((String)"http://mylyn.org", (int)0);
        BrowserUtilTest.assertTrue((boolean)LowPriorityHandler.queried);
        BrowserUtilTest.assertTrue((boolean)HighPriorityHandler.queried);
    }

    public void testUrlHandlerPriorityLow() {
        if (CommonTestUtil.skipBrowserTests()) {
            System.err.println("Skipping BrowserUtilTest.testUrlHandlerPriorityLow() to avoid browser crash");
            return;
        }
        LowPriorityHandler.handle = new EditorHandle();
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        EditorHandle result = BrowserUtil.openUrl((IWorkbenchPage)page, (String)"http://mylyn.org", (int)0);
        BrowserUtilTest.assertSame((Object)result, (Object)LowPriorityHandler.handle);
        BrowserUtilTest.assertTrue((boolean)LowPriorityHandler.queried);
        BrowserUtilTest.assertTrue((boolean)HighPriorityHandler.queried);
    }

    public void testUrlHandlerPriorityHigh() {
        if (CommonTestUtil.skipBrowserTests()) {
            System.err.println("Skipping BrowserUtilTest.testUrlHandlerPriorityHigh() to avoid browser crash");
            return;
        }
        LowPriorityHandler.handle = new EditorHandle();
        HighPriorityHandler.handle = new EditorHandle();
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        EditorHandle result = BrowserUtil.openUrl((IWorkbenchPage)page, (String)"http://mylyn.org", (int)0);
        BrowserUtilTest.assertSame((Object)result, (Object)HighPriorityHandler.handle);
        BrowserUtilTest.assertFalse((boolean)LowPriorityHandler.queried);
        BrowserUtilTest.assertTrue((boolean)HighPriorityHandler.queried);
    }

    public static class HighPriorityHandler
    extends AbstractUrlHandler {
        static EditorHandle handle;
        static boolean queried;

        public EditorHandle openUrl(IWorkbenchPage page, String location, int customFlags) {
            queried = true;
            return handle;
        }

        public int getPriority() {
            return 1000;
        }
    }

    public static class LowPriorityHandler
    extends AbstractUrlHandler {
        static EditorHandle handle;
        static boolean queried;

        public EditorHandle openUrl(IWorkbenchPage page, String location, int customFlags) {
            queried = true;
            return handle;
        }

        public int getPriority() {
            return 1;
        }
    }
}

