/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.commons.tests.support;

import java.net.ProxySelector;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import java.util.regex.Pattern;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import junit.framework.TestFailure;
import junit.framework.TestListener;
import junit.framework.TestResult;
import junit.framework.TestSuite;
import org.eclipse.core.runtime.Platform;
import org.eclipse.mylyn.commons.net.WebUtil;
import org.eclipse.mylyn.internal.commons.net.CommonsNetPlugin;

@Deprecated
public class ManagedTestSuite
extends TestSuite {
    public static final long DELAY = 600000L;
    private final Listener listener = new Listener();

    public ManagedTestSuite() {
    }

    public ManagedTestSuite(String name) {
        super(name);
    }

    public void run(TestResult result) {
        result.addListener((TestListener)this.listener);
        ManagedTestSuite.dumpSystemInfo();
        super.run(result);
        this.listener.dumpResults(result);
        this.listener.startTest(new Test(){

            public int countTestCases() {
                return 1;
            }

            public void run(TestResult result) {
            }

            public String toString() {
                return "ShutdownWatchdog";
            }
        });
    }

    private static void dumpSystemInfo() {
        if (Platform.isRunning() && CommonsNetPlugin.getProxyService() != null && CommonsNetPlugin.getProxyService().isSystemProxiesEnabled() && !CommonsNetPlugin.getProxyService().hasSystemProxies()) {
            System.err.println("Forcing manual proxy configuration");
            CommonsNetPlugin.getProxyService().setSystemProxiesEnabled(false);
            CommonsNetPlugin.getProxyService().setProxiesEnabled(true);
        }
        Properties p = System.getProperties();
        if (Platform.isRunning()) {
            p.put("build.system", String.valueOf(Platform.getOS()) + "-" + Platform.getOSArch() + "-" + Platform.getWS());
        } else {
            p.put("build.system", "standalone");
        }
        String info = "System: ${os.name} ${os.version} (${os.arch}) / ${build.system} / ${java.vendor} ${java.vm.name} ${java.version}";
        for (Map.Entry<Object, Object> entry : p.entrySet()) {
            info = info.replaceFirst(Pattern.quote("${" + entry.getKey() + "}"), entry.getValue().toString());
        }
        System.err.println(info);
        System.err.print("Proxy : " + WebUtil.getProxyForUrl((String)"http://mylyn.eclipse.org") + " (Platform)");
        try {
            System.err.print(" / " + ProxySelector.getDefault().select(new URI("http://mylyn.eclipse.org")) + " (Java)");
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        System.err.println();
        System.err.println();
    }

    private class DumpThreadTask
    extends TimerTask {
        private final Test test;
        private final Thread testThread;

        public DumpThreadTask(Test test) {
            this.test = test;
            this.testThread = Thread.currentThread();
        }

        @Override
        public void run() {
            StringBuffer sb = new StringBuffer();
            sb.append(MessageFormat.format("Test {0} is taking too long:\n", this.test.toString()));
            Map<Thread, StackTraceElement[]> traces = Thread.getAllStackTraces();
            for (Map.Entry<Thread, StackTraceElement[]> entry : traces.entrySet()) {
                sb.append(entry.getKey().toString());
                sb.append("\n");
                StackTraceElement[] stackTraceElementArray = entry.getValue();
                int n = stackTraceElementArray.length;
                int n2 = 0;
                while (n2 < n) {
                    StackTraceElement element = stackTraceElementArray[n2];
                    sb.append("  ");
                    sb.append(element.toString());
                    sb.append("\n");
                    ++n2;
                }
                sb.append("\n");
            }
            System.err.println(sb.toString());
            System.err.println("Sending interrupt to thread: " + this.testThread.toString());
            this.testThread.interrupt();
        }
    }

    private class Listener
    implements TestListener {
        private DumpThreadTask task;
        private final Timer timer = new Timer(true);

        private Listener() {
        }

        public void addError(Test test, Throwable t) {
            System.err.println("[ERROR]");
        }

        public void addFailure(Test test, AssertionFailedError t) {
            System.err.println("[FAILURE]");
        }

        private void dumpList(String header, Enumeration<TestFailure> failures) {
            System.err.println(header);
            while (failures.hasMoreElements()) {
                TestFailure failure = failures.nextElement();
                System.err.print("  ");
                System.err.println(failure.toString());
            }
        }

        public void dumpResults(TestResult result) {
            System.err.println();
            this.dumpList("Failures: ", result.failures());
            System.err.println();
            this.dumpList("Errors: ", result.errors());
            int failedCount = result.errorCount() + result.failureCount();
            System.err.println();
            System.err.println(MessageFormat.format("{0} out of {1} tests failed", failedCount, result.runCount()));
        }

        public void endTest(Test test) {
            if (this.task != null) {
                this.task.cancel();
                this.task = null;
            }
        }

        public void startTest(Test test) {
            System.err.println("Running " + test.toString());
            this.task = new DumpThreadTask(test);
            this.timer.schedule((TimerTask)this.task, 600000L);
        }
    }
}

