/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.commons.tests.operations;

import junit.framework.TestCase;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.mylyn.commons.core.operations.IOperationMonitor;
import org.eclipse.mylyn.commons.core.operations.OperationUtil;
import org.eclipse.mylyn.commons.net.Policy;

public class OperationUtilTest
extends TestCase {
    public void testIsBackgroundMonitorNull() {
        OperationUtilTest.assertFalse((boolean)OperationUtil.isBackgroundMonitor(null));
    }

    public void testIsBackgroundMonitorProgressMonitor() {
        OperationUtilTest.assertFalse((boolean)OperationUtil.isBackgroundMonitor((IProgressMonitor)new NullProgressMonitor()));
    }

    public void testIsBackgroundMonitorBackgroundMonitorForNullProgressMonitor() {
        OperationUtilTest.assertTrue((boolean)OperationUtil.isBackgroundMonitor((IProgressMonitor)Policy.backgroundMonitorFor((IProgressMonitor)new NullProgressMonitor())));
    }

    public void testIsBackgroundMonitorBackgroundMonitorForNull() {
        OperationUtilTest.assertTrue((boolean)OperationUtil.isBackgroundMonitor((IProgressMonitor)Policy.backgroundMonitorFor(null)));
    }

    public void testIsBackgroundMonitorOperationMonitorNull() {
        OperationUtilTest.assertFalse((boolean)OperationUtil.isBackgroundMonitor((IProgressMonitor)OperationUtil.convert(null)));
    }

    public void testIsBackgroundMonitorOperationMonitorProgressMonitor() {
        OperationUtilTest.assertFalse((boolean)OperationUtil.isBackgroundMonitor((IProgressMonitor)OperationUtil.convert((IProgressMonitor)new NullProgressMonitor())));
    }

    public void testIsBackgroundMonitorOperationMonitorBackground() {
        IOperationMonitor monitor = OperationUtil.convert((IProgressMonitor)new NullProgressMonitor());
        monitor.addFlag(IOperationMonitor.OperationFlag.BACKGROUND);
        OperationUtilTest.assertTrue((boolean)OperationUtil.isBackgroundMonitor((IProgressMonitor)monitor));
        monitor.removeFlag(IOperationMonitor.OperationFlag.BACKGROUND);
        OperationUtilTest.assertFalse((boolean)OperationUtil.isBackgroundMonitor((IProgressMonitor)monitor));
    }

    public void testIsBackgroundMonitorOperationMonitorChild() {
        IOperationMonitor monitor = OperationUtil.convert((IProgressMonitor)new NullProgressMonitor());
        monitor.addFlag(IOperationMonitor.OperationFlag.BACKGROUND);
        OperationUtilTest.assertTrue((boolean)OperationUtil.isBackgroundMonitor((IProgressMonitor)monitor));
        IOperationMonitor child = monitor.newChild(1);
        OperationUtilTest.assertTrue((boolean)OperationUtil.isBackgroundMonitor((IProgressMonitor)child));
        monitor.removeFlag(IOperationMonitor.OperationFlag.BACKGROUND);
        OperationUtilTest.assertFalse((boolean)OperationUtil.isBackgroundMonitor((IProgressMonitor)child));
    }

    public void testConvert() {
        OperationUtilTest.assertNotNull((Object)OperationUtil.convert(null));
    }
}

