/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.commons.tests.operations;

import junit.framework.TestCase;
import org.eclipse.mylyn.commons.core.operations.CancellableOperationMonitorThread;
import org.eclipse.mylyn.commons.core.operations.ICancellableOperation;
import org.junit.Test;

public class CancellableOperationMonitorThreadTest
extends TestCase {
    private CancellableOperationMonitorThread thread;

    protected void setUp() throws Exception {
        this.thread = new CancellableOperationMonitorThread();
    }

    protected void tearDown() throws Exception {
        this.thread.shutdown();
    }

    @Test
    public void testShutdownAddOperation() throws InterruptedException {
        this.thread.shutdown();
        try {
            this.thread.addOperation((ICancellableOperation)new MockOperation());
            CancellableOperationMonitorThreadTest.fail((String)"Expected IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void testShutdownProcessOnce() throws InterruptedException {
        this.thread.shutdown();
        try {
            this.thread.processOperations();
            CancellableOperationMonitorThreadTest.fail((String)"Expected IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void testShutdownRemoveOperation() throws InterruptedException {
        this.thread.shutdown();
        try {
            this.thread.removeOperation((ICancellableOperation)new MockOperation());
            CancellableOperationMonitorThreadTest.fail((String)"Expected IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void testShutdownStart() throws InterruptedException {
        this.thread.shutdown();
        try {
            this.thread.start();
            CancellableOperationMonitorThreadTest.fail((String)"Expected IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void testShutdownTwice() throws InterruptedException {
        this.thread.start();
        CancellableOperationMonitorThreadTest.assertTrue((boolean)this.thread.isAlive());
        this.thread.shutdown();
        CancellableOperationMonitorThreadTest.assertFalse((boolean)this.thread.isAlive());
        this.thread.shutdown();
        CancellableOperationMonitorThreadTest.assertFalse((boolean)this.thread.isAlive());
    }

    @Test
    public void testShutdown() throws Exception {
        CancellableOperationMonitorThreadTest.assertFalse((boolean)this.thread.isAlive());
        this.thread.start();
        CancellableOperationMonitorThreadTest.assertTrue((boolean)this.thread.isAlive());
        this.thread.shutdown();
        CancellableOperationMonitorThreadTest.assertFalse((boolean)this.thread.isAlive());
    }

    @Test
    public void testShutdownNotStarted() throws Exception {
        CancellableOperationMonitorThreadTest.assertFalse((boolean)this.thread.isAlive());
        this.thread.shutdown();
        CancellableOperationMonitorThreadTest.assertFalse((boolean)this.thread.isAlive());
    }

    public void testNotCancelOperation() throws Exception {
        MockOperation operation = new MockOperation();
        this.thread.addOperation((ICancellableOperation)operation);
        CancellableOperationMonitorThreadTest.assertFalse((boolean)operation.aborted);
        this.thread.processOperations();
        CancellableOperationMonitorThreadTest.assertFalse((boolean)operation.aborted);
    }

    public void testCancelOperation() throws Exception {
        MockOperation operation = new MockOperation();
        this.thread.addOperation((ICancellableOperation)operation);
        CancellableOperationMonitorThreadTest.assertFalse((boolean)operation.aborted);
        operation.canceled = true;
        this.thread.processOperations();
        CancellableOperationMonitorThreadTest.assertTrue((boolean)operation.aborted);
    }

    public void testAddRemoveOperation() throws Exception {
        MockOperation operation = new MockOperation();
        this.thread.addOperation((ICancellableOperation)operation);
        CancellableOperationMonitorThreadTest.assertTrue((boolean)this.thread.isAlive());
        this.thread.removeOperation((ICancellableOperation)operation);
        CancellableOperationMonitorThreadTest.assertTrue((boolean)this.thread.isAlive());
        operation.canceled = true;
        try {
            this.thread.processOperations();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        CancellableOperationMonitorThreadTest.assertFalse((boolean)operation.aborted);
    }

    class MockOperation
    implements ICancellableOperation {
        boolean canceled;
        boolean aborted;

        MockOperation() {
        }

        public void abort() {
            this.aborted = true;
        }

        public boolean isCanceled() {
            return this.canceled;
        }
    }
}

