/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.commons.tests.net;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import junit.framework.TestCase;
import org.apache.commons.httpclient.params.HttpConnectionParams;
import org.eclipse.mylyn.commons.sdk.util.MockServer;
import org.eclipse.mylyn.internal.commons.net.PollingSslProtocolSocketFactory;

public class SslProtocolSocketFactoryTest
extends TestCase {
    private MockServer server;
    private InetSocketAddress proxyAddress;

    protected void setUp() throws Exception {
        this.server = new MockServer();
        int proxyPort = this.server.startAndWait();
        assert (proxyPort > 0);
        this.proxyAddress = new InetSocketAddress("localhost", proxyPort);
    }

    protected void tearDown() throws Exception {
        this.server.stop();
    }

    public void testTrustAllSslProtocolSocketFactory() throws Exception {
        PollingSslProtocolSocketFactory factory = new PollingSslProtocolSocketFactory();
        Socket s = factory.createSocket(this.proxyAddress.getHostName(), this.proxyAddress.getPort());
        SslProtocolSocketFactoryTest.assertNotNull((Object)s);
        SslProtocolSocketFactoryTest.assertTrue((boolean)s.isConnected());
        s.close();
        InetAddress anyHost = new Socket().getLocalAddress();
        s = factory.createSocket(this.proxyAddress.getHostName(), this.proxyAddress.getPort(), anyHost, 0);
        SslProtocolSocketFactoryTest.assertNotNull((Object)s);
        SslProtocolSocketFactoryTest.assertTrue((boolean)s.isConnected());
        s.close();
        HttpConnectionParams params = new HttpConnectionParams();
        s = factory.createSocket(this.proxyAddress.getHostName(), this.proxyAddress.getPort(), anyHost, 0, params);
        SslProtocolSocketFactoryTest.assertNotNull((Object)s);
        SslProtocolSocketFactoryTest.assertTrue((boolean)s.isConnected());
        s.close();
        params.setConnectionTimeout(1000);
        s = factory.createSocket(this.proxyAddress.getHostName(), this.proxyAddress.getPort(), anyHost, 0, params);
        SslProtocolSocketFactoryTest.assertNotNull((Object)s);
        SslProtocolSocketFactoryTest.assertTrue((boolean)s.isConnected());
        s.close();
    }
}

