/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.commons.tests.net;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import junit.framework.TestCase;
import org.eclipse.mylyn.commons.core.net.NetUtil;

public class NetUtilTest
extends TestCase {
    static final int MAX_HTTP_HOST_CONNECTIONS_DEFAULT = 100;
    static final int MAX_HTTP_TOTAL_CONNECTIONS_DEFAULT = 1000;
    private static final String PROPERTY_MAX_HTTP_HOST_CONNECTIONS = "org.eclipse.mylyn.http.connections.per.host";
    private static final String PROPERTY_MAX_HTTP_TOTAL_CONNECTIONS = "org.eclipse.mylyn.http.total.connections";

    public void testGetHostDefault() {
        String url = "http://example.com/";
        NetUtilTest.assertEquals((String)"example.com", (String)NetUtil.getHost((String)url));
    }

    public void testGetHostEmptyPath() {
        String url = "http://example.com";
        NetUtilTest.assertEquals((String)"example.com", (String)NetUtil.getHost((String)url));
    }

    public void testGetHostEmptyPathPort() {
        String url = "http://example.com";
        NetUtilTest.assertEquals((String)"example.com", (String)NetUtil.getHost((String)url));
    }

    public void testGetHostNestedUrl() {
        String url = "https://example.com:444/folder/file.txt?search=https://example.com:812/folder/file.txt";
        NetUtilTest.assertEquals((String)"example.com", (String)NetUtil.getHost((String)url));
    }

    public void testGetHostNestedUrlNoPort() {
        String url = "https://example.com/folder/file.txt?search=https://example.com:812/folder/file.txt";
        NetUtilTest.assertEquals((String)"example.com", (String)NetUtil.getHost((String)url));
    }

    public void testGetHostPortNumber() {
        String url = "https://example.com:444/folder/file.txt";
        NetUtilTest.assertEquals((String)"example.com", (String)NetUtil.getHost((String)url));
    }

    public void testGetPortDefault() {
        String url = "http://example.com/";
        NetUtilTest.assertEquals((int)80, (int)NetUtil.getPort((String)url));
    }

    public void testGetPortEmptyPath() {
        String url = "http://example.com";
        NetUtilTest.assertEquals((int)80, (int)NetUtil.getPort((String)url));
    }

    public void testGetPortEmptyPathPort() {
        String url = "http://example.com:321";
        NetUtilTest.assertEquals((int)321, (int)NetUtil.getPort((String)url));
    }

    public void testGetPortNestedUrl() {
        String url = "https://example.com:444/folder/file.txt?search=https://example.com:812/folder/file.txt";
        NetUtilTest.assertEquals((int)444, (int)NetUtil.getPort((String)url));
    }

    public void testGetPortNestedUrlDefault() {
        String url = "https://example.com/folder/file.txt?search=https://example.com:812/folder/file.txt";
        NetUtilTest.assertEquals((int)443, (int)NetUtil.getPort((String)url));
    }

    public void testGetPortNoProtocol() {
        String url = "example.com:321";
        NetUtilTest.assertEquals((int)321, (int)NetUtil.getPort((String)url));
    }

    public void testGetPortNoProtocolDefault() {
        String url = "example.com";
        NetUtilTest.assertEquals((int)80, (int)NetUtil.getPort((String)url));
    }

    public void testGetPortNumber() {
        String url = "https://example.com:444/folder/file.txt";
        NetUtilTest.assertEquals((int)444, (int)NetUtil.getPort((String)url));
    }

    public void testGetRequestParameters() {
        String url = "https://jira.codehaus.org/sr/jira.issueviews:searchrequest-xml/temp/SearchRequest.xml?&pid=11093&resolution=-1&sorter/field=updated&sorter/order=DESC&tempMax=1000";
        NetUtilTest.assertEquals((String)"/sr/jira.issueviews:searchrequest-xml/temp/SearchRequest.xml?&pid=11093&resolution=-1&sorter/field=updated&sorter/order=DESC&tempMax=1000", (String)NetUtil.getRequestPath((String)url));
    }

    public void testGetRequestPathEmpty() {
        String url = "http://example.com";
        NetUtilTest.assertEquals((String)"", (String)NetUtil.getRequestPath((String)url));
    }

    public void testGetRequestPathEmptyPort() {
        String url = "http://example.com:321";
        NetUtilTest.assertEquals((String)"", (String)NetUtil.getRequestPath((String)url));
    }

    public void testGetRequestPathNestedUrl() {
        String url = "https://example.com:444/folder/file.txt?search=https://example.com:812/folder/file.txt";
        NetUtilTest.assertEquals((String)"/folder/file.txt?search=https://example.com:812/folder/file.txt", (String)NetUtil.getRequestPath((String)url));
    }

    public void testGetRequestPathNestedUrlNoPort() {
        String url = "https://example.com/folder/file.txt?search=https://example.com:812/folder/file.txt";
        NetUtilTest.assertEquals((String)"/folder/file.txt?search=https://example.com:812/folder/file.txt", (String)NetUtil.getRequestPath((String)url));
    }

    public void testGetRequestPathNoProtocol() {
        String url = "example.com/folder/file";
        NetUtilTest.assertEquals((String)"/folder/file", (String)NetUtil.getRequestPath((String)url));
    }

    public void testGetRequestPathNoProtocolEmtpyPath() {
        String url = "example.com";
        NetUtilTest.assertEquals((String)"", (String)NetUtil.getRequestPath((String)url));
    }

    public void testGetRequestPathPortNumber() {
        String url = "https://example.com:444/folder/file.txt";
        NetUtilTest.assertEquals((String)"/folder/file.txt", (String)NetUtil.getRequestPath((String)url));
    }

    public void testGetRequestPathSlash() {
        String url = "http://example.com/";
        NetUtilTest.assertEquals((String)"/", (String)NetUtil.getRequestPath((String)url));
    }

    public void testIsUrlHttpsValid() {
        NetUtilTest.assertTrue((boolean)NetUtil.isUrlHttps((String)"https://example.com"));
    }

    public void testIsUrlHttpsHttpUrl() {
        NetUtilTest.assertFalse((boolean)NetUtil.isUrlHttps((String)"http://"));
    }

    public void testIsUrlHttpsInvalid() {
        NetUtilTest.assertFalse((boolean)NetUtil.isUrlHttps((String)"abc"));
    }

    public void testIsUrlHttpsNoHost() {
        NetUtilTest.assertTrue((boolean)NetUtil.isUrlHttps((String)"https://"));
    }

    public void testIsUrlHttpsNoUrl() {
        NetUtilTest.assertTrue((boolean)NetUtil.isUrlHttps((String)"httpsabc"));
    }

    public void testIsUrlHttpsTelnets() {
        NetUtilTest.assertFalse((boolean)NetUtil.isUrlHttps((String)"telnets://"));
    }

    public void testGetMaxHttpConnectionsPerHostDefault() throws IOException {
        PrintStream oldErr = System.err;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        System.setErr(new PrintStream(baos));
        try {
            NetUtilTest.assertEquals((int)100, (int)NetUtil.getMaxHttpConnectionsPerHost());
            NetUtilTest.assertEquals((int)0, (int)baos.size());
        }
        finally {
            baos.close();
            System.setErr(oldErr);
        }
    }

    public void testGetMaxHttpConnectionsDefault() throws IOException {
        PrintStream oldErr = System.err;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        System.setErr(new PrintStream(baos));
        try {
            NetUtilTest.assertEquals((int)1000, (int)NetUtil.getMaxHttpConnections());
            NetUtilTest.assertEquals((int)0, (int)baos.size());
        }
        finally {
            baos.close();
            System.setErr(oldErr);
        }
    }

    public void testGetMaxHttpConnectionsPerHost() {
        String oldValue = System.getProperty(PROPERTY_MAX_HTTP_HOST_CONNECTIONS);
        int newValue = 7;
        try {
            System.setProperty(PROPERTY_MAX_HTTP_HOST_CONNECTIONS, Integer.toString(newValue));
            NetUtilTest.assertEquals((int)newValue, (int)NetUtil.getMaxHttpConnectionsPerHost());
        }
        finally {
            NetUtilTest.resetSystemProperty(PROPERTY_MAX_HTTP_HOST_CONNECTIONS, oldValue);
        }
    }

    public void testGetMaxHttpConnectionsPerHostInvalid() {
        String oldValue = System.getProperty(PROPERTY_MAX_HTTP_HOST_CONNECTIONS);
        try {
            System.setProperty(PROPERTY_MAX_HTTP_HOST_CONNECTIONS, "NaN");
            NetUtilTest.assertEquals((int)100, (int)NetUtil.getMaxHttpConnectionsPerHost());
        }
        finally {
            NetUtilTest.resetSystemProperty(PROPERTY_MAX_HTTP_HOST_CONNECTIONS, oldValue);
        }
    }

    public void testGetMaxHttpConnections() {
        String oldValue = System.getProperty(PROPERTY_MAX_HTTP_TOTAL_CONNECTIONS);
        int newValue = 7;
        try {
            System.setProperty(PROPERTY_MAX_HTTP_TOTAL_CONNECTIONS, Integer.toString(newValue));
            NetUtilTest.assertEquals((int)newValue, (int)NetUtil.getMaxHttpConnections());
        }
        finally {
            NetUtilTest.resetSystemProperty(PROPERTY_MAX_HTTP_TOTAL_CONNECTIONS, oldValue);
        }
    }

    public void testGetMaxHttpConnectionsInvalid() {
        String oldValue = System.getProperty(PROPERTY_MAX_HTTP_TOTAL_CONNECTIONS);
        try {
            System.setProperty(PROPERTY_MAX_HTTP_TOTAL_CONNECTIONS, "NaN");
            NetUtilTest.assertEquals((int)1000, (int)NetUtil.getMaxHttpConnections());
        }
        finally {
            NetUtilTest.resetSystemProperty(PROPERTY_MAX_HTTP_TOTAL_CONNECTIONS, oldValue);
        }
    }

    private static void resetSystemProperty(String key, String oldValue) {
        if (oldValue == null) {
            System.clearProperty(key);
        } else {
            System.setProperty(key, oldValue);
        }
    }
}

