/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.commons.tests.net;

import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.ThreadPoolExecutor;
import junit.framework.TestCase;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.mylyn.commons.net.AbstractWebLocation;
import org.eclipse.mylyn.commons.net.WebLocation;
import org.eclipse.mylyn.commons.net.WebUtil;
import org.eclipse.mylyn.commons.net.http.CommonHttpMethod3;
import org.eclipse.mylyn.commons.tests.net.WebUtilTest;
import org.eclipse.mylyn.internal.commons.net.CommonsNetPlugin;
import org.eclipse.mylyn.internal.commons.net.http.CommonGetMethod3;
import org.eclipse.mylyn.internal.commons.net.http.CommonPostMethod3;

public class CommonHttpMethod3Test
extends TestCase {
    public void testGetOpenStreamAndCancel() throws Exception {
        CommonGetMethod3 method = new CommonGetMethod3("/");
        this.openStreamAndCancel((CommonHttpMethod3)method);
    }

    public void testPostOpenStreamAndCancel() throws Exception {
        CommonPostMethod3 method = new CommonPostMethod3("/");
        this.openStreamAndCancel((CommonHttpMethod3)method);
    }

    void openStreamAndCancel(CommonHttpMethod3 method) throws Exception {
        InputStream in;
        WebUtilTest.StubProgressMonitor monitor = new WebUtilTest.StubProgressMonitor();
        HttpClient client = new HttpClient();
        String url = "http://mylyn.org/";
        WebLocation location = new WebLocation(url);
        HostConfiguration hostConfiguration = WebUtil.createHostConfiguration((HttpClient)client, (AbstractWebLocation)location, (IProgressMonitor)monitor);
        try {
            WebUtil.execute((HttpClient)client, (HostConfiguration)hostConfiguration, (HttpMethod)method, (IProgressMonitor)monitor);
            in = method.getResponseBodyAsStream((IProgressMonitor)monitor);
        }
        finally {
            monitor.setCanceled(true);
            method.releaseConnection((IProgressMonitor)monitor);
        }
        CommonHttpMethod3Test.assertNotNull((Object)in);
        Thread.sleep(500L);
        CommonHttpMethod3Test.assertEquals((int)0, (int)((ThreadPoolExecutor)CommonsNetPlugin.getExecutorService()).getActiveCount());
        try {
            in.read();
            CommonHttpMethod3Test.fail((String)"Expected channel to be closed");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

