/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.commons.tests.core.storage;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import junit.framework.TestCase;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.mylyn.commons.core.storage.CommonStore;
import org.eclipse.mylyn.commons.core.storage.ICommonStorable;
import org.eclipse.mylyn.commons.sdk.util.CommonTestUtil;

public class CommonStoreTest
extends TestCase {
    private File location;
    private CommonStore store;

    public void testDelete() throws Exception {
        ICommonStorable storable = this.store.get((IPath)Path.EMPTY);
        CommonStoreTest.assertFalse((boolean)storable.exists("handle"));
        OutputStream out = storable.write("handle", null);
        out.close();
        CommonStoreTest.assertTrue((boolean)storable.exists("handle"));
        CommonStoreTest.assertEquals(Collections.singletonList(new File(this.location, "handle")), Arrays.asList(this.location.listFiles()));
        storable.delete("handle");
        CommonStoreTest.assertFalse((boolean)storable.exists("handle"));
        CommonStoreTest.assertEquals(Collections.emptyList(), Arrays.asList(this.location.listFiles()));
    }

    public void testDeleteAll() throws Exception {
        ICommonStorable storable = this.store.get((IPath)Path.EMPTY);
        this.writeHello(storable, "1");
        this.writeHello(storable, "2");
        storable.deleteAll();
        CommonStoreTest.assertFalse((boolean)storable.exists("1"));
        CommonStoreTest.assertFalse((boolean)this.location.exists());
    }

    public void testDeleteAllSubPath() throws Exception {
        ICommonStorable storable2 = this.store.get((IPath)new Path("sub2"));
        this.writeHello(storable2, "1");
        ICommonStorable storable = this.store.get((IPath)new Path("sub"));
        this.writeHello(storable, "1");
        this.writeHello(storable, "2");
        storable.deleteAll();
        CommonStoreTest.assertFalse((boolean)storable.exists("1"));
        CommonStoreTest.assertTrue((boolean)storable2.exists("1"));
        CommonStoreTest.assertTrue((boolean)this.location.exists());
        CommonStoreTest.assertFalse((boolean)new File(this.location, "sub").exists());
    }

    public void testDeleteAllSubPathException() throws Exception {
        ICommonStorable storable = this.store.get((IPath)new Path("sub"));
        this.writeHello(storable, "1");
        ICommonStorable storable2 = this.store.get((IPath)new Path("sub/sub2"));
        this.writeHello(storable2, "1");
        try {
            storable.deleteAll();
            CommonStoreTest.fail((String)"Expected CoreException");
        }
        catch (CoreException expected) {
            CommonStoreTest.assertTrue((boolean)storable.exists("1"));
            CommonStoreTest.assertTrue((boolean)storable2.exists("1"));
        }
        storable2.deleteAll();
        storable.deleteAll();
        CommonStoreTest.assertTrue((boolean)this.location.exists());
        CommonStoreTest.assertFalse((boolean)new File(this.location, "sub").exists());
    }

    public void testExists() throws Exception {
        ICommonStorable storable = this.store.get((IPath)Path.EMPTY);
        CommonStoreTest.assertFalse((boolean)storable.exists("handle"));
        OutputStream out = storable.write("handle", null);
        out.close();
        CommonStoreTest.assertTrue((boolean)storable.exists("handle"));
    }

    public void testGet() throws Exception {
        ICommonStorable storable = this.store.get((IPath)Path.EMPTY);
        ICommonStorable storable2 = this.store.get((IPath)Path.EMPTY);
        CommonStoreTest.assertSame((Object)storable, (Object)storable2);
    }

    public void testGetPath() {
        ICommonStorable storable = this.store.get((IPath)new Path("sub"));
        ICommonStorable storable2 = this.store.get((IPath)Path.EMPTY);
        CommonStoreTest.assertNotSame((Object)storable, (Object)storable2);
        storable2 = this.store.get((IPath)new Path("sub"));
        CommonStoreTest.assertSame((Object)storable, (Object)storable2);
    }

    public void testGetPathLazyCreate() {
        ICommonStorable storable = this.store.get((IPath)new Path("sub"));
        CommonStoreTest.assertEquals(Collections.emptyList(), Arrays.asList(this.location.listFiles()));
        CommonStoreTest.assertFalse((boolean)storable.exists("handle"));
        CommonStoreTest.assertEquals(Collections.emptyList(), Arrays.asList(this.location.listFiles()));
    }

    public void testGetPathWrite() throws Exception {
        ICommonStorable storable = this.store.get((IPath)new Path("sub"));
        this.writeHello(storable, "handle");
        File subFile = new File(this.location, "sub");
        CommonStoreTest.assertEquals(Collections.singletonList(subFile), Arrays.asList(this.location.listFiles()));
        CommonStoreTest.assertEquals(Collections.singletonList(new File(subFile, "handle")), Arrays.asList(subFile.listFiles()));
    }

    public void testMove() throws Exception {
        ICommonStorable storable = this.store.get((IPath)new Path("source"));
        this.writeHello(storable, "handle");
        this.store.move((IPath)new Path("source"), (IPath)new Path("target"));
        File targetFile = new File(this.location, "target");
        CommonStoreTest.assertEquals(Collections.singletonList(targetFile), Arrays.asList(this.location.listFiles()));
        CommonStoreTest.assertEquals(Collections.singletonList(new File(targetFile, "handle")), Arrays.asList(targetFile.listFiles()));
    }

    public void testMoveExistant() throws Exception {
        ICommonStorable storable = this.store.get((IPath)new Path("source"));
        this.writeHello(storable, "handle");
        ICommonStorable storable2 = this.store.get((IPath)new Path("target"));
        this.writeHello(storable2, "handle2");
        try {
            this.store.move((IPath)new Path("source"), (IPath)new Path("target"));
            CommonStoreTest.fail((String)"Expected CoreException");
        }
        catch (CoreException expected) {
            File sourceFile = new File(this.location, "source");
            File targetFile = new File(this.location, "target");
            List<File> list = Arrays.asList(this.location.listFiles());
            Collections.sort(list);
            CommonStoreTest.assertEquals(Arrays.asList(sourceFile, targetFile), list);
            CommonStoreTest.assertEquals(Collections.singletonList(new File(targetFile, "handle2")), Arrays.asList(targetFile.listFiles()));
        }
    }

    public void testMoveNonExistant() throws Exception {
        this.store.move((IPath)new Path("source"), (IPath)new Path("target"));
        CommonStoreTest.assertEquals(Collections.emptyList(), Arrays.asList(this.location.listFiles()));
    }

    public void testRelease() throws Exception {
        ICommonStorable storable = this.store.get((IPath)Path.EMPTY);
        storable.release();
        ICommonStorable storable2 = this.store.get((IPath)Path.EMPTY);
        CommonStoreTest.assertNotSame((Object)storable, (Object)storable2);
    }

    public void testWriteRead() throws Exception {
        ICommonStorable storable = this.store.get((IPath)Path.EMPTY);
        this.writeHello(storable, "handle");
        CommonStoreTest.assertTrue((boolean)storable.exists("handle"));
        try (InputStream in = storable.read("handle", null);){
            byte[] buffer = new byte[5];
            in.read(buffer);
            CommonStoreTest.assertEquals((String)"hello", (String)new String(buffer));
        }
    }

    private void writeHello(ICommonStorable storable, String handle) throws IOException, CoreException {
        try (OutputStream out = storable.write(handle, null);){
            out.write("hello".getBytes());
        }
    }

    protected void setUp() throws Exception {
        this.location = CommonTestUtil.createTempFolder((String)CommonStoreTest.class.getName());
        this.store = new CommonStore(this.location);
    }

    protected void tearDown() throws Exception {
        CommonTestUtil.deleteFolderRecursively((File)this.location);
    }
}

