/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.commons.tests.core;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import junit.framework.TestCase;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.commons.core.CoreUtil;
import org.eclipse.mylyn.commons.core.StatusHandler;

public class StatusHandlerTest
extends TestCase {
    public void testLogDumpsErrorToConsoleInTestMode() throws Exception {
        if (!CoreUtil.TEST_MODE) {
            return;
        }
        PrintStream oldErr = System.err;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        System.setErr(new PrintStream(baos));
        Status status = new Status(4, "org.eclipse.mylyn.commons.core", "boom!");
        try {
            StatusHandler.log((IStatus)status);
            StatusHandlerTest.assertTrue((boolean)baos.toString().matches("\\[\\d{4}-\\d{2}-\\d{2}T\\d{1,2}-\\d{1,2}-\\d{1,2}\\] " + status.toString() + ",\\s+"));
        }
        finally {
            baos.close();
            System.setErr(oldErr);
        }
    }
}

