/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.commons.tests.core;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import junit.framework.TestCase;
import org.eclipse.mylyn.internal.commons.core.Html2TextReader;

public class Html2TextReaderTest
extends TestCase {
    private static final boolean DEBUG = false;
    private static final String LD = System.getProperty("line.separator", "\n");

    private void verify(String input, String expectedOutput) throws IOException {
        StringReader reader = new StringReader(input);
        Html2TextReader htmlReader = new Html2TextReader((Reader)reader);
        String result = htmlReader.getString();
        Html2TextReaderTest.assertEquals((String)expectedOutput, (String)result);
        htmlReader.close();
    }

    public void test0() throws IOException {
        String string = "<code>3<5<code>";
        String expected = "3<5";
        this.verify(string, expected);
    }

    public void test1() throws IOException {
        String string = "<dl><dt>@author</dt><dd>Foo Bar</dd></dl>";
        String expected = String.valueOf(LD) + "@author" + LD + "\tFoo Bar" + LD;
        this.verify(string, expected);
    }

    public void test2() throws IOException {
        String string = "<code>3>5<code>";
        String expected = "3>5";
        this.verify(string, expected);
    }

    public void test3() throws IOException {
        String string = "<a href= \"<p>this is only a string - not a tag<p>\">text</a>";
        String expected = "text";
        this.verify(string, expected);
    }

    public void test4() throws IOException {
        String string = "<html><body text=\"#000000\" bgcolor=\"#FFFF88\"><font size=-1><h5>void p.Bb.fes()</h5><p><dl><dt>Parameters:</dt><dd><b>i</b> fred or <code>null</code></dd></dl></font></body></html>";
        String expected = "void p.Bb.fes()" + LD + LD + LD + "Parameters:" + LD + "\ti fred or null" + LD;
        this.verify(string, expected);
    }

    public void test5() throws IOException {
        String string = "<code>1<2<3<4</code>";
        String expected = "1<2<3<4";
        this.verify(string, expected);
    }

    public void test6() throws IOException {
        String string = "<p>Something.<p>Something more.";
        String expected = String.valueOf(LD) + "Something." + LD + "Something more.";
        this.verify(string, expected);
    }

    public void testComments() throws Exception {
        String string = "<!-- begin-user-doc -->no comment<!-- end-user-doc -->";
        String expected = "no comment";
        this.verify(string, expected);
    }

    public void testSymbolLt() throws IOException {
        String string = "&lt;";
        String expected = "<";
        this.verify(string, expected);
    }

    public void testSymbolGt() throws IOException {
        String string = "&gt;";
        String expected = ">";
        this.verify(string, expected);
    }

    public void testSymbolNbsp() throws IOException {
        String string = "a&nbsp;b";
        String expected = "a b";
        this.verify(string, expected);
    }

    public void testSymbolAmp() throws IOException {
        String string = "&amp;";
        String expected = "&";
        this.verify(string, expected);
    }

    public void testSymbolCirc() throws IOException {
        String string = "&circ;";
        String expected = "^";
        this.verify(string, expected);
    }

    public void testSymbolTilde() throws IOException {
        String string = "&tilde;";
        String expected = "~";
        this.verify(string, expected);
    }

    public void testSymbolQuot() throws IOException {
        String string = "&quot;";
        String expected = "\"";
        this.verify(string, expected);
    }

    public void testSymbolAElig() throws IOException {
        String string = "&AElig;";
        String expected = "&AElig;";
        this.verify(string, expected);
    }

    public void testSymbolNotInEntityLookup() throws IOException {
        String string = "&auml;";
        String expected = "&auml;";
        this.verify(string, expected);
    }
}

