/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.commons.tests.core;

import java.util.Arrays;
import java.util.Collections;
import junit.framework.TestCase;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.mylyn.commons.core.ExtensionPointReader;

public class ExtensionPointReaderTest
extends TestCase {
    private static final String ID_PLUGIN = "org.eclipse.mylyn.commons.tests";

    public void testRead() {
        ExtensionPointReader reader = new ExtensionPointReader(ID_PLUGIN, "extensionPointReaderTest", "extensionElement", ExtensionPointReaderExtension.class);
        IStatus status = reader.read();
        ExtensionPointReaderTest.assertEquals((int)0, (int)status.getSeverity());
        ExtensionPointReaderTest.assertEquals(Arrays.asList(new ExtensionPointReaderExtensionImplementation()), (Object)reader.getItems());
        ExtensionPointReaderTest.assertEquals((Object)new ExtensionPointReaderExtensionImplementation(), (Object)reader.getItem());
    }

    public void testReadWithFiltering() {
        ExtensionPointReader reader = new ExtensionPointReader(ID_PLUGIN, "extensionPointReaderTest", "extensionElementWithPriority", ExtensionPointReaderExtension.class, "testFilterAttribute", "value1");
        IStatus status = reader.read();
        ExtensionPointReaderTest.assertEquals((int)0, (int)status.getSeverity());
        ExtensionPointReaderTest.assertEquals(Collections.singletonList(new P5ExtensionPointReaderExtensionImplementation()), (Object)reader.getItems());
        ExtensionPointReaderTest.assertEquals((Object)new P5ExtensionPointReaderExtensionImplementation(), (Object)reader.getItem());
        reader.setFilterAttributeValue("nomatch");
        status = reader.read();
        ExtensionPointReaderTest.assertEquals((int)0, (int)status.getSeverity());
        ExtensionPointReaderTest.assertEquals(Collections.emptyList(), (Object)reader.getItems());
        ExtensionPointReaderTest.assertNull((Object)reader.getItem());
    }

    public void testReadWithPriority() {
        ExtensionPointReader reader = new ExtensionPointReader(ID_PLUGIN, "extensionPointReaderTest", "extensionElementWithPriority", ExtensionPointReaderExtension.class);
        IStatus status = reader.read();
        ExtensionPointReaderTest.assertEquals((int)0, (int)status.getSeverity());
        ExtensionPointReaderTest.assertEquals(Arrays.asList(new P10ExtensionPointReaderExtensionImplementation(), new P5ExtensionPointReaderExtensionImplementation(), new P0ExtensionPointReaderExtensionImplementation(), new PNegative5ExtensionPointReaderExtensionImplementation()), (Object)reader.getItems());
    }

    public void testReadWithCustomPriority() {
        ExtensionPointReader reader = new ExtensionPointReader(ID_PLUGIN, "extensionPointReaderTest", "extensionElementWithPriority", ExtensionPointReaderExtension.class);
        reader.setPriorityAttributeId("customPriority");
        IStatus status = reader.read();
        ExtensionPointReaderTest.assertEquals((int)0, (int)status.getSeverity());
        ExtensionPointReaderTest.assertEquals(Arrays.asList(new P10ExtensionPointReaderExtensionImplementation(), new PNegative5ExtensionPointReaderExtensionImplementation(), new P0ExtensionPointReaderExtensionImplementation(), new P5ExtensionPointReaderExtensionImplementation()), (Object)reader.getItems());
    }

    public static interface ExtensionPointReaderExtension {
    }

    public static class ExtensionPointReaderExtensionImplementation
    implements ExtensionPointReaderExtension {
        String id = this.getClass().getName();

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ExtensionPointReaderExtensionImplementation other = (ExtensionPointReaderExtensionImplementation)obj;
            return !(this.id == null ? other.id != null : !this.id.equals(other.id));
        }
    }

    public static class P0ExtensionPointReaderExtensionImplementation
    extends ExtensionPointReaderExtensionImplementation {
    }

    public static class P10ExtensionPointReaderExtensionImplementation
    extends ExtensionPointReaderExtensionImplementation {
    }

    public static class P5ExtensionPointReaderExtensionImplementation
    extends ExtensionPointReaderExtensionImplementation {
    }

    public static class PNegative5ExtensionPointReaderExtensionImplementation
    extends ExtensionPointReaderExtensionImplementation {
    }
}

