/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.commons.tests.core;

import junit.framework.TestCase;
import org.eclipse.mylyn.commons.core.CoreUtil;
import org.eclipse.osgi.service.resolver.VersionRange;
import org.osgi.framework.Version;

public class CoreUtilTest
extends TestCase {
    public void testCompareNullNull() {
        CoreUtilTest.assertEquals((int)0, (int)CoreUtil.compare(null, null));
    }

    public void testCompareNullString() {
        CoreUtilTest.assertEquals((int)1, (int)CoreUtil.compare(null, (Object)"abc"));
    }

    public void testCompareNumbersBigger() {
        CoreUtilTest.assertEquals((int)1, (int)CoreUtil.compare((Comparable)Integer.valueOf(4), (Object)2));
    }

    public void testCompareNumbersEquals() {
        CoreUtilTest.assertEquals((int)0, (int)CoreUtil.compare((Comparable)Integer.valueOf(-4), (Object)-4));
    }

    public void testCompareNumbersNull() {
        CoreUtilTest.assertEquals((int)1, (int)CoreUtil.compare(null, (Object)2));
    }

    public void testCompareNumbersSmaller() {
        CoreUtilTest.assertEquals((int)-1, (int)CoreUtil.compare((Comparable)Integer.valueOf(1), (Object)2));
    }

    public void testCompareStringNull() {
        CoreUtilTest.assertEquals((int)-1, (int)CoreUtil.compare((Comparable)((Object)"abc"), null));
    }

    public void testPropertyEquallsNullFalse() {
        CoreUtilTest.assertFalse((boolean)CoreUtil.propertyEquals((boolean)false, null));
    }

    public void testPropertyEquallsNullTrue() {
        CoreUtilTest.assertTrue((boolean)CoreUtil.propertyEquals((boolean)true, null));
    }

    public void testPropertyEqualsBooleanTrue() {
        CoreUtilTest.assertTrue((boolean)CoreUtil.propertyEquals((boolean)true, (Object)Boolean.TRUE));
    }

    public void testPropertyEqualsNumbe() {
        CoreUtilTest.assertFalse((boolean)CoreUtil.propertyEquals((boolean)true, (Object)1));
    }

    public void testPropertyEqualsStringFalse() {
        CoreUtilTest.assertFalse((boolean)CoreUtil.propertyEquals((boolean)false, (Object)"false"));
    }

    public void testPropertyEqualsStringFalseUnexpected() {
        CoreUtilTest.assertFalse((boolean)CoreUtil.propertyEquals((boolean)true, (Object)"false"));
    }

    public void testPropertyEqualsStringTrue() {
        CoreUtilTest.assertFalse((boolean)CoreUtil.propertyEquals((boolean)true, (Object)"true"));
    }

    public void testAreEqualEqualStrings() {
        CoreUtilTest.assertTrue((boolean)CoreUtil.areEqual((Object)"a", (Object)"a"));
    }

    public void testAreEqualSameObject() {
        Object o = new Object();
        CoreUtilTest.assertTrue((boolean)CoreUtil.areEqual((Object)o, (Object)o));
    }

    public void testAreEqualNull() {
        CoreUtilTest.assertTrue((boolean)CoreUtil.areEqual(null, null));
    }

    public void testAreEqualRightNotNull() {
        CoreUtilTest.assertFalse((boolean)CoreUtil.areEqual(null, (Object)new Object()));
    }

    public void testAreEqualLeftNotNull() {
        CoreUtilTest.assertFalse((boolean)CoreUtil.areEqual((Object)new Object(), null));
    }

    public void testAreEqualUnequalObject() {
        CoreUtilTest.assertFalse((boolean)CoreUtil.areEqual((Object)1, (Object)"a"));
    }

    public void testAreEqualUnequalStrings() {
        CoreUtilTest.assertFalse((boolean)CoreUtil.areEqual((Object)"a", (Object)"b"));
    }

    public void testGetRuntimeVersion() {
        String oldValue = System.setProperty("java.runtime.version", "1.5.0_2");
        try {
            CoreUtilTest.assertEquals((Object)new Version(1, 5, 0, "2"), (Object)CoreUtil.getRuntimeVersion());
        }
        finally {
            System.setProperty("java.runtime.version", oldValue);
        }
    }

    public void testGetRuntimeVersionShort() {
        String oldValue = System.setProperty("java.runtime.version", "1.7");
        try {
            CoreUtilTest.assertEquals((Object)new Version(1, 7, 0), (Object)CoreUtil.getRuntimeVersion());
        }
        finally {
            System.setProperty("java.runtime.version", oldValue);
        }
    }

    public void testGetRuntimeVersionLetters() {
        String oldValue = System.setProperty("java.runtime.version", "1.7-CUSTOM");
        try {
            CoreUtilTest.assertEquals((Object)new Version(1, 7, 0), (Object)CoreUtil.getRuntimeVersion());
        }
        finally {
            System.setProperty("java.runtime.version", oldValue);
        }
    }

    public void testGetRuntimeVersionTrailingUnderscore() {
        String oldValue = System.setProperty("java.runtime.version", "1.5.0_");
        try {
            CoreUtilTest.assertEquals((Object)new Version(1, 5, 0), (Object)CoreUtil.getRuntimeVersion());
        }
        finally {
            System.setProperty("java.runtime.version", oldValue);
        }
    }

    public void testGetRuntimeVersionNoQualifier() {
        String oldValue = System.setProperty("java.runtime.version", "1.2.0");
        try {
            CoreUtilTest.assertEquals((Object)new Version(1, 2, 0), (Object)CoreUtil.getRuntimeVersion());
        }
        finally {
            System.setProperty("java.runtime.version", oldValue);
        }
    }

    public void testGetRuntimeVersionProperty() {
        String oldValue1 = System.setProperty("java.runtime.version", "1.2.0");
        String oldValue2 = System.setProperty("java.version", "1.3.0");
        try {
            CoreUtilTest.assertEquals((Object)new Version(1, 2, 0), (Object)CoreUtil.getRuntimeVersion());
        }
        finally {
            System.setProperty("java.runtime.version", oldValue1);
            System.setProperty("java.version", oldValue2);
        }
    }

    public void testGetRuntimeVersionPropertyNull() {
        String oldValue1 = System.clearProperty("java.runtime.version");
        String oldValue2 = System.setProperty("java.version", "1.3.0");
        try {
            CoreUtilTest.assertEquals((Object)new Version(1, 3, 0), (Object)CoreUtil.getRuntimeVersion());
        }
        finally {
            System.setProperty("java.runtime.version", oldValue1);
            System.setProperty("java.version", oldValue2);
        }
    }

    public void testGetRuntimeVersionMatch() {
        String oldValue = System.setProperty("java.runtime.version", "1.6.0_26");
        try {
            CoreUtilTest.assertFalse((boolean)new VersionRange("[0.0.0,1.6.0.25]").isIncluded(CoreUtil.getRuntimeVersion()));
            CoreUtilTest.assertTrue((boolean)new VersionRange("[0.0.0,1.6.0.26]").isIncluded(CoreUtil.getRuntimeVersion()));
        }
        finally {
            System.setProperty("java.runtime.version", oldValue);
        }
    }

    public void testAsFileName() {
        CoreUtilTest.assertEquals((String)"abc", (String)CoreUtil.asFileName((String)"abc"));
        CoreUtilTest.assertEquals((String)"a.b.c", (String)CoreUtil.asFileName((String)"a.b.c"));
        CoreUtilTest.assertEquals((String)"", (String)CoreUtil.asFileName((String)""));
    }

    public void testAsFileNameSpaces() {
        CoreUtilTest.assertEquals((String)"%20%20", (String)CoreUtil.asFileName((String)"  "));
        CoreUtilTest.assertEquals((String)".%20", (String)CoreUtil.asFileName((String)". "));
    }

    public void testAsFileNamePercent() {
        CoreUtilTest.assertEquals((String)"%25abc", (String)CoreUtil.asFileName((String)"%abc"));
        CoreUtilTest.assertEquals((String)"%2525abc", (String)CoreUtil.asFileName((String)"%25abc"));
    }

    public void testDecode() {
        CoreUtilTest.assertEquals((String)"abc", (String)CoreUtil.encode((String)"abc"));
        CoreUtilTest.assertEquals((String)"%2D_", (String)CoreUtil.encode((String)"-"));
        CoreUtilTest.assertEquals((String)"abc%2D_123", (String)CoreUtil.encode((String)"abc-123"));
        CoreUtilTest.assertEquals((String)"", (String)CoreUtil.encode((String)""));
    }

    public void testDecodeInvalid() {
        String s2;
        try {
            s2 = CoreUtil.decode((String)"abc-123");
            CoreUtilTest.fail((String)("Expected IllegalArgumentException, got '" + s2 + "'"));
        }
        catch (IllegalArgumentException s2) {
            // empty catch block
        }
        try {
            s2 = CoreUtil.decode((String)"%Z_");
            CoreUtilTest.fail((String)("Expected IllegalArgumentException, got '" + s2 + "'"));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testEncode() {
        CoreUtilTest.assertEquals((String)"abc", (String)CoreUtil.decode((String)"abc"));
        CoreUtilTest.assertEquals((String)"-", (String)CoreUtil.decode((String)"%2D_"));
        CoreUtilTest.assertEquals((String)"abc-123", (String)CoreUtil.decode((String)"abc%2D_123"));
        CoreUtilTest.assertEquals((String)"abc-123", (String)CoreUtil.decode((String)CoreUtil.decode((String)CoreUtil.encode((String)CoreUtil.encode((String)"abc-123")))));
    }
}

