/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.commons.tests.core;

import java.util.Iterator;
import junit.framework.TestCase;
import org.eclipse.mylyn.commons.core.CommonListenerList;

public class CommonListenerListTest
extends TestCase {
    public void testAddRemove() {
        Listener addedListener = new Listener();
        CommonListenerList list = new CommonListenerList("a");
        list.add((Object)addedListener);
        CommonListenerListTest.assertTrue((boolean)list.iterator().hasNext());
        CommonListenerListTest.assertSame((Object)addedListener, list.iterator().next());
        list.remove((Object)addedListener);
        CommonListenerListTest.assertFalse((boolean)list.iterator().hasNext());
    }

    public void testAddTwice() {
        Listener addedListener = new Listener();
        CommonListenerList list = new CommonListenerList("a");
        list.add((Object)addedListener);
        list.add((Object)addedListener);
        Iterator iterator = list.iterator();
        CommonListenerListTest.assertTrue((boolean)iterator.hasNext());
        iterator.next();
        CommonListenerListTest.assertFalse((boolean)iterator.hasNext());
    }

    public void testIterator() {
        Listener listener1 = new Listener();
        Listener listener2 = new Listener();
        Listener listener3 = new Listener();
        CommonListenerList list = new CommonListenerList("a");
        list.add((Object)listener1);
        list.add((Object)listener2);
        list.add((Object)listener3);
        list.add((Object)listener1);
        Iterator iterator = list.iterator();
        CommonListenerListTest.assertSame((Object)listener1, iterator.next());
        CommonListenerListTest.assertSame((Object)listener2, iterator.next());
        CommonListenerListTest.assertSame((Object)listener3, iterator.next());
    }

    public void testNotify() {
        final Listener addedListener = new Listener();
        CommonListenerList list = new CommonListenerList("a");
        list.add((Object)addedListener);
        list.notify((CommonListenerList.Notifier)new CommonListenerList.Notifier<Listener>(){

            public void run(Listener listener) throws Exception {
                CommonListenerListTest.assertSame((Object)listener, (Object)addedListener);
                addedListener.notified = true;
            }
        });
        CommonListenerListTest.assertTrue((boolean)addedListener.notified);
    }

    public void testNotifyException() {
        final Listener addedListener = new Listener();
        CommonListenerList list = new CommonListenerList("a");
        list.add((Object)addedListener);
        list.notify((CommonListenerList.Notifier)new CommonListenerList.Notifier<Listener>(){

            public void run(Listener listener) throws Exception {
                throw new LinkageError("Deliberately thrown by testNotifyException to check handling of LinkageError.");
            }
        });
        CommonListenerListTest.assertFalse((boolean)list.iterator().hasNext());
        list.notify((CommonListenerList.Notifier)new CommonListenerList.Notifier<Listener>(){

            public void run(Listener listener) throws Exception {
                addedListener.notified = true;
            }
        });
        CommonListenerListTest.assertFalse((boolean)addedListener.notified);
    }

    private class Listener {
        private boolean notified;

        private Listener() {
        }
    }
}

