/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.commons.core;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.text.ParseException;
import junit.framework.TestCase;
import org.eclipse.mylyn.commons.core.HtmlStreamTokenizer;
import org.eclipse.mylyn.commons.core.HtmlTag;

public class HtmlStreamTokenizerTest
extends TestCase {
    public void testDivSelfTerminatingNoSpace() throws IOException, ParseException {
        HtmlStreamTokenizer htmlStreamTokenizer = new HtmlStreamTokenizer((Reader)new StringReader("<div/>"), null);
        HtmlStreamTokenizer.Token token = htmlStreamTokenizer.nextToken();
        HtmlStreamTokenizerTest.assertEquals((String)"div", (String)((HtmlTag)token.getValue()).getTagName());
        HtmlStreamTokenizerTest.assertTrue((boolean)((HtmlTag)token.getValue()).isSelfTerminating());
    }

    public void testDivSelfTerminatingLeadingSpace() throws IOException, ParseException {
        HtmlStreamTokenizer htmlStreamTokenizer = new HtmlStreamTokenizer((Reader)new StringReader("<div />"), null);
        HtmlStreamTokenizer.Token token = htmlStreamTokenizer.nextToken();
        HtmlStreamTokenizerTest.assertEquals((String)"div", (String)((HtmlTag)token.getValue()).getTagName());
        HtmlStreamTokenizerTest.assertTrue((boolean)((HtmlTag)token.getValue()).isSelfTerminating());
    }

    public void testDivSelfTerminatingLeadingSpacePendingSpace() throws IOException, ParseException {
        HtmlStreamTokenizer htmlStreamTokenizer = new HtmlStreamTokenizer((Reader)new StringReader("<div / >"), null);
        HtmlStreamTokenizer.Token token = htmlStreamTokenizer.nextToken();
        HtmlStreamTokenizerTest.assertEquals((String)"div", (String)((HtmlTag)token.getValue()).getTagName());
        HtmlStreamTokenizerTest.assertTrue((boolean)((HtmlTag)token.getValue()).isSelfTerminating());
    }

    public void testDivSelfTerminatingPendingSpace() throws IOException, ParseException {
        HtmlStreamTokenizer htmlStreamTokenizer = new HtmlStreamTokenizer((Reader)new StringReader("<div/ >"), null);
        HtmlStreamTokenizer.Token token = htmlStreamTokenizer.nextToken();
        HtmlStreamTokenizerTest.assertEquals((String)"div", (String)((HtmlTag)token.getValue()).getTagName());
        HtmlStreamTokenizerTest.assertTrue((boolean)((HtmlTag)token.getValue()).isSelfTerminating());
    }

    public void testImgSelfTerminatingNoSpace() throws IOException, ParseException {
        HtmlStreamTokenizer htmlStreamTokenizer = new HtmlStreamTokenizer((Reader)new StringReader("<img src=\"test.png\"/>"), null);
        HtmlStreamTokenizer.Token token = htmlStreamTokenizer.nextToken();
        HtmlStreamTokenizerTest.assertEquals((String)"img", (String)((HtmlTag)token.getValue()).getTagName());
        HtmlStreamTokenizerTest.assertTrue((boolean)((HtmlTag)token.getValue()).isSelfTerminating());
    }

    public void testImgSelfTerminatingLeadingSpace() throws IOException, ParseException {
        HtmlStreamTokenizer htmlStreamTokenizer = new HtmlStreamTokenizer((Reader)new StringReader("<img src=\"test.png\" />"), null);
        HtmlStreamTokenizer.Token token = htmlStreamTokenizer.nextToken();
        HtmlStreamTokenizerTest.assertEquals((String)"img", (String)((HtmlTag)token.getValue()).getTagName());
        HtmlStreamTokenizerTest.assertTrue((boolean)((HtmlTag)token.getValue()).isSelfTerminating());
    }

    public void testImgSelfTerminatingLeadingSpacePendingSpace() throws IOException, ParseException {
        HtmlStreamTokenizer htmlStreamTokenizer = new HtmlStreamTokenizer((Reader)new StringReader("<img src=\"test.png\" / >"), null);
        HtmlStreamTokenizer.Token token = htmlStreamTokenizer.nextToken();
        HtmlStreamTokenizerTest.assertEquals((String)"img", (String)((HtmlTag)token.getValue()).getTagName());
        HtmlStreamTokenizerTest.assertTrue((boolean)((HtmlTag)token.getValue()).isSelfTerminating());
    }

    public void testImgSelfTerminatingPendingSpace() throws IOException, ParseException {
        HtmlStreamTokenizer htmlStreamTokenizer = new HtmlStreamTokenizer((Reader)new StringReader("<img src=\"test.png\"/ >"), null);
        HtmlStreamTokenizer.Token token = htmlStreamTokenizer.nextToken();
        HtmlStreamTokenizerTest.assertEquals((String)"img", (String)((HtmlTag)token.getValue()).getTagName());
        HtmlStreamTokenizerTest.assertTrue((boolean)((HtmlTag)token.getValue()).isSelfTerminating());
    }
}

