/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.commons.repositories.tests.ui;

import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.mylyn.commons.workbench.WorkbenchUtil;
import org.eclipse.mylyn.internal.commons.repositories.ui.EmptyRepositoryCategoriesFilter;
import org.eclipse.mylyn.internal.commons.repositories.ui.RepositoriesView;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class RepositoriesViewTest {
    @Before
    public void setUp() throws Exception {
        WorkbenchUtil.showViewInActiveWindow((String)"org.eclipse.mylyn.commons.repositories.ui.navigator.Repositories");
    }

    @After
    public void tearDown() throws Exception {
        WorkbenchUtil.closeViewInActiveWindow((String)"org.eclipse.mylyn.commons.repositories.ui.navigator.Repositories");
    }

    @Test
    public void testRepositoriesViewNoFilter() {
        RepositoriesView view = (RepositoriesView)WorkbenchUtil.findViewInActiveWindow((String)"org.eclipse.mylyn.commons.repositories.ui.navigator.Repositories");
        Assert.assertNotNull((Object)view);
        ViewerFilter[] filters = view.getCommonViewer().getFilters();
        Assert.assertNotNull((Object)filters);
        Assert.assertEquals((long)1L, (long)filters.length);
        Assert.assertTrue((boolean)(filters[0] instanceof EmptyRepositoryCategoriesFilter));
        EmptyRepositoryCategoriesFilter emptyFilter = (EmptyRepositoryCategoriesFilter)filters[0];
        view.getCommonViewer().removeFilter((ViewerFilter)emptyFilter);
        Tree tree = view.getCommonViewer().getTree();
        Assert.assertNotNull((Object)tree);
        TreeItem[] treeItems = tree.getItems();
        Assert.assertNotNull((Object)treeItems);
        Assert.assertEquals((long)6L, (long)treeItems.length);
        Assert.assertEquals((Object)"Tasks", (Object)treeItems[0].getText());
        Assert.assertEquals((Object)"Bugs", (Object)treeItems[1].getText());
        Assert.assertEquals((Object)"Builds", (Object)treeItems[2].getText());
        Assert.assertEquals((Object)"Reviews", (Object)treeItems[3].getText());
        Assert.assertEquals((Object)"Requirements", (Object)treeItems[4].getText());
        Assert.assertEquals((Object)"Other", (Object)treeItems[5].getText());
    }
}

