/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.commons.repositories.tests.core;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.runtime.jobs.ILock;
import org.eclipse.mylyn.internal.commons.repositories.ui.UiLocationService;
import org.eclipse.mylyn.internal.commons.repositories.ui.UiSecureCredentialsStore;
import org.eclipse.swt.widgets.Display;
import org.junit.Assert;
import org.junit.Test;

public class UiSecureCredentialsStoreTest {
    private static final String DEADLOCK_ERROR_MESSAGE = "Aborting request to prevent deadlock accessing secure storage";

    protected TestSecureCredentialsStore createCredentialsStore() {
        TestSecureCredentialsStore store = new TestSecureCredentialsStore();
        store.clear();
        return store;
    }

    @Test
    public void testUiLocationService() throws Exception {
        Assert.assertTrue((boolean)(new UiLocationService().getCredentialsStore("test") instanceof UiSecureCredentialsStore));
    }

    @Test
    public void testDetectDeadlockOnUiThread() throws Exception {
        Assert.assertNotNull((Object)Display.getCurrent());
        TestSecureCredentialsStore store = this.createCredentialsStore();
        store.put("key", "value", true);
        final ILock lock = store.getLock();
        Assert.assertNotNull((Object)lock);
        final AtomicBoolean lockAcquired = new AtomicBoolean(false);
        final AtomicBoolean lockReleased = new AtomicBoolean(false);
        final AtomicBoolean done = new AtomicBoolean(false);
        try {
            this.runOnBackgroundThread(false, new Runnable(){

                @Override
                public void run() {
                    try {
                        try {
                            Assert.assertTrue((boolean)lock.acquire(3000L));
                            lockAcquired.set(true);
                            while (!done.get()) {
                            }
                        }
                        catch (InterruptedException e) {
                            Assert.fail((String)"Interrupted trying to acquire SecurePreferencesRoot lock");
                            lock.release();
                            lockReleased.set(true);
                        }
                    }
                    finally {
                        lock.release();
                        lockReleased.set(true);
                    }
                }
            });
            while (!lockAcquired.get()) {
            }
            try {
                store.get("key", null);
                Assert.fail((String)"Expected exception");
            }
            catch (RuntimeException e) {
                Assert.assertEquals((Object)DEADLOCK_ERROR_MESSAGE, (Object)e.getMessage());
            }
            try {
                store.put("key", "newValue", true);
                Assert.fail((String)"Expected exception");
            }
            catch (RuntimeException e) {
                Assert.assertEquals((Object)DEADLOCK_ERROR_MESSAGE, (Object)e.getMessage());
            }
        }
        finally {
            done.set(true);
        }
        while (!lockReleased.get()) {
        }
        Assert.assertEquals((Object)"value", (Object)store.get("key", null));
        store.put("key", "newValue", true);
        Assert.assertEquals((Object)"newValue", (Object)store.get("key", null));
    }

    @Test
    public void testDoNotDetectDeadlockWhenUiThreadAlreadyHoldsLock() throws Exception {
        Assert.assertNotNull((Object)Display.getCurrent());
        TestSecureCredentialsStore store = this.createCredentialsStore();
        store.put("key", "value", true);
        ILock lock = store.getLock();
        Assert.assertNotNull((Object)lock);
        try {
            try {
                Assert.assertTrue((boolean)lock.acquire(3000L));
                Assert.assertEquals((Object)"value", (Object)store.get("key", null));
                store.put("key", "newValue", true);
                Assert.assertEquals((Object)"newValue", (Object)store.get("key", null));
            }
            catch (InterruptedException e) {
                Assert.fail((String)"Interrupted trying to acquire SecurePreferencesRoot lock");
                lock.release();
            }
        }
        finally {
            lock.release();
        }
    }

    @Test
    public void testDetectDeadlockOnBackgroundThread() throws Exception {
        TestSecureCredentialsStore store;
        block5: {
            Assert.assertNotNull((Object)Display.getCurrent());
            store = this.createCredentialsStore();
            store.put("key", "value", true);
            ILock lock = store.getLock();
            Assert.assertNotNull((Object)lock);
            try {
                try {
                    Assert.assertTrue((boolean)lock.acquire(3000L));
                    this.runOnBackgroundThread(true, new Runnable(){

                        @Override
                        public void run() {
                            try {
                                store.get("key", null);
                                Assert.fail((String)"Expected exception");
                            }
                            catch (RuntimeException e) {
                                Assert.assertEquals((Object)UiSecureCredentialsStoreTest.DEADLOCK_ERROR_MESSAGE, (Object)e.getMessage());
                            }
                            try {
                                store.put("key", "newValue", true);
                                Assert.fail((String)"Expected exception");
                            }
                            catch (RuntimeException e) {
                                Assert.assertEquals((Object)UiSecureCredentialsStoreTest.DEADLOCK_ERROR_MESSAGE, (Object)e.getMessage());
                            }
                        }
                    });
                }
                catch (InterruptedException e) {
                    Assert.fail((String)"Interrupted trying to acquire SecurePreferencesRoot lock");
                    lock.release();
                    break block5;
                }
            }
            catch (Throwable throwable) {
                lock.release();
                throw throwable;
            }
            lock.release();
        }
        this.runOnBackgroundThread(true, new Runnable(){

            @Override
            public void run() {
                Assert.assertEquals((Object)"value", (Object)store.get("key", null));
                store.put("key", "newValue", true);
                Assert.assertEquals((Object)"newValue", (Object)store.get("key", null));
            }
        });
    }

    protected void runOnBackgroundThread(boolean join, final Runnable runnable) throws AssertionError {
        final AtomicReference assertionError = new AtomicReference();
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    runnable.run();
                }
                catch (AssertionError e) {
                    assertionError.set(e);
                }
            }
        });
        thread.start();
        if (join) {
            try {
                thread.join();
            }
            catch (InterruptedException e) {
                Assert.fail((String)"Interrupted while joining thread");
            }
        }
        if (assertionError.get() != null) {
            throw (AssertionError)assertionError.get();
        }
    }

    @Test
    public void testRunOnBackgroundThread() throws Exception {
        try {
            this.runOnBackgroundThread(true, new Runnable(){

                @Override
                public void run() {
                    Assert.fail();
                }
            });
        }
        catch (AssertionError e) {
            return;
        }
        Assert.fail((String)"Expected AssertionError");
    }

    private class TestSecureCredentialsStore
    extends UiSecureCredentialsStore {
        public TestSecureCredentialsStore() {
            super(UiSecureCredentialsStoreTest.class.getName());
        }

        public ILock getLock() {
            return UiSecureCredentialsStore.getSecurePreferencesRootLock();
        }
    }
}

