/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.commons.repositories.tests.core;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Arrays;
import org.eclipse.equinox.security.storage.ISecurePreferences;
import org.eclipse.equinox.security.storage.StorageException;
import org.eclipse.mylyn.commons.repositories.core.auth.UnavailableException;
import org.eclipse.mylyn.commons.repositories.tests.core.AbstractCredentialsStoreTest;
import org.eclipse.mylyn.commons.repositories.tests.support.DelegatingSecurePreferences;
import org.eclipse.mylyn.internal.commons.repositories.core.InMemoryCredentialsStore;
import org.eclipse.mylyn.internal.commons.repositories.core.SecureCredentialsStore;
import org.junit.Assert;
import org.junit.Test;

public class SecureCredentialsStoreTest
extends AbstractCredentialsStoreTest {
    @Test
    public void testClear() {
        StubSecureCredentialsStore store = this.createStubSecureCredentialsStore();
        store.put("key", "value", false);
        Assert.assertEquals((Object)"[key]", (Object)Arrays.toString(store.getSecurePreferences().keys()));
        store.clear();
        Assert.assertEquals((Object)"[]", (Object)Arrays.toString(store.getSecurePreferences().keys()));
    }

    @Test
    public void testGetId() {
        SecureCredentialsStore store = this.createCredentialsStore();
        Assert.assertEquals((Object)SecureCredentialsStoreTest.class.getName(), (Object)store.getId());
    }

    protected SecureCredentialsStore createCredentialsStore() {
        SecureCredentialsStore store = new SecureCredentialsStore(SecureCredentialsStoreTest.class.getName());
        store.clear();
        return store;
    }

    private StubSecureCredentialsStore createStubSecureCredentialsStore() {
        StubSecureCredentialsStore store = new StubSecureCredentialsStore();
        store.clear();
        return store;
    }

    private StubSecureCredentialsStore createStubSecureCredentialsStore(String id) {
        StubSecureCredentialsStore store = new StubSecureCredentialsStore(id);
        store.clear();
        return store;
    }

    @Test
    public void testKeysInSecurePreferences() {
        StubSecureCredentialsStore store = this.createStubSecureCredentialsStore();
        store.put("key", "value", false);
        Assert.assertEquals((Object)"[key]", (Object)Arrays.toString(store.getSecurePreferences().keys()));
        Assert.assertEquals((Object)"[]", (Object)Arrays.toString(store.getInMemoryStore().keys()));
    }

    @Test
    public void testKeysInSecurePreferencesNoPersist() {
        StubSecureCredentialsStore store = this.createStubSecureCredentialsStore();
        store.put("key", "value", false, false);
        Assert.assertEquals((Object)"[]", (Object)Arrays.toString(store.getSecurePreferences().keys()));
        Assert.assertEquals((Object)"[key]", (Object)Arrays.toString(store.getInMemoryStore().keys()));
    }

    @Test
    public void testKeysInSecurePreferencesEncryptNoPersist() {
        StubSecureCredentialsStore store = this.createStubSecureCredentialsStore();
        store.put("key", "value", true, false);
        Assert.assertEquals((Object)"[]", (Object)Arrays.toString(store.getSecurePreferences().keys()));
        Assert.assertEquals((Object)"[key]", (Object)Arrays.toString(store.getInMemoryStore().keys()));
    }

    @Test
    public void testKeysInSecurePreferencesNoPersistClear() {
        StubSecureCredentialsStore store = this.createStubSecureCredentialsStore();
        store.put("key", "value", false, false);
        store.clear();
        Assert.assertEquals((Object)"[]", (Object)Arrays.toString(store.getSecurePreferences().keys()));
        Assert.assertEquals((Object)"[]", (Object)Arrays.toString(store.getInMemoryStore().keys()));
    }

    @Test
    public void testPutException() {
        StubSecureCredentialsStore store = this.createStubSecureCredentialsStore();
        store.getSecurePreferences().setException(new StorageException(0, ""));
        store.put("key", "value", true);
        Assert.assertEquals((Object)"[]", (Object)Arrays.toString(store.getSecurePreferences().keys()));
        Assert.assertEquals((Object)"value", (Object)store.getInMemoryStore().get("key", null));
        Assert.assertEquals((Object)"value", (Object)store.get("key", null));
    }

    @Test
    public void testPutExceptionNoException() {
        StubSecureCredentialsStore store = this.createStubSecureCredentialsStore();
        store.getSecurePreferences().setException(new StorageException(0, ""));
        store.put("key", "value", true);
        store.getSecurePreferences().setException(null);
        store.put("key", "value", true);
        Assert.assertEquals((Object)"[key]", (Object)Arrays.toString(store.getSecurePreferences().keys()));
        Assert.assertEquals(null, (Object)store.getInMemoryStore().get("key", null));
        Assert.assertEquals((Object)"value", (Object)store.get("key", null));
    }

    @Test
    public void testSpecialCharactersInId() {
        StubSecureCredentialsStore store = this.createStubSecureCredentialsStore("http://ci.mylyn.org/test 1");
        Assert.assertEquals((Object)"http://ci.mylyn.org/test 1", (Object)store.getId());
        Assert.assertEquals((Object)"http:\\2f\\2fci.mylyn.org\\2ftest 1", (Object)store.getSecurePreferences().name());
        store = this.createStubSecureCredentialsStore("http://ci.mylyn.org/\u00e7\u00f1\u00fc");
        Assert.assertEquals((Object)"http://ci.mylyn.org/\u00e7\u00f1\u00fc", (Object)store.getId());
        Assert.assertEquals((Object)"http%3A%2F%2Fci.mylyn.org%2F%C3%A7%C3%B1%C3%BC", (Object)store.getSecurePreferences().name());
        store = this.createStubSecureCredentialsStore("\uabcd  \u1f00");
        Assert.assertEquals((Object)"\uabcd  \u1f00", (Object)store.getId());
        Assert.assertEquals((Object)"%EA%AF%8D++%E1%BC%80", (Object)store.getSecurePreferences().name());
    }

    @Test
    public void testValidCharactersNotEncoded() {
        StringBuilder sb = new StringBuilder();
        char c = ' ';
        while (c <= '~') {
            if (c != '\\' && c != '/') {
                sb.append(c);
            }
            c = (char)(c + 1);
        }
        String key = sb.toString();
        StubSecureCredentialsStore store = this.createStubSecureCredentialsStore(key);
        Assert.assertEquals((Object)key, (Object)store.getId());
        Assert.assertEquals((Object)key, (Object)store.getSecurePreferences().name());
    }

    @Test
    public void testInvalidCharactersEncoded() throws UnsupportedEncodingException {
        char c = '\u0000';
        while (c < ' ') {
            this.assertInvalidCharacter(c);
            c = (char)(c + '\u0001');
        }
        c = '\u007f';
        while (c < '\u0100') {
            this.assertInvalidCharacter(c);
            c = (char)(c + '\u0001');
        }
    }

    private void assertInvalidCharacter(char c) throws UnsupportedEncodingException {
        String key = "key" + Character.toString(c);
        StubSecureCredentialsStore store = this.createStubSecureCredentialsStore(key);
        Assert.assertEquals((Object)key, (Object)store.getId());
        Assert.assertEquals((Object)("key" + URLEncoder.encode(Character.toString(c), "UTF-8")), (Object)store.getSecurePreferences().name());
    }

    @Test
    public void testSpecialCharactersInIdRetrieveValue() {
        StubSecureCredentialsStore store = this.createStubSecureCredentialsStore("http://ci.mylyn.org/\u00e7\u00f1\u00fc");
        store.put("key", "value", false);
        Assert.assertEquals((Object)"[key]", (Object)Arrays.toString(store.getSecurePreferences().keys()));
        Assert.assertEquals((Object)"value", (Object)store.get("key", null));
    }

    @Test
    public void testSpecialCharactersInIdRetrieveValueNoPersist() {
        StubSecureCredentialsStore store = this.createStubSecureCredentialsStore("http://ci.mylyn.org/\u00e7\u00f1\u00fc");
        store.put("key", "value", false, false);
        Assert.assertEquals((Object)"[key]", (Object)Arrays.toString(store.getInMemoryStore().keys()));
        Assert.assertEquals((Object)"value", (Object)store.get("key", null));
    }

    @Test
    public void testSpecialCharactersInIdRetrieveValueEncrypt() {
        StubSecureCredentialsStore store = this.createStubSecureCredentialsStore("http://ci.mylyn.org/\u00e7\u00f1\u00fc");
        store.put("key", "value", true);
        Assert.assertEquals((Object)"[key]", (Object)Arrays.toString(store.getSecurePreferences().keys()));
        Assert.assertEquals((Object)"value", (Object)store.get("key", null));
    }

    @Test
    public void testSpecialCharactersInIdRetrieveValueEncryptNoPersist() {
        StubSecureCredentialsStore store = this.createStubSecureCredentialsStore("http://ci.mylyn.org/\u00e7\u00f1\u00fc");
        store.put("key", "value", true, false);
        Assert.assertEquals((Object)"[key]", (Object)Arrays.toString(store.getInMemoryStore().keys()));
        Assert.assertEquals((Object)"value", (Object)store.get("key", null));
    }

    @Test
    public void testTestAvailability() throws Exception {
        StubSecureCredentialsStore store = this.createStubSecureCredentialsStore();
        Assert.assertNull((Object)store.get("org.eclipse.mylyn.commons.repositories.core.SecureCredentialsStore", null));
        store.testAvailability();
        Assert.assertNotNull((Object)store.get("org.eclipse.mylyn.commons.repositories.core.SecureCredentialsStore", null));
        store.setUnavailable(true);
        try {
            store.testAvailability();
            Assert.fail((String)"Expected UnavailableException");
        }
        catch (UnavailableException unavailableException) {
            // empty catch block
        }
    }

    private class StubSecureCredentialsStore
    extends SecureCredentialsStore {
        private boolean unavailable;
        DelegatingSecurePreferences delegate;

        public StubSecureCredentialsStore() {
            super(SecureCredentialsStore.class.getName());
        }

        public StubSecureCredentialsStore(String id) {
            super(id);
        }

        protected DelegatingSecurePreferences getSecurePreferences() {
            if (this.delegate == null) {
                this.delegate = new DelegatingSecurePreferences(this.getSecurePreferencesSuper()){

                    @Override
                    public void removeNode() {
                        super.removeNode();
                        this.setDelegate(StubSecureCredentialsStore.this.getSecurePreferencesSuper());
                    }

                    @Override
                    public String get(String key, String def) throws StorageException {
                        if (StubSecureCredentialsStore.this.unavailable) {
                            throw new StorageException(0, "Unavailable");
                        }
                        return super.get(key, def);
                    }
                };
            }
            return this.delegate;
        }

        ISecurePreferences getSecurePreferencesSuper() {
            return super.getSecurePreferences();
        }

        protected synchronized InMemoryCredentialsStore getInMemoryStore() {
            return super.getInMemoryStore();
        }

        public void setUnavailable(boolean unavailable) {
            this.unavailable = unavailable;
        }
    }
}

