/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.commons.repositories.tests.core;

import org.eclipse.mylyn.commons.repositories.core.auth.ICredentialsStore;
import org.eclipse.mylyn.commons.repositories.tests.core.AbstractCredentialsStoreTest;
import org.eclipse.mylyn.internal.commons.repositories.core.InMemoryCredentialsStore;
import org.junit.Assert;
import org.junit.Test;

public class InMemoryCredentialsStoreTest
extends AbstractCredentialsStoreTest {
    @Test
    public void testCopyToNullValue() {
        InMemoryCredentialsStore source = new InMemoryCredentialsStore();
        InMemoryCredentialsStore target = new InMemoryCredentialsStore();
        target.put("key", "value", false);
        source.put("key", null, false);
        source.copyTo((ICredentialsStore)target);
        Assert.assertEquals(null, (Object)target.get("key", null));
    }

    @Test
    public void testCopyTo() {
        InMemoryCredentialsStore source = new InMemoryCredentialsStore();
        InMemoryCredentialsStore target = new InMemoryCredentialsStore();
        source.put("key1", "value", true);
        source.copyTo((ICredentialsStore)target);
        Assert.assertEquals((Object)"value", (Object)target.get("key1", null));
    }

    @Test
    public void testCopyToRemove() {
        InMemoryCredentialsStore source = new InMemoryCredentialsStore();
        InMemoryCredentialsStore target = new InMemoryCredentialsStore();
        target.put("key", "value", true);
        source.remove("key");
        source.copyTo((ICredentialsStore)target);
        Assert.assertEquals(null, (Object)target.get("key", null));
    }

    @Test
    public void testGetStore() {
        InMemoryCredentialsStore store = InMemoryCredentialsStore.getStore((String)"test-store");
        Assert.assertNotNull((Object)store);
        Assert.assertSame((Object)store, (Object)InMemoryCredentialsStore.getStore((String)"test-store"));
        Assert.assertNotSame((Object)store, (Object)InMemoryCredentialsStore.getStore((String)"test-store2"));
    }

    @Test
    public void testParentPutGetString() {
        InMemoryCredentialsStore parent = new InMemoryCredentialsStore();
        InMemoryCredentialsStore store = new InMemoryCredentialsStore((ICredentialsStore)parent);
        parent.put("key", "parentValue", false);
        Assert.assertEquals((Object)"parentValue", (Object)store.get("key", null));
        store.put("key", "value", false);
        Assert.assertEquals((Object)"value", (Object)store.get("key", null));
    }

    @Test
    public void testParentCopyToRemove() {
        InMemoryCredentialsStore parent = new InMemoryCredentialsStore();
        InMemoryCredentialsStore store = new InMemoryCredentialsStore((ICredentialsStore)parent);
        parent.put("key", "parentValue", false);
        store.remove("key");
        Assert.assertEquals((Object)"parentValue", (Object)store.get("key", null));
        parent.remove("key");
        Assert.assertEquals(null, (Object)store.get("key", null));
    }

    @Test
    public void testTestAvailability() throws Exception {
        InMemoryCredentialsStore store = this.createCredentialsStore();
        store.testAvailability();
    }

    @Test
    public void testGetId() {
        Assert.assertEquals((Object)"id", (Object)InMemoryCredentialsStore.getStore((String)"id").getId());
    }

    protected InMemoryCredentialsStore createCredentialsStore() {
        return new InMemoryCredentialsStore();
    }
}

