/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.commons.repositories.tests.core;

import java.util.Arrays;
import org.eclipse.mylyn.commons.repositories.core.auth.ICredentialsStore;
import org.eclipse.mylyn.internal.commons.repositories.core.InMemoryCredentialsStore;
import org.eclipse.mylyn.internal.commons.repositories.core.SecureCredentialsStore;
import org.junit.Assert;
import org.junit.Test;

public class CredentialsStoreTest {
    @Test
    public void testCopyInMemoryToSecure() {
        InMemoryCredentialsStore source = new InMemoryCredentialsStore();
        SecureCredentialsStore target = new SecureCredentialsStore(CredentialsStoreTest.class.getName());
        target.clear();
        this.putValues((ICredentialsStore)source);
        source.copyTo((ICredentialsStore)target);
        this.assertValues((ICredentialsStore)target);
    }

    @Test
    public void testCopyInMemoryToInMemory() {
        InMemoryCredentialsStore source = new InMemoryCredentialsStore();
        InMemoryCredentialsStore target = new InMemoryCredentialsStore();
        this.putValues((ICredentialsStore)source);
        source.copyTo((ICredentialsStore)target);
        this.assertValues((ICredentialsStore)target);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testCopySecureToInMemory() {
        SecureCredentialsStore source = new SecureCredentialsStore(CredentialsStoreTest.class.getName());
        source.clear();
        InMemoryCredentialsStore target = new InMemoryCredentialsStore();
        source.copyTo((ICredentialsStore)target);
    }

    @Test
    public void testCopySecureToSecure() {
        SecureCredentialsStore source = new SecureCredentialsStore(CredentialsStoreTest.class.getName());
        source.clear();
        SecureCredentialsStore target = new SecureCredentialsStore(String.valueOf(CredentialsStoreTest.class.getName()) + "2");
        target.clear();
        this.putValues((ICredentialsStore)source);
        source.copyTo((ICredentialsStore)target);
        this.assertValues((ICredentialsStore)target);
    }

    private void assertValues(ICredentialsStore target) {
        Assert.assertEquals((Object)"value", (Object)target.get("key1", null));
        Assert.assertEquals((Object)true, (Object)target.getBoolean("key2", false));
        byte[] byArray = new byte[2];
        byArray[1] = 5;
        Assert.assertEquals((Object)Arrays.toString(byArray), (Object)Arrays.toString(target.getByteArray("key3", null)));
        Assert.assertEquals((Object)"value2", (Object)target.get("keyNotEncrypted", null));
    }

    private void putValues(ICredentialsStore source) {
        source.put("key1", "value", true);
        source.putBoolean("key2", true, true);
        byte[] byArray = new byte[2];
        byArray[1] = 5;
        source.putByteArray("key3", byArray, true);
        source.put("keyNotEncrypted", "value2", false);
    }
}

