/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.commons.repositories.tests.core;

import org.eclipse.equinox.security.storage.StorageException;
import org.eclipse.mylyn.commons.repositories.core.auth.AuthenticationCredentials;
import org.eclipse.mylyn.commons.repositories.core.auth.CertificateCredentials;
import org.eclipse.mylyn.commons.repositories.core.auth.ICredentialsStore;
import org.eclipse.mylyn.commons.repositories.core.auth.OpenIdCredentials;
import org.eclipse.mylyn.commons.repositories.core.auth.UserCredentials;
import org.eclipse.mylyn.internal.commons.repositories.core.CredentialsFactory;
import org.eclipse.mylyn.internal.commons.repositories.core.InMemoryCredentialsStore;
import org.junit.Assert;
import org.junit.Test;

public class CredentialsFactoryTest {
    @Test(expected=RuntimeException.class)
    public void testCreateInvalidCredentials() {
        InMemoryCredentialsStore store = new InMemoryCredentialsStore();
        AuthenticationCredentials credentials = new AuthenticationCredentials(){

            public void save(ICredentialsStore store, String prefix) {
            }

            public void clear(ICredentialsStore store, String prefix) {
            }
        };
        CredentialsFactory.create(credentials.getClass(), (ICredentialsStore)store, (String)"key", (boolean)false);
    }

    @Test
    public void testCreateUserCredentials() {
        InMemoryCredentialsStore store = new InMemoryCredentialsStore();
        UserCredentials credentials = (UserCredentials)CredentialsFactory.create(UserCredentials.class, (ICredentialsStore)store, (String)"key", (boolean)false);
        Assert.assertEquals((Object)"", (Object)credentials.getUserName());
        Assert.assertEquals((Object)"", (Object)credentials.getPassword());
        Assert.assertEquals(null, (Object)credentials.getDomain());
        Assert.assertEquals((Object)false, (Object)credentials.getSavePassword());
    }

    @Test
    public void testSaveUserCredentials() throws StorageException {
        InMemoryCredentialsStore store = new InMemoryCredentialsStore();
        UserCredentials oldCredentials = new UserCredentials("user", "password", "domain", false);
        oldCredentials.save((ICredentialsStore)store, "key");
        UserCredentials newCredentials = (UserCredentials)CredentialsFactory.create(UserCredentials.class, (ICredentialsStore)store, (String)"key", (boolean)true);
        Assert.assertNotSame((Object)oldCredentials, (Object)newCredentials);
        Assert.assertEquals((Object)oldCredentials, (Object)newCredentials);
    }

    @Test
    public void testCreateCertificateCredentials() {
        InMemoryCredentialsStore store = new InMemoryCredentialsStore();
        CertificateCredentials credentials = (CertificateCredentials)CredentialsFactory.create(CertificateCredentials.class, (ICredentialsStore)store, (String)"key", (boolean)false);
        Assert.assertEquals(null, (Object)credentials.getKeyStoreFileName());
        Assert.assertEquals((Object)"", (Object)credentials.getPassword());
    }

    @Test
    public void testSaveCertificateCredentials() throws StorageException {
        InMemoryCredentialsStore store = new InMemoryCredentialsStore();
        CertificateCredentials oldCredentials = new CertificateCredentials("keyStore", "password", "type");
        oldCredentials.save((ICredentialsStore)store, "key");
        CertificateCredentials newCredentials = (CertificateCredentials)CredentialsFactory.create(CertificateCredentials.class, (ICredentialsStore)store, (String)"key", (boolean)true);
        Assert.assertNotSame((Object)oldCredentials, (Object)newCredentials);
        Assert.assertEquals((Object)oldCredentials, (Object)newCredentials);
    }

    @Test
    public void testCreateOpenIdCredentials() {
        InMemoryCredentialsStore store = new InMemoryCredentialsStore();
        OpenIdCredentials credentials = (OpenIdCredentials)CredentialsFactory.create(OpenIdCredentials.class, (ICredentialsStore)store, (String)"key", (boolean)false);
        Assert.assertEquals(null, (Object)credentials.getResponseUrl());
        Assert.assertEquals(null, (Object)credentials.getToken());
    }

    @Test
    public void testSaveOpenIdCredentials() throws StorageException {
        InMemoryCredentialsStore store = new InMemoryCredentialsStore();
        OpenIdCredentials oldCredentials = new OpenIdCredentials("responseUrl", "token");
        oldCredentials.save((ICredentialsStore)store, "key");
        OpenIdCredentials newCredentials = (OpenIdCredentials)CredentialsFactory.create(OpenIdCredentials.class, (ICredentialsStore)store, (String)"key", (boolean)true);
        Assert.assertNotSame((Object)oldCredentials, (Object)newCredentials);
        Assert.assertEquals((Object)oldCredentials, (Object)newCredentials);
    }
}

