/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.commons.repositories.tests.core;

import java.util.Arrays;
import org.eclipse.mylyn.commons.repositories.core.auth.ICredentialsStore;
import org.junit.Assert;
import org.junit.Test;

public abstract class AbstractCredentialsStoreTest {
    @Test
    public void testGetBooleanDefault() {
        ICredentialsStore store = this.createCredentialsStore();
        Assert.assertEquals((Object)true, (Object)store.getBoolean("key2", true));
        Assert.assertEquals((Object)false, (Object)store.getBoolean("key2", false));
    }

    @Test
    public void testGetStringDefault() {
        ICredentialsStore store = this.createCredentialsStore();
        Assert.assertEquals((Object)"default", (Object)store.get("key2", "default"));
        Assert.assertEquals((Object)"otherValue", (Object)store.get("key2", "otherValue"));
        Assert.assertEquals(null, (Object)store.get("key2", null));
    }

    @Test
    public void testKeys() {
        ICredentialsStore store = this.createCredentialsStore();
        store.put("a", "value", false);
        store.put("b", "value", true);
        Object[] keys = store.keys();
        Arrays.sort(keys);
        Assert.assertEquals((Object)"[a, b]", (Object)Arrays.toString(keys));
    }

    @Test
    public void testPutNull() {
        ICredentialsStore store = this.createCredentialsStore();
        store.put("key", "value", false);
        store.put("key", null, false);
        Assert.assertEquals(null, (Object)store.get("key", "default"));
        store.remove("key");
        Assert.assertEquals((Object)"default", (Object)store.get("key", "default"));
    }

    @Test
    public void testPutGetBooleanEncrypted() {
        ICredentialsStore store = this.createCredentialsStore();
        store.putBoolean("key", true, true);
        Assert.assertEquals((Object)true, (Object)store.getBoolean("key", false));
    }

    @Test
    public void testPutGetBooleanNotEncrypted() {
        ICredentialsStore store = this.createCredentialsStore();
        store.putBoolean("key", true, false);
        Assert.assertEquals((Object)true, (Object)store.getBoolean("key", false));
    }

    @Test
    public void testPutGetByteArrayDefault() {
        ICredentialsStore store = this.createCredentialsStore();
        Assert.assertEquals(null, (Object)store.getByteArray("key2", null));
        byte[] byArray = new byte[2];
        byArray[1] = 50;
        byte[] byArray2 = new byte[2];
        byArray2[1] = 50;
        Assert.assertEquals((Object)Arrays.toString(byArray), (Object)Arrays.toString(store.getByteArray("key2", byArray2)));
    }

    @Test
    public void testPutGetByteArrayEncrypted() {
        ICredentialsStore store = this.createCredentialsStore();
        byte[] byArray = new byte[2];
        byArray[1] = 50;
        store.putByteArray("key", byArray, true);
        byte[] byArray2 = new byte[2];
        byArray2[1] = 50;
        byte[] byArray3 = new byte[2];
        byArray3[1] = 50;
        Assert.assertEquals((Object)Arrays.toString(byArray2), (Object)Arrays.toString(store.getByteArray("key", byArray3)));
    }

    @Test
    public void testPutGetByteArrayNotEncrypted() {
        ICredentialsStore store = this.createCredentialsStore();
        byte[] byArray = new byte[2];
        byArray[1] = 50;
        store.putByteArray("key", byArray, false);
        byte[] byArray2 = new byte[2];
        byArray2[1] = 50;
        byte[] byArray3 = new byte[2];
        byArray3[1] = 50;
        Assert.assertEquals((Object)Arrays.toString(byArray2), (Object)Arrays.toString(store.getByteArray("key", byArray3)));
    }

    @Test
    public void testPutGetStringEncrypted() {
        ICredentialsStore store = this.createCredentialsStore();
        store.put("key", "valueGet", true);
        Assert.assertEquals((Object)"valueGet", (Object)store.get("key", "default"));
    }

    @Test
    public void testPutGetStringEncryptedNotPersisted() {
        ICredentialsStore store = this.createCredentialsStore();
        store.put("key", "valueGet", true, false);
        Assert.assertEquals((Object)"valueGet", (Object)store.get("key", "default"));
        store.put("key", "newValue", true, false);
        Assert.assertEquals((Object)"newValue", (Object)store.get("key", "default"));
    }

    @Test
    public void testPutGetStringNotEncryptedNotPersisted() {
        ICredentialsStore store = this.createCredentialsStore();
        store.put("key", "valueGet", false, false);
        Assert.assertEquals((Object)"valueGet", (Object)store.get("key", "default"));
        store.put("key", "newValue", false, false);
        Assert.assertEquals((Object)"newValue", (Object)store.get("key", "default"));
    }

    @Test
    public void testPutGetStringNotEncrypted() {
        ICredentialsStore store = this.createCredentialsStore();
        store.put("key", "valueGet", false);
        Assert.assertEquals((Object)"valueGet", (Object)store.get("key", "default"));
    }

    @Test
    public void testRemoveEncrypted() {
        ICredentialsStore store = this.createCredentialsStore();
        store.put("key", "value", true);
        store.remove("key");
        Assert.assertEquals((Object)"default", (Object)store.get("key", "default"));
    }

    @Test
    public void testRemoveNonExistantEncrypted() {
        ICredentialsStore store = this.createCredentialsStore();
        store.remove("key2");
        Assert.assertEquals((Object)"default", (Object)store.get("key2", "default"));
    }

    @Test
    public void testRemoveNotEncrypted() {
        ICredentialsStore store = this.createCredentialsStore();
        store.put("key", "value", false);
        store.remove("key");
        Assert.assertEquals((Object)"default", (Object)store.get("key", "default"));
    }

    @Test
    public void testRemoveKeys() {
        ICredentialsStore store = this.createCredentialsStore();
        store.put("key", "value", false);
        store.remove("key");
        Assert.assertEquals((Object)"[]", (Object)Arrays.toString(store.keys()));
    }

    protected abstract ICredentialsStore createCredentialsStore();
}

