/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.builds.tests.util;

import java.io.ByteArrayOutputStream;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import junit.framework.TestCase;
import org.eclipse.mylyn.builds.core.IBuild;
import org.eclipse.mylyn.builds.core.ITestCase;
import org.eclipse.mylyn.builds.core.ITestResult;
import org.eclipse.mylyn.builds.core.ITestSuite;
import org.eclipse.mylyn.builds.internal.core.BuildFactory;
import org.eclipse.mylyn.builds.internal.core.util.JUnitResultGenerator;
import org.xml.sax.ContentHandler;

public class JUnitResultGeneratorTest
extends TestCase {
    private ByteArrayOutputStream out;
    private ITestResult testResult;
    private ITestSuite suite;
    private ITestCase testCase;
    private TransformerHandler handler;

    protected void setUp() throws Exception {
        this.out = new ByteArrayOutputStream();
        StreamResult streamResult = new StreamResult(this.out);
        SAXTransformerFactory factory = (SAXTransformerFactory)TransformerFactory.newInstance();
        this.handler = factory.newTransformerHandler();
        this.handler.setResult(streamResult);
        this.testResult = BuildFactory.eINSTANCE.createTestResult();
        this.testResult.setDuration(111L);
        this.testResult.setErrorCount(1);
        this.testResult.setFailCount(2);
        this.testResult.setIgnoredCount(3);
        this.testResult.setPassCount(4);
        IBuild build = BuildFactory.eINSTANCE.createBuild();
        build.setLabel("Build1");
        this.testResult.setBuild(build);
        this.suite = BuildFactory.eINSTANCE.createTestSuite();
        this.suite.setLabel("TestClass1");
        this.suite.setDuration(222L);
        this.testResult.getSuites().add(this.suite);
        this.testCase = BuildFactory.eINSTANCE.createTestCase();
        this.testCase.setClassName("TestClass1");
        this.testCase.setLabel("TestCase1");
        this.testCase.setDuration(333L);
        this.suite.getCases().add(this.testCase);
    }

    public void testWrite() throws Exception {
        JUnitResultGenerator generator = new JUnitResultGenerator(this.testResult);
        generator.write((ContentHandler)this.handler);
        JUnitResultGeneratorTest.assertEquals((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><testrun name=\"Build1\" project=\"Build1\" tests=\"6\" started=\"6\" failures=\"2\" errors=\"1\" ignored=\"3\"><testsuite name=\"TestClass1\" time=\"0.222\"><testcase name=\"TestCase1\" classname=\"TestClass1\" time=\"0.333\"/></testsuite></testrun>", (String)this.out.toString());
    }

    public void testWriteWithChildSuite() throws Exception {
        this.suite.setLabel("Suite1");
        JUnitResultGenerator generator = new JUnitResultGenerator(this.testResult);
        generator.write((ContentHandler)this.handler);
        JUnitResultGeneratorTest.assertEquals((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><testrun name=\"Build1\" project=\"Build1\" tests=\"6\" started=\"6\" failures=\"2\" errors=\"1\" ignored=\"3\"><testsuite name=\"Suite1\" time=\"0.222\"><testsuite name=\"TestClass1\"><testcase name=\"TestCase1\" classname=\"TestClass1\" time=\"0.333\"/></testsuite></testsuite></testrun>", (String)this.out.toString());
    }
}

