/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.builds.tests.ui;

import junit.framework.TestCase;
import org.eclipse.mylyn.builds.core.BuildStatus;
import org.eclipse.mylyn.builds.core.IBuildPlan;
import org.eclipse.mylyn.builds.internal.core.BuildFactory;
import org.eclipse.mylyn.builds.internal.core.BuildModel;
import org.eclipse.mylyn.internal.builds.ui.BuildsUiInternal;
import org.eclipse.mylyn.internal.builds.ui.view.BuildContentProvider;
import org.eclipse.mylyn.internal.builds.ui.view.BuildsView;
import org.mockito.Mockito;

public class BuildsViewTest
extends TestCase {
    public void testGetBuildsSummary() throws Exception {
        TestBuildsView view = (TestBuildsView)((Object)Mockito.spy((Object)((Object)new TestBuildsView())));
        Mockito.when((Object)view.getContentProvider()).thenReturn((Object)new BuildContentProvider());
        Mockito.when((Object)view.getModel()).thenReturn((Object)BuildsUiInternal.getModel());
        this.assertBuildSummary(view.getBuildsSummary(), false, false, false);
        BuildsViewTest.assertTrue((boolean)view.getBuildsSummary().isEmpty());
        view.getModel().getPlans().add(this.createBuildPlan(BuildStatus.SUCCESS));
        view.getModel().getPlans().add(this.createBuildPlan(BuildStatus.SUCCESS));
        view.getModel().getPlans().add(this.createBuildPlan(BuildStatus.SUCCESS));
        this.assertBuildSummary(view.getBuildsSummary(), true, false, false);
        view.getModel().getPlans().add(this.createBuildPlan(BuildStatus.UNSTABLE));
        view.getModel().getPlans().add(this.createBuildPlan(BuildStatus.UNSTABLE));
        this.assertBuildSummary(view.getBuildsSummary(), false, true, false);
        view.getModel().getPlans().add(this.createBuildPlan(BuildStatus.FAILED));
        this.assertBuildSummary(view.getBuildsSummary(), false, false, true);
        BuildsViewTest.assertFalse((boolean)view.getBuildsSummary().isEmpty());
        BuildsViewTest.assertEquals((String)"3 Succeeded, 2 Unstable, 1 Failed", (String)view.getBuildsSummary().toString());
    }

    private void assertBuildSummary(BuildsView.BuildsSummary buildsSummary, boolean isSuccess, boolean isUnstable, boolean isFailed) {
        BuildsViewTest.assertEquals((boolean)isSuccess, (boolean)buildsSummary.isSuccess());
        BuildsViewTest.assertEquals((boolean)isUnstable, (boolean)buildsSummary.isUnstable());
        BuildsViewTest.assertEquals((boolean)isFailed, (boolean)buildsSummary.isFailed());
    }

    private IBuildPlan createBuildPlan(BuildStatus status) {
        IBuildPlan plan = BuildFactory.eINSTANCE.createBuildPlan();
        plan.setStatus(status);
        return plan;
    }

    public class TestBuildsView
    extends BuildsView {
        protected BuildsView.BuildsSummary getBuildsSummary() {
            return super.getBuildsSummary();
        }

        protected BuildModel getModel() {
            return super.getModel();
        }
    }
}

