/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.builds.tests.operations;

import java.util.Collections;
import junit.framework.TestCase;
import org.eclipse.mylyn.builds.core.IBuild;
import org.eclipse.mylyn.builds.core.IBuildFactory;
import org.eclipse.mylyn.builds.core.IBuildPlan;
import org.eclipse.mylyn.builds.internal.core.BuildServer;
import org.eclipse.mylyn.builds.internal.core.operations.IOperationService;
import org.eclipse.mylyn.builds.internal.core.operations.RefreshOperation;
import org.eclipse.mylyn.builds.tests.support.BuildHarness;
import org.eclipse.mylyn.builds.tests.support.MockBuildServerBehaviour;
import org.eclipse.mylyn.commons.core.operations.OperationUtil;

public class RefreshOperationTest
extends TestCase {
    private BuildHarness harness;
    private MockBuildServerBehaviour behavior;
    private BuildServer server;
    private IBuildPlan plan;

    protected void setUp() throws Exception {
        this.harness = new BuildHarness(IBuildFactory.INSTANCE.createBuildModel());
        this.server = this.harness.createServer();
        this.behavior = (MockBuildServerBehaviour)this.server.getBehaviour();
        this.plan = this.harness.createBuildPlan();
        IBuild existingBuild = this.harness.createBuild();
        this.plan.setLastBuild(existingBuild);
    }

    protected void tearDown() throws Exception {
        this.harness.dispose();
    }

    public void testMergeExtendedAttributesBuild() throws Exception {
        IBuild newBuild = this.harness.createBuild();
        newBuild.getAttributes().put("key", "value2");
        this.behavior.setPlans(Collections.singletonList(this.plan));
        this.behavior.setBuilds(Collections.singletonList(newBuild));
        RefreshOperation operation = new RefreshOperation((IOperationService)this.harness.getOperationService(), this.harness.getModel(), Collections.singletonList(this.plan));
        operation.doExecute(OperationUtil.convert(null));
        RefreshOperationTest.assertEquals((Object)newBuild, (Object)this.plan.getLastBuild());
        RefreshOperationTest.assertEquals((String)"value2", (String)((String)this.plan.getLastBuild().getAttributes().get("key")));
    }

    public void testMergeExtendedAttributesBuildPlan() throws Exception {
        IBuildPlan plan2 = this.harness.createBuildPlan();
        plan2.getAttributes().put("key", "value2");
        this.behavior.setPlans(Collections.singletonList(plan2));
        RefreshOperation operation = new RefreshOperation((IOperationService)this.harness.getOperationService(), this.harness.getModel(), Collections.singletonList(this.plan));
        operation.doExecute(OperationUtil.convert(null));
        RefreshOperationTest.assertEquals((String)"value2", (String)((String)this.plan.getAttributes().get("key")));
    }
}

