/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.builds.tests.core;

import java.io.File;
import java.util.Collections;
import junit.framework.TestCase;
import org.eclipse.mylyn.builds.core.IBuild;
import org.eclipse.mylyn.builds.core.IBuildPlan;
import org.eclipse.mylyn.builds.core.IBuildServer;
import org.eclipse.mylyn.builds.internal.core.BuildFactory;
import org.eclipse.mylyn.builds.internal.core.IBuildLoader;
import org.eclipse.mylyn.builds.internal.core.util.BuildModelManager;
import org.eclipse.mylyn.builds.tests.support.MockBuildLoader;

public class BuildModelManagerTest
extends TestCase {
    private BuildModelManager manager;
    private File file;

    protected void setUp() throws Exception {
        this.file = File.createTempFile("builds", ".xmi");
        this.file.deleteOnExit();
        this.manager = new BuildModelManager(this.file, (IBuildLoader)new MockBuildLoader());
    }

    protected void tearDown() throws Exception {
        this.file.delete();
    }

    public void testSaveEmptyModel() throws Exception {
        this.manager.save();
    }

    public void testSaveDanglingPlan() throws Exception {
        IBuildPlan plan = BuildFactory.eINSTANCE.createBuildPlan();
        IBuild build = BuildFactory.eINSTANCE.createBuild();
        build.setPlan(plan);
        this.manager.getModel().getBuilds().add(build);
        this.manager.save();
        BuildModelManagerTest.assertEquals((Object)Collections.EMPTY_LIST, (Object)this.manager.getModel().getBuilds());
    }

    public void testSaveDanglingPlanWithServer() throws Exception {
        IBuildServer server = BuildFactory.eINSTANCE.createBuildServer();
        IBuildPlan plan1 = BuildFactory.eINSTANCE.createBuildPlan();
        plan1.setServer(server);
        IBuildPlan plan2 = BuildFactory.eINSTANCE.createBuildPlan();
        this.manager.getModel().getServers().add(server);
        this.manager.getModel().getPlans().add(plan1);
        this.manager.getModel().getPlans().add(plan2);
        this.manager.save();
        BuildModelManagerTest.assertEquals(Collections.singletonList(server), (Object)this.manager.getModel().getServers());
        BuildModelManagerTest.assertEquals(Collections.singletonList(plan1), (Object)this.manager.getModel().getPlans());
    }
}

