/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.trac.tests.client;

import java.net.InetSocketAddress;
import java.net.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import junit.framework.TestCase;
import org.apache.commons.lang.RandomStringUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.mylyn.commons.repositories.core.auth.UserCredentials;
import org.eclipse.mylyn.commons.sdk.util.CommonTestUtil;
import org.eclipse.mylyn.internal.trac.core.TracAttribute;
import org.eclipse.mylyn.internal.trac.core.client.ITracClient;
import org.eclipse.mylyn.internal.trac.core.client.TracException;
import org.eclipse.mylyn.internal.trac.core.client.TracLoginException;
import org.eclipse.mylyn.internal.trac.core.client.TracPermissionDeniedException;
import org.eclipse.mylyn.internal.trac.core.client.TracRemoteException;
import org.eclipse.mylyn.internal.trac.core.model.TracSearch;
import org.eclipse.mylyn.internal.trac.core.model.TracSearchFilter;
import org.eclipse.mylyn.internal.trac.core.model.TracTicket;
import org.eclipse.mylyn.internal.trac.core.model.TracTicketField;
import org.eclipse.mylyn.internal.trac.core.model.TracVersion;
import org.eclipse.mylyn.trac.tests.support.TracFixture;
import org.eclipse.mylyn.trac.tests.support.TracHarness;
import org.eclipse.mylyn.trac.tests.support.TracTestUtil;

public class TracClientTest
extends TestCase {
    private ITracClient client;
    private TracFixture fixture;
    private TracHarness harness;

    protected void setUp() throws Exception {
        this.fixture = TracFixture.current();
        this.harness = this.fixture.createHarness();
        this.client = this.fixture.connect();
    }

    protected void tearDown() throws Exception {
        this.harness.dispose();
    }

    public void testGetTicket() throws Exception {
        TracTicket expectedTicket = this.harness.createTicket("getTicket");
        TracTicket ticket = this.client.getTicket(expectedTicket.getId(), null);
        TracTestUtil.assertTicketEquals(this.client.getAccessMode(), expectedTicket, ticket);
    }

    public void testGetTicketInvalidId() throws Exception {
        try {
            this.client.getTicket(Integer.MAX_VALUE, null);
            TracClientTest.fail((String)"Expected TracException");
        }
        catch (TracException tracException) {
            // empty catch block
        }
    }

    public void testGetTicketUmlaute() throws Exception {
        TracTicket ticket = this.harness.newTicket("test html entities: \u00e4\u00f6\u00fc");
        ticket.putBuiltinValue(TracTicket.Key.DESCRIPTION, "\u00c4\u00d6\u00dc\n\nmulti\nline\n\n'''bold'''\n");
        ticket = this.harness.createTicket(ticket);
        ticket = this.client.getTicket(ticket.getId(), null);
        TracClientTest.assertEquals((String)"test html entities: \u00e4\u00f6\u00fc", (String)ticket.getValue(TracTicket.Key.SUMMARY));
        if (this.client.getAccessMode() == ITracClient.Version.XML_RPC) {
            TracClientTest.assertEquals((String)"\u00c4\u00d6\u00dc\n\nmulti\nline\n\n'''bold'''\n", (String)ticket.getValue(TracTicket.Key.DESCRIPTION));
        } else {
            TracClientTest.assertEquals(null, (String)ticket.getValue(TracTicket.Key.DESCRIPTION));
        }
    }

    public void testProxy() throws Exception {
        this.client = this.fixture.connect(this.fixture.getRepositoryUrl(), "", "", new Proxy(Proxy.Type.HTTP, new InetSocketAddress("invalidhostname", 8080)));
        try {
            this.client.validate((IProgressMonitor)new NullProgressMonitor());
            TracClientTest.fail((String)"Expected IOException");
        }
        catch (TracException tracException) {
            // empty catch block
        }
    }

    public void testSearchAll() throws Exception {
        this.harness.createTicket("searchAllTickets");
        TracSearch search = new TracSearch();
        ArrayList result = new ArrayList();
        this.client.search(search, result, null);
        TracClientTest.assertTrue((!result.isEmpty() ? 1 : 0) != 0);
    }

    public void testSearchEmpty() throws Exception {
        TracSearch search = new TracSearch();
        search.addFilter("milestone", "does not exist");
        ArrayList result = new ArrayList();
        this.client.search(search, result, null);
        TracClientTest.assertEquals((int)0, (int)result.size());
    }

    public void testSearchExactMatch() throws Exception {
        String uniqueTag = RandomStringUtils.randomAlphanumeric((int)6);
        String summary = "searchExactMatch " + uniqueTag;
        TracTicket ticket = this.harness.createTicketWithMilestone(summary, "milestone1");
        TracSearch search = new TracSearch();
        search.addFilter("milestone", "milestone1");
        search.addFilter("summary", summary);
        ArrayList result = new ArrayList();
        this.client.search(search, result, null);
        TracClientTest.assertEquals((int)1, (int)result.size());
        TracTestUtil.assertTicketEquals(ticket, (TracTicket)result.get(0));
        TracClientTest.assertEquals((String)"milestone1", (String)((TracTicket)result.get(0)).getValue(TracTicket.Key.MILESTONE));
        TracClientTest.assertEquals((String)summary, (String)((TracTicket)result.get(0)).getValue(TracTicket.Key.SUMMARY));
    }

    public void testSearchMilestone1() throws Exception {
        String uniqueTag = RandomStringUtils.randomAlphanumeric((int)6);
        TracTicket ticket = this.harness.createTicketWithMilestone("searchMilestone1" + uniqueTag, "milestone1");
        this.harness.createTicketWithMilestone("searchMilestone1" + uniqueTag, "milestone2");
        TracSearch search = new TracSearch();
        search.addFilter(new TracSearchFilter("summary", TracSearchFilter.CompareOperator.CONTAINS, uniqueTag));
        search.addFilter("milestone", "milestone1");
        search.addFilter("milestone", "milestone1");
        ArrayList result = new ArrayList();
        this.client.search(search, result, null);
        TracClientTest.assertEquals((int)1, (int)result.size());
        TracTestUtil.assertTicketEquals(ticket, (TracTicket)result.get(0));
    }

    public void testSearchMilestone2() throws Exception {
        String uniqueTag = RandomStringUtils.randomAlphanumeric((int)6);
        TracTicket ticket1 = this.harness.createTicketWithMilestone("searchMilestone2 " + uniqueTag, "milestone1");
        TracTicket ticket2 = this.harness.createTicketWithMilestone("searchMilestone2 " + uniqueTag, "milestone1");
        TracTicket ticket3 = this.harness.createTicketWithMilestone("searchMilestone2 " + uniqueTag, "milestone2");
        TracSearch search = new TracSearch();
        search.addFilter(new TracSearchFilter("summary", TracSearchFilter.CompareOperator.CONTAINS, uniqueTag));
        search.addFilter("milestone", "milestone1");
        search.addFilter("milestone", "milestone2");
        search.setOrderBy("id");
        ArrayList result = new ArrayList();
        this.client.search(search, result, null);
        TracClientTest.assertEquals((int)3, (int)result.size());
        TracTestUtil.assertTicketEquals(ticket1, (TracTicket)result.get(0));
        TracTestUtil.assertTicketEquals(ticket2, (TracTicket)result.get(1));
        TracTestUtil.assertTicketEquals(ticket3, (TracTicket)result.get(2));
    }

    public void testSearchMilestoneAmpersand() throws Exception {
        block3: {
            if (!this.harness.hasMilestone("mile&stone")) {
                return;
            }
            TracTicket ticket = this.harness.createTicketWithMilestone("searchMilestoneAmpersand", "mile&stone");
            TracSearch search = new TracSearch();
            search.addFilter("milestone", "mile&stone");
            search.setOrderBy("id");
            ArrayList result = new ArrayList();
            try {
                this.client.search(search, result, null);
                TracClientTest.assertEquals((int)1, (int)result.size());
                TracTestUtil.assertTicketEquals(ticket, (TracTicket)result.get(0));
            }
            catch (TracRemoteException e) {
                if ("'Query filter requires field and constraints separated by a \"=\"' while executing 'ticket.query()'".equals(e.getMessage()) && (this.fixture.getVersion().equals("0.10") || this.fixture.getVersion().equals("0.11"))) break block3;
                throw e;
            }
        }
    }

    public void testStatusClosed() throws Exception {
        TracTicket ticket = this.harness.createTicket("statusClosed");
        ticket.putBuiltinValue(TracTicket.Key.STATUS, "closed");
        ticket.putBuiltinValue(TracTicket.Key.RESOLUTION, "fixed");
        this.harness.udpateTicket(ticket);
        ticket = this.client.getTicket(ticket.getId(), null);
        TracClientTest.assertEquals((String)"closed", (String)ticket.getValue(TracTicket.Key.STATUS));
        TracClientTest.assertEquals((String)"fixed", (String)ticket.getValue(TracTicket.Key.RESOLUTION));
    }

    public void testUpdateAttributesAnonymous() throws Exception {
        if (this.fixture.requiresAuthentication()) {
            return;
        }
        this.client = this.fixture.connect(this.fixture.getRepositoryUrl(), "", "");
        TracClientTest.assertNull((Object)this.client.getMilestones());
        try {
            this.client.updateAttributes((IProgressMonitor)new NullProgressMonitor(), true);
            if (this.fixture.getAccessMode() == ITracClient.Version.XML_RPC) {
                TracClientTest.fail((String)"Expected anonymous access to be denied");
            }
        }
        catch (TracPermissionDeniedException e) {
            if (this.fixture.getAccessMode() == ITracClient.Version.XML_RPC) {
                return;
            }
            throw e;
        }
        TracVersion[] versions = this.client.getVersions();
        TracClientTest.assertEquals((int)2, (int)versions.length);
        Arrays.sort(versions, new Comparator<TracVersion>(){

            @Override
            public int compare(TracVersion o1, TracVersion o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        TracClientTest.assertEquals((String)"1.0", (String)versions[0].getName());
        TracClientTest.assertEquals((String)"2.0", (String)versions[1].getName());
    }

    public void testUpdateAttributesChangedTicketFields() throws Exception {
        if (this.fixture.getAccessMode() == ITracClient.Version.TRAC_0_9) {
            return;
        }
        this.client = this.fixture.connect(this.fixture.getRepositoryUrl());
        this.client.updateAttributes((IProgressMonitor)new NullProgressMonitor(), true);
        TracTicketField field = this.client.getTicketFieldByName(TracAttribute.MILESTONE.getTracKey());
        field.setDefaultValue("modified default value");
        this.client.updateAttributes((IProgressMonitor)new NullProgressMonitor(), true);
        field = this.client.getTicketFieldByName(TracAttribute.MILESTONE.getTracKey());
        TracClientTest.assertEquals((String)"", (String)field.getDefaultValue());
    }

    public void testValidate() throws Exception {
        UserCredentials credentials = CommonTestUtil.getCredentials((CommonTestUtil.PrivilegeLevel)CommonTestUtil.PrivilegeLevel.USER);
        this.client.validate((IProgressMonitor)new NullProgressMonitor());
        this.client = TracFixture.current().connect("http://non.existant/repository");
        try {
            this.client.validate((IProgressMonitor)new NullProgressMonitor());
            TracClientTest.fail((String)"Expected TracException");
        }
        catch (TracException tracException) {
            // empty catch block
        }
        String url = TracFixture.current().getRepositoryUrl();
        this.client = TracFixture.current().connect(url, credentials.getUserName(), "wrongpassword");
        try {
            this.client.validate((IProgressMonitor)new NullProgressMonitor());
            TracClientTest.fail((String)"Expected TracLoginException");
        }
        catch (TracLoginException tracLoginException) {
            // empty catch block
        }
        this.client = TracFixture.current().connect(url, "wrongusername", credentials.getPassword());
        try {
            this.client.validate((IProgressMonitor)new NullProgressMonitor());
            TracClientTest.fail((String)"Expected TracLoginException");
        }
        catch (TracLoginException tracLoginException) {
            // empty catch block
        }
    }

    public void testValidateAnonymousLogin() throws Exception {
        block4: {
            if (this.fixture.requiresAuthentication()) {
                return;
            }
            this.client = this.fixture.connect(this.fixture.getRepositoryUrl(), "", "");
            try {
                this.client.validate((IProgressMonitor)new NullProgressMonitor());
                if (this.fixture.getAccessMode() == ITracClient.Version.XML_RPC) {
                    TracClientTest.fail((String)"Expected anonymous access to be denied");
                }
            }
            catch (TracPermissionDeniedException e) {
                if (this.fixture.getAccessMode() != ITracClient.Version.TRAC_0_9) break block4;
                TracClientTest.fail((String)"Expected anonymous access to be allowed");
            }
        }
    }

    public void testValidateAnyPage() throws Exception {
        this.client = this.fixture.connect("http://mylyn.eclipse.org/");
        try {
            this.client.validate((IProgressMonitor)new NullProgressMonitor());
            TracClientTest.fail((String)"Expected TracException");
        }
        catch (TracException tracException) {
            // empty catch block
        }
    }
}

