/*******************************************************************************
 * Copyright (c) 2010, 2011 Markus Knittig and others.
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * https://www.eclipse.org/legal/epl-2.0
 * 
 * SPDX-License-Identifier: EPL-2.0
 *
 *     Markus Knittig - initial API and implementation
 *******************************************************************************/

package org.eclipse.mylyn.builds.core;

import java.util.List;

/**
 * <!-- begin-user-doc --> A representation of the model object '<em><b>Build</b></em>'. <!-- end-user-doc -->
 * <p>
 * The following features are supported:
 * <ul>
 * <li>{@link org.eclipse.mylyn.builds.core.IBuild#getId <em>Id</em>}</li>
 * <li>{@link org.eclipse.mylyn.builds.core.IBuild#getBuildNumber <em>Build Number</em>}</li>
 * <li>{@link org.eclipse.mylyn.builds.core.IBuild#getTimestamp <em>Timestamp</em>}</li>
 * <li>{@link org.eclipse.mylyn.builds.core.IBuild#getDuration <em>Duration</em>}</li>
 * <li>{@link org.eclipse.mylyn.builds.core.IBuild#getDisplayName <em>Display Name</em>}</li>
 * <li>{@link org.eclipse.mylyn.builds.core.IBuild#getState <em>State</em>}</li>
 * <li>{@link org.eclipse.mylyn.builds.core.IBuild#getStatus <em>Status</em>}</li>
 * <li>{@link org.eclipse.mylyn.builds.core.IBuild#getArtifacts <em>Artifacts</em>}</li>
 * <li>{@link org.eclipse.mylyn.builds.core.IBuild#getChangeSet <em>Change Set</em>}</li>
 * <li>{@link org.eclipse.mylyn.builds.core.IBuild#getPlan <em>Plan</em>}</li>
 * <li>{@link org.eclipse.mylyn.builds.core.IBuild#getLabel <em>Label</em>}</li>
 * <li>{@link org.eclipse.mylyn.builds.core.IBuild#getServer <em>Server</em>}</li>
 * <li>{@link org.eclipse.mylyn.builds.core.IBuild#getTestResult <em>Test Result</em>}</li>
 * <li>{@link org.eclipse.mylyn.builds.core.IBuild#getCulprits <em>Culprits</em>}</li>
 * <li>{@link org.eclipse.mylyn.builds.core.IBuild#getSummary <em>Summary</em>}</li>
 * <li>{@link org.eclipse.mylyn.builds.core.IBuild#getCause <em>Cause</em>}</li>
 * </ul>
 * </p>
 * 
 * @generated
 */
public interface IBuild extends IBuildElement {
	/**
	 * Returns the value of the '<em><b>Id</b></em>' attribute. <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Id</em>' attribute isn't clear, there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * 
	 * @return the value of the '<em>Id</em>' attribute.
	 * @see #setId(String)
	 * @generated
	 */
	String getId();

	/**
	 * Sets the value of the '{@link org.eclipse.mylyn.builds.core.IBuild#getId <em>Id</em>}' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @param value
	 *            the new value of the '<em>Id</em>' attribute.
	 * @see #getId()
	 * @generated
	 */
	void setId(String value);

	/**
	 * Returns the value of the '<em><b>Build Number</b></em>' attribute. <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Build Number</em>' attribute isn't clear, there really should be more of a description
	 * here...
	 * </p>
	 * <!-- end-user-doc -->
	 * 
	 * @return the value of the '<em>Build Number</em>' attribute.
	 * @see #setBuildNumber(int)
	 * @generated
	 */
	int getBuildNumber();

	/**
	 * Sets the value of the '{@link org.eclipse.mylyn.builds.core.IBuild#getBuildNumber <em>Build Number</em>}'
	 * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @param value
	 *            the new value of the '<em>Build Number</em>' attribute.
	 * @see #getBuildNumber()
	 * @generated
	 */
	void setBuildNumber(int value);

	/**
	 * Returns the value of the '<em><b>Timestamp</b></em>' attribute. <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Timestamp</em>' attribute isn't clear, there really should be more of a description
	 * here...
	 * </p>
	 * <!-- end-user-doc -->
	 * 
	 * @return the value of the '<em>Timestamp</em>' attribute.
	 * @see #setTimestamp(long)
	 * @generated
	 */
	long getTimestamp();

	/**
	 * Sets the value of the '{@link org.eclipse.mylyn.builds.core.IBuild#getTimestamp <em>Timestamp</em>}' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @param value
	 *            the new value of the '<em>Timestamp</em>' attribute.
	 * @see #getTimestamp()
	 * @generated
	 */
	void setTimestamp(long value);

	/**
	 * Returns the value of the '<em><b>Duration</b></em>' attribute. <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Duration</em>' attribute isn't clear, there really should be more of a description
	 * here...
	 * </p>
	 * <!-- end-user-doc -->
	 * 
	 * @return the value of the '<em>Duration</em>' attribute.
	 * @see #setDuration(long)
	 * @generated
	 */
	long getDuration();

	/**
	 * Sets the value of the '{@link org.eclipse.mylyn.builds.core.IBuild#getDuration <em>Duration</em>}' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @param value
	 *            the new value of the '<em>Duration</em>' attribute.
	 * @see #getDuration()
	 * @generated
	 */
	void setDuration(long value);

	/**
	 * Returns the value of the '<em><b>Display Name</b></em>' attribute. <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Display Name</em>' attribute isn't clear, there really should be more of a description
	 * here...
	 * </p>
	 * <!-- end-user-doc -->
	 * 
	 * @return the value of the '<em>Display Name</em>' attribute.
	 * @see #setDisplayName(String)
	 * @generated
	 */
	String getDisplayName();

	/**
	 * Sets the value of the '{@link org.eclipse.mylyn.builds.core.IBuild#getDisplayName <em>Display Name</em>}'
	 * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @param value
	 *            the new value of the '<em>Display Name</em>' attribute.
	 * @see #getDisplayName()
	 * @generated
	 */
	void setDisplayName(String value);

	/**
	 * Returns the value of the '<em><b>State</b></em>' attribute. <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>State</em>' attribute isn't clear, there really should be more of a description
	 * here...
	 * </p>
	 * <!-- end-user-doc -->
	 * 
	 * @return the value of the '<em>State</em>' attribute.
	 * @see #setState(BuildState)
	 * @generated
	 */
	BuildState getState();

	/**
	 * Sets the value of the '{@link org.eclipse.mylyn.builds.core.IBuild#getState <em>State</em>}' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @param value
	 *            the new value of the '<em>State</em>' attribute.
	 * @see #getState()
	 * @generated
	 */
	void setState(BuildState value);

	/**
	 * Returns the value of the '<em><b>Status</b></em>' attribute. <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Status</em>' attribute isn't clear, there really should be more of a description
	 * here...
	 * </p>
	 * <!-- end-user-doc -->
	 * 
	 * @return the value of the '<em>Status</em>' attribute.
	 * @see #setStatus(BuildStatus)
	 * @generated
	 */
	BuildStatus getStatus();

	/**
	 * Sets the value of the '{@link org.eclipse.mylyn.builds.core.IBuild#getStatus <em>Status</em>}' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @param value
	 *            the new value of the '<em>Status</em>' attribute.
	 * @see #getStatus()
	 * @generated
	 */
	void setStatus(BuildStatus value);

	/**
	 * Returns the value of the '<em><b>Artifacts</b></em>' containment reference list. The list contents are of type
	 * {@link org.eclipse.mylyn.builds.core.IArtifact}. <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Artifacts</em>' reference list isn't clear, there really should be more of a
	 * description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * 
	 * @return the value of the '<em>Artifacts</em>' containment reference list.
	 * @generated
	 */
	List<IArtifact> getArtifacts();

	/**
	 * Returns the value of the '<em><b>Change Set</b></em>' containment reference. <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Change Set</em>' reference isn't clear, there really should be more of a description
	 * here...
	 * </p>
	 * <!-- end-user-doc -->
	 * 
	 * @return the value of the '<em>Change Set</em>' containment reference.
	 * @see #setChangeSet(IChangeSet)
	 * @generated
	 */
	IChangeSet getChangeSet();

	/**
	 * Sets the value of the '{@link org.eclipse.mylyn.builds.core.IBuild#getChangeSet <em>Change Set</em>}' containment
	 * reference. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @param value
	 *            the new value of the '<em>Change Set</em>' containment reference.
	 * @see #getChangeSet()
	 * @generated
	 */
	void setChangeSet(IChangeSet value);

	/**
	 * Returns the value of the '<em><b>Plan</b></em>' reference. <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Plan</em>' reference isn't clear, there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * 
	 * @return the value of the '<em>Plan</em>' reference.
	 * @see #setPlan(IBuildPlan)
	 * @generated
	 */
	IBuildPlan getPlan();

	/**
	 * Sets the value of the '{@link org.eclipse.mylyn.builds.core.IBuild#getPlan <em>Plan</em>}' reference. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @param value
	 *            the new value of the '<em>Plan</em>' reference.
	 * @see #getPlan()
	 * @generated
	 */
	void setPlan(IBuildPlan value);

	/**
	 * Returns the value of the '<em><b>Label</b></em>' attribute. <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Label</em>' attribute isn't clear, there really should be more of a description
	 * here...
	 * </p>
	 * <!-- end-user-doc -->
	 * 
	 * @return the value of the '<em>Label</em>' attribute.
	 * @see #setLabel(String)
	 * @generated
	 */
	String getLabel();

	/**
	 * Sets the value of the '{@link org.eclipse.mylyn.builds.core.IBuild#getLabel <em>Label</em>}' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @param value
	 *            the new value of the '<em>Label</em>' attribute.
	 * @see #getLabel()
	 * @generated
	 */
	void setLabel(String value);

	/**
	 * Returns the value of the '<em><b>Server</b></em>' reference. <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Server</em>' reference isn't clear, there really should be more of a description
	 * here...
	 * </p>
	 * <!-- end-user-doc -->
	 * 
	 * @return the value of the '<em>Server</em>' reference.
	 * @see #setServer(IBuildServer)
	 * @generated
	 */
	IBuildServer getServer();

	/**
	 * Sets the value of the '{@link org.eclipse.mylyn.builds.core.IBuild#getServer <em>Server</em>}' reference. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @param value
	 *            the new value of the '<em>Server</em>' reference.
	 * @see #getServer()
	 * @generated
	 */
	void setServer(IBuildServer value);

	/**
	 * Returns the value of the '<em><b>Test Result</b></em>' containment reference. It is bidirectional and its
	 * opposite is '{@link org.eclipse.mylyn.builds.core.ITestResult#getBuild <em>Build</em>}'. <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Test Result</em>' reference isn't clear, there really should be more of a description
	 * here...
	 * </p>
	 * <!-- end-user-doc -->
	 * 
	 * @return the value of the '<em>Test Result</em>' containment reference.
	 * @see #setTestResult(ITestResult)
	 * @see org.eclipse.mylyn.builds.core.ITestResult#getBuild
	 * @generated
	 */
	ITestResult getTestResult();

	/**
	 * Sets the value of the '{@link org.eclipse.mylyn.builds.core.IBuild#getTestResult <em>Test Result</em>}'
	 * containment reference. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @param value
	 *            the new value of the '<em>Test Result</em>' containment reference.
	 * @see #getTestResult()
	 * @generated
	 */
	void setTestResult(ITestResult value);

	/**
	 * Returns the value of the '<em><b>Culprits</b></em>' containment reference list. The list contents are of type
	 * {@link org.eclipse.mylyn.builds.core.IUser}. <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Culprits</em>' containment reference isn't clear, there really should be more of a
	 * description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * 
	 * @return the value of the '<em>Culprits</em>' containment reference list.
	 * @generated
	 */
	List<IUser> getCulprits();

	/**
	 * Returns the value of the '<em><b>Summary</b></em>' attribute. <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Summary</em>' attribute isn't clear, there really should be more of a description
	 * here...
	 * </p>
	 * <!-- end-user-doc -->
	 * 
	 * @return the value of the '<em>Summary</em>' attribute.
	 * @see #setSummary(String)
	 * @generated
	 */
	String getSummary();

	/**
	 * Sets the value of the '{@link org.eclipse.mylyn.builds.core.IBuild#getSummary <em>Summary</em>}' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @param value
	 *            the new value of the '<em>Summary</em>' attribute.
	 * @see #getSummary()
	 * @generated
	 */
	void setSummary(String value);

	/**
	 * Returns the value of the '<em><b>Cause</b></em>' containment reference list. The list contents are of type
	 * {@link org.eclipse.mylyn.builds.core.IBuildCause}. <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Cause</em>' containment reference list isn't clear, there really should be more of a
	 * description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * 
	 * @return the value of the '<em>Cause</em>' containment reference list.
	 * @generated
	 */
	List<IBuildCause> getCause();

} // IBuild
