/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.notifications;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.Date;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.mylyn.commons.notifications.feed.IServiceMessageListener;
import org.eclipse.mylyn.commons.notifications.feed.ServiceMessageEvent;
import org.eclipse.mylyn.commons.notifications.ui.NotificationControl;
import org.eclipse.mylyn.internal.commons.notifications.feed.ServiceMessage;
import org.eclipse.mylyn.internal.tasks.core.LocalTask;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.internal.tasks.ui.actions.AddRepositoryAction;
import org.eclipse.mylyn.internal.tasks.ui.util.TasksUiInternal;
import org.eclipse.mylyn.internal.tasks.ui.wizards.Messages;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.ui.TasksUiUtil;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.IHandlerService;

public class TaskListServiceMessageControl
extends NotificationControl
implements IServiceMessageListener {
    private ServiceMessage currentMessage;

    public TaskListServiceMessageControl(Composite parent) {
        super(parent);
        this.setPreferencesPageId("org.eclipse.mylyn.tasks.ui.preferences");
    }

    static ExecutionEvent createExecutionEvent(Command command, IHandlerService handlerService) {
        return new ExecutionEvent(command, Collections.emptyMap(), null, (Object)TasksUiInternal.createDiscoveryWizardEvaluationContext(handlerService));
    }

    protected void closeMessage() {
        if (this.currentMessage != null && this.currentMessage.getId() != null && !this.currentMessage.getId().equals("0")) {
            TasksUiPlugin.getDefault().getPreferenceStore().setValue("org.eclipse.mylyn.tasks.ui.servicemessage.id", this.currentMessage.getId());
        }
        this.close();
    }

    public void handleEvent(ServiceMessageEvent event) {
        block0 : switch (event.getEventKind()) {
            case MESSAGE_UPDATE: {
                IPreferenceStore preferenceStore = TasksUiPlugin.getDefault().getPreferenceStore();
                preferenceStore.setValue("org.eclipse.mylyn.tasks.ui.servicemessage.checktime", new Date().getTime());
                String lastMessageId = preferenceStore.getString("org.eclipse.mylyn.tasks.ui.servicemessage.id");
                if (lastMessageId != null && lastMessageId.startsWith("org.eclipse.mylyn.reset.")) {
                    lastMessageId = "";
                    preferenceStore.setValue("org.eclipse.mylyn.tasks.ui.servicemessage.id", lastMessageId);
                }
                for (final ServiceMessage message : event.getMessages()) {
                    if (!message.isValid() || message.getId().equals("-1") || message.getId().compareTo(lastMessageId) <= 0) continue;
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            TaskListServiceMessageControl.this.setMessage(message);
                            TaskListServiceMessageControl.this.setEventId("");
                        }
                    });
                    break block0;
                }
                break;
            }
            case STOP: {
                this.close();
            }
        }
    }

    public void setMessage(ServiceMessage message) {
        if (message != null) {
            this.ensureControl();
            if (message.getETag() != null && message.getLastModified() != null) {
                IPreferenceStore preferenceStore = TasksUiPlugin.getDefault().getPreferenceStore();
                preferenceStore.setValue("org.eclipse.mylyn.tasks.ui.servicemessage.etag", message.getETag());
                preferenceStore.setValue("org.eclipse.mylyn.tasks.ui.servicemessage.lastmodified", message.getLastModified());
            }
            this.currentMessage = message;
            this.setTitle(message.getTitle());
            this.setTitleImage(Dialog.getImage((String)message.getImage()));
            this.setDescription(message.getDescription());
        }
    }

    public SelectionListener getLinkListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (e.text == null) {
                    return;
                }
                final String action = TaskListServiceMessageControl.getAction(e.text);
                if ("create-local-task".equals(action)) {
                    TaskListServiceMessageControl.this.closeMessage();
                    LocalTask task = TasksUiInternal.createNewLocalTask(null);
                    TasksUiUtil.openTask((ITask)task);
                } else if ("connect".equals(action)) {
                    TaskListServiceMessageControl.this.closeMessage();
                    new AddRepositoryAction().run();
                } else if ("discovery".equals(action)) {
                    TaskListServiceMessageControl.this.closeMessage();
                    Command discoveryWizardCommand = TasksUiInternal.getConfiguredDiscoveryWizardCommand();
                    if (discoveryWizardCommand != null && discoveryWizardCommand.isEnabled()) {
                        IHandlerService handlerService = (IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class);
                        try {
                            handlerService.executeCommand(discoveryWizardCommand.getId(), null);
                        }
                        catch (Exception e1) {
                            Status status = new Status(4, "org.eclipse.mylyn.tasks.ui", NLS.bind((String)Messages.SelectRepositoryConnectorPage_discoveryProblemMessage, (Object[])new Object[]{e1.getMessage()}), (Throwable)e1);
                            TasksUiInternal.logAndDisplayStatus(Messages.SelectRepositoryConnectorPage_discoveryProblemTitle, (IStatus)status);
                        }
                    }
                } else if (TasksUiInternal.isValidUrl(e.text)) {
                    TasksUiUtil.openUrl(e.text);
                } else if (TaskListServiceMessageControl.this.currentMessage != null) {
                    SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                        public void run() throws Exception {
                            if (TaskListServiceMessageControl.this.currentMessage.openLink(action)) {
                                TaskListServiceMessageControl.this.closeMessage();
                            }
                        }
                    });
                }
            }
        };
    }

    public static String getAction(String action) {
        block4: {
            if (action.startsWith("http")) {
                try {
                    URL url = new URL(action);
                    String query = url.getQuery();
                    if (query != null && query.startsWith("action=")) {
                        int i = query.indexOf("&");
                        action = i != -1 ? query.substring(7, i) : query.substring(7);
                        break block4;
                    }
                    return null;
                }
                catch (MalformedURLException e1) {
                    return null;
                }
            }
        }
        return action.toLowerCase();
    }
}

