/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.trac.tests.ui;

import java.util.List;
import junit.framework.TestCase;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.mylyn.internal.trac.ui.TracHyperlinkUtil;
import org.eclipse.mylyn.internal.trac.ui.WebHyperlink;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.TaskHyperlink;

public class TracHyperlinkUtilTest
extends TestCase {
    private TaskRepository repository;

    protected void setUp() throws Exception {
        this.repository = new TaskRepository("trac", "http://localhost");
    }

    public void testFindHyperlinksComment() {
        IHyperlink[] links = this.findTracHyperlinks(this.repository, "comment:ticket:12:34", 0, 0);
        TracHyperlinkUtilTest.assertNotNull((Object)links);
        TracHyperlinkUtilTest.assertEquals((int)1, (int)links.length);
        TracHyperlinkUtilTest.assertEquals((Object)new Region(0, 20), (Object)links[0].getHyperlinkRegion());
        TracHyperlinkUtilTest.assertEquals((String)"12", (String)((TaskHyperlink)links[0]).getTaskId());
    }

    public void testFindHyperlinksTicket() {
        IHyperlink[] links = TracHyperlinkUtil.findTicketHyperlinks((TaskRepository)this.repository, (String)"#11", (int)0, (int)0);
        TracHyperlinkUtilTest.assertNotNull((Object)links);
        TracHyperlinkUtilTest.assertEquals((int)1, (int)links.length);
        TracHyperlinkUtilTest.assertEquals((Object)new Region(0, 3), (Object)links[0].getHyperlinkRegion());
        TracHyperlinkUtilTest.assertEquals((String)"11", (String)((TaskHyperlink)links[0]).getTaskId());
        links = TracHyperlinkUtil.findTicketHyperlinks((TaskRepository)this.repository, (String)"#11, #234", (int)6, (int)0);
        TracHyperlinkUtilTest.assertNotNull((Object)links);
        TracHyperlinkUtilTest.assertEquals((int)1, (int)links.length);
        TracHyperlinkUtilTest.assertEquals((String)"234", (String)((TaskHyperlink)links[0]).getTaskId());
        links = TracHyperlinkUtil.findTicketHyperlinks((TaskRepository)this.repository, (String)"  ticket:123  ", (int)2, (int)0);
        TracHyperlinkUtilTest.assertNotNull((Object)links);
        TracHyperlinkUtilTest.assertEquals((int)1, (int)links.length);
        TracHyperlinkUtilTest.assertEquals((Object)new Region(2, 10), (Object)links[0].getHyperlinkRegion());
        TracHyperlinkUtilTest.assertEquals((String)"123", (String)((TaskHyperlink)links[0]).getTaskId());
    }

    public void testFindHyperlinksNoTicket() {
        IHyperlink[] links = this.findTracHyperlinks(this.repository, "#11", 0, 0);
        TracHyperlinkUtilTest.assertNull((Object)links);
        links = this.findTracHyperlinks(this.repository, "#11, #234", 6, 0);
        TracHyperlinkUtilTest.assertNull((Object)links);
        links = this.findTracHyperlinks(this.repository, "  ticket:123  ", 2, 0);
        TracHyperlinkUtilTest.assertNull((Object)links);
        links = this.findTracHyperlinks(this.repository, "#123 report:123", -1, 0);
        TracHyperlinkUtilTest.assertNotNull((Object)links);
        TracHyperlinkUtilTest.assertEquals((int)1, (int)links.length);
        TracHyperlinkUtilTest.assertEquals((String)"http://localhost/report/123", (String)((WebHyperlink)links[0]).getURLString());
    }

    public void testFindHyperlinksReport() {
        IHyperlink[] links = this.findTracHyperlinks(this.repository, "report:123", 0, 0);
        TracHyperlinkUtilTest.assertEquals((int)1, (int)links.length);
        TracHyperlinkUtilTest.assertEquals((Object)new Region(0, 10), (Object)links[0].getHyperlinkRegion());
        TracHyperlinkUtilTest.assertEquals((String)"http://localhost/report/123", (String)((WebHyperlink)links[0]).getURLString());
        links = this.findTracHyperlinks(this.repository, "{123}", 0, 0);
        TracHyperlinkUtilTest.assertEquals((int)1, (int)links.length);
        TracHyperlinkUtilTest.assertEquals((Object)new Region(0, 5), (Object)links[0].getHyperlinkRegion());
        TracHyperlinkUtilTest.assertEquals((String)"http://localhost/report/123", (String)((WebHyperlink)links[0]).getURLString());
        links = this.findTracHyperlinks(this.repository, "{{123}}", -1, 0);
        TracHyperlinkUtilTest.assertEquals((int)1, (int)links.length);
        TracHyperlinkUtilTest.assertEquals((Object)new Region(1, 5), (Object)links[0].getHyperlinkRegion());
        links = this.findTracHyperlinks(this.repository, "{abc}", -1, 0);
        TracHyperlinkUtilTest.assertNull((Object)links);
        links = this.findTracHyperlinks(this.repository, "{{abc}}", -1, 0);
        TracHyperlinkUtilTest.assertNull((Object)links);
        links = this.findTracHyperlinks(this.repository, "{{{123}}}", -1, 0);
        TracHyperlinkUtilTest.assertNull((Object)links);
    }

    public void testFindHyperlinksChangeset() {
        IHyperlink[] links = this.findTracHyperlinks(this.repository, "r123", 0, 0);
        TracHyperlinkUtilTest.assertEquals((int)1, (int)links.length);
        TracHyperlinkUtilTest.assertEquals((Object)new Region(0, 4), (Object)links[0].getHyperlinkRegion());
        TracHyperlinkUtilTest.assertEquals((String)"http://localhost/changeset/123", (String)((WebHyperlink)links[0]).getURLString());
        links = this.findTracHyperlinks(this.repository, "alr123", 0, 0);
        TracHyperlinkUtilTest.assertNull((Object)links);
        links = this.findTracHyperlinks(this.repository, "[123]", 0, 0);
        TracHyperlinkUtilTest.assertEquals((int)1, (int)links.length);
        TracHyperlinkUtilTest.assertEquals((Object)new Region(0, 5), (Object)links[0].getHyperlinkRegion());
        TracHyperlinkUtilTest.assertEquals((String)"http://localhost/changeset/123", (String)((WebHyperlink)links[0]).getURLString());
        links = this.findTracHyperlinks(this.repository, "![123]", 0, 0);
        TracHyperlinkUtilTest.assertNull((Object)links);
        links = this.findTracHyperlinks(this.repository, "![123]", 1, 0);
        TracHyperlinkUtilTest.assertNull((Object)links);
        links = this.findTracHyperlinks(this.repository, "changeset:123", 0, 0);
        TracHyperlinkUtilTest.assertEquals((int)1, (int)links.length);
        TracHyperlinkUtilTest.assertEquals((Object)new Region(0, 13), (Object)links[0].getHyperlinkRegion());
        TracHyperlinkUtilTest.assertEquals((String)"http://localhost/changeset/123", (String)((WebHyperlink)links[0]).getURLString());
        links = this.findTracHyperlinks(this.repository, "[123/trunk]", 0, 0);
        TracHyperlinkUtilTest.assertEquals((int)1, (int)links.length);
        TracHyperlinkUtilTest.assertEquals((Object)new Region(0, 11), (Object)links[0].getHyperlinkRegion());
        TracHyperlinkUtilTest.assertEquals((String)"http://localhost/changeset/123/trunk", (String)((WebHyperlink)links[0]).getURLString());
        links = this.findTracHyperlinks(this.repository, "changeset:123/trunk", 0, 0);
        TracHyperlinkUtilTest.assertEquals((int)1, (int)links.length);
        TracHyperlinkUtilTest.assertEquals((Object)new Region(0, 19), (Object)links[0].getHyperlinkRegion());
        TracHyperlinkUtilTest.assertEquals((String)"http://localhost/changeset/123/trunk", (String)((WebHyperlink)links[0]).getURLString());
    }

    public void testFindHyperlinksRevisionLog() {
        IHyperlink[] links = this.findTracHyperlinks(this.repository, "r123:456", 0, 0);
        TracHyperlinkUtilTest.assertEquals((int)2, (int)links.length);
        TracHyperlinkUtilTest.assertEquals((String)"http://localhost/log/?rev=123&stop_rev=456", (String)((WebHyperlink)links[0]).getURLString());
        TracHyperlinkUtilTest.assertEquals((Object)new Region(0, 8), (Object)links[0].getHyperlinkRegion());
        links = this.findTracHyperlinks(this.repository, "[123:456]", 0, 0);
        TracHyperlinkUtilTest.assertEquals((int)1, (int)links.length);
        TracHyperlinkUtilTest.assertEquals((String)"http://localhost/log/?rev=123&stop_rev=456", (String)((WebHyperlink)links[0]).getURLString());
        TracHyperlinkUtilTest.assertEquals((Object)new Region(0, 9), (Object)links[0].getHyperlinkRegion());
        links = this.findTracHyperlinks(this.repository, "log:@123:456", 0, 0);
        TracHyperlinkUtilTest.assertEquals((int)1, (int)links.length);
        TracHyperlinkUtilTest.assertEquals((String)"http://localhost/log/?rev=123&stop_rev=456", (String)((WebHyperlink)links[0]).getURLString());
        TracHyperlinkUtilTest.assertEquals((Object)new Region(0, 12), (Object)links[0].getHyperlinkRegion());
        links = this.findTracHyperlinks(this.repository, "log:trunk@123:456", 0, 0);
        TracHyperlinkUtilTest.assertEquals((int)1, (int)links.length);
        TracHyperlinkUtilTest.assertEquals((String)"http://localhost/log/trunk?rev=123&stop_rev=456", (String)((WebHyperlink)links[0]).getURLString());
        TracHyperlinkUtilTest.assertEquals((Object)new Region(0, 17), (Object)links[0].getHyperlinkRegion());
    }

    public void testFindHyperlinksDiff() {
        IHyperlink[] links = this.findTracHyperlinks(this.repository, "diff:@123:456", 0, 0);
        TracHyperlinkUtilTest.assertNotNull((Object)links);
        TracHyperlinkUtilTest.assertEquals((int)1, (int)links.length);
        TracHyperlinkUtilTest.assertEquals((String)"http://localhost/changeset/?new=456&old=123", (String)((WebHyperlink)links[0]).getURLString());
        links = this.findTracHyperlinks(this.repository, "diff:trunk/trac@3538//sandbox/vc-refactoring/trac@3539", 0, 0);
        TracHyperlinkUtilTest.assertNotNull((Object)links);
        TracHyperlinkUtilTest.assertEquals((int)1, (int)links.length);
        TracHyperlinkUtilTest.assertEquals((String)"http://localhost/changeset/?new_path=sandbox%2Fvc-refactoring%2Ftrac&old_path=trunk%2Ftrac&new=3539&old=3538", (String)((WebHyperlink)links[0]).getURLString());
        links = this.findTracHyperlinks(this.repository, "diff:tags/trac-0.9.2/wiki-default//tags/trac-0.9.3/wiki-default", 0, 0);
        TracHyperlinkUtilTest.assertNotNull((Object)links);
        TracHyperlinkUtilTest.assertEquals((int)1, (int)links.length);
        TracHyperlinkUtilTest.assertEquals((String)"http://localhost/changeset/?new_path=tags%2Ftrac-0.9.3%2Fwiki-default&old_path=tags%2Ftrac-0.9.2%2Fwiki-default", (String)((WebHyperlink)links[0]).getURLString());
    }

    public void testFindHyperlinksWiki() {
        IHyperlink[] links = this.findTracHyperlinks(this.repository, "[wiki:page]", 1, 0);
        TracHyperlinkUtilTest.assertNotNull((Object)links);
        TracHyperlinkUtilTest.assertEquals((int)1, (int)links.length);
        TracHyperlinkUtilTest.assertEquals((String)"http://localhost/wiki/page", (String)((WebHyperlink)links[0]).getURLString());
        links = this.findTracHyperlinks(this.repository, "wiki:page", 0, 0);
        TracHyperlinkUtilTest.assertNotNull((Object)links);
        TracHyperlinkUtilTest.assertEquals((int)1, (int)links.length);
        TracHyperlinkUtilTest.assertEquals((String)"http://localhost/wiki/page", (String)((WebHyperlink)links[0]).getURLString());
        links = this.findTracHyperlinks(this.repository, "Page", 0, 0);
        TracHyperlinkUtilTest.assertNull((Object)links);
        links = this.findTracHyperlinks(this.repository, "!Page", 0, 0);
        TracHyperlinkUtilTest.assertNull((Object)links);
        links = this.findTracHyperlinks(this.repository, "ab Page dc", 0, 0);
        TracHyperlinkUtilTest.assertNull((Object)links);
        links = this.findTracHyperlinks(this.repository, "paGe", 0, 0);
        TracHyperlinkUtilTest.assertNull((Object)links);
        links = this.findTracHyperlinks(this.repository, "WikiPage", 0, 0);
        TracHyperlinkUtilTest.assertNotNull((Object)links);
        TracHyperlinkUtilTest.assertEquals((int)1, (int)links.length);
        TracHyperlinkUtilTest.assertEquals((String)"http://localhost/wiki/WikiPage", (String)((WebHyperlink)links[0]).getURLString());
        TracHyperlinkUtilTest.assertEquals((Object)new Region(0, 8), (Object)links[0].getHyperlinkRegion());
        links = this.findTracHyperlinks(this.repository, "!WikiPage", 0, 0);
        TracHyperlinkUtilTest.assertNull((Object)links);
        links = this.findTracHyperlinks(this.repository, "!WikiPage", 1, 0);
        TracHyperlinkUtilTest.assertNull((Object)links);
        links = this.findTracHyperlinks(this.repository, "a WikiPage is here", 4, 0);
        TracHyperlinkUtilTest.assertNotNull((Object)links);
        TracHyperlinkUtilTest.assertEquals((int)1, (int)links.length);
        TracHyperlinkUtilTest.assertEquals((String)"http://localhost/wiki/WikiPage", (String)((WebHyperlink)links[0]).getURLString());
        TracHyperlinkUtilTest.assertEquals((Object)new Region(2, 8), (Object)links[0].getHyperlinkRegion());
        links = this.findTracHyperlinks(this.repository, "a !WikiPage is here", 4, 0);
        TracHyperlinkUtilTest.assertNull((Object)links);
    }

    public void testFindHyperlinksWikiTwoCamelCaseWork() {
        IHyperlink[] links = this.findTracHyperlinks(this.repository, "aWIkiPage is here", 2, 0);
        TracHyperlinkUtilTest.assertNull((Object)links);
        links = this.findTracHyperlinks(this.repository, "aWIkiPage is here", 4, 0);
        TracHyperlinkUtilTest.assertNull((Object)links);
    }

    public void testFindHyperlinksMilestone() {
        IHyperlink[] links = this.findTracHyperlinks(this.repository, "milestone:1.0", 1, 0);
        TracHyperlinkUtilTest.assertNotNull((Object)links);
        TracHyperlinkUtilTest.assertEquals((int)1, (int)links.length);
        TracHyperlinkUtilTest.assertEquals((String)"http://localhost/milestone/1.0", (String)((WebHyperlink)links[0]).getURLString());
    }

    public void testFindHyperlinksAttachment() {
        IHyperlink[] links = this.findTracHyperlinks(this.repository, "attachment:ticket:123:foo.bar", 1, 0);
        TracHyperlinkUtilTest.assertNotNull((Object)links);
        TracHyperlinkUtilTest.assertEquals((String)"123", (String)((TaskHyperlink)links[0]).getTaskId());
    }

    public void testFindHyperlinksFiles() {
        IHyperlink[] links = this.findTracHyperlinks(this.repository, "source:trunk/foo", 1, 0);
        TracHyperlinkUtilTest.assertNotNull((Object)links);
        TracHyperlinkUtilTest.assertEquals((int)1, (int)links.length);
        TracHyperlinkUtilTest.assertEquals((String)"http://localhost/browser/trunk/foo", (String)((WebHyperlink)links[0]).getURLString());
        links = this.findTracHyperlinks(this.repository, "source:trunk/foo@123", 1, 0);
        TracHyperlinkUtilTest.assertNotNull((Object)links);
        TracHyperlinkUtilTest.assertEquals((int)1, (int)links.length);
        TracHyperlinkUtilTest.assertEquals((String)"http://localhost/browser/trunk/foo?rev=123", (String)((WebHyperlink)links[0]).getURLString());
        links = this.findTracHyperlinks(this.repository, "source:trunk/foo@123#L456", 1, 0);
        TracHyperlinkUtilTest.assertNotNull((Object)links);
        TracHyperlinkUtilTest.assertEquals((int)1, (int)links.length);
        TracHyperlinkUtilTest.assertEquals((String)"http://localhost/browser/trunk/foo?rev=123#L456", (String)((WebHyperlink)links[0]).getURLString());
        links = this.findTracHyperlinks(this.repository, "source:/tags/foo_bar-1.1", 1, 0);
        TracHyperlinkUtilTest.assertNotNull((Object)links);
        TracHyperlinkUtilTest.assertEquals((int)1, (int)links.length);
        TracHyperlinkUtilTest.assertEquals((String)"http://localhost/browser/tags/foo_bar-1.1", (String)((WebHyperlink)links[0]).getURLString());
    }

    private IHyperlink[] findTracHyperlinks(TaskRepository repository, String text, int offsetInText, int textOffset) {
        List links = TracHyperlinkUtil.findTracHyperlinks((TaskRepository)repository, (String)text, (int)offsetInText, (int)textOffset);
        return links.isEmpty() ? null : links.toArray(new IHyperlink[0]);
    }
}

