/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.trac.tests.support;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.internal.trac.core.client.ITracClient;
import org.eclipse.mylyn.internal.trac.core.model.TracTicket;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.ITaskAttachment;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.mylyn.trac.tests.support.XmlRpcServer;
import org.junit.Assert;

public class TracTestUtil {
    public static List<ITaskAttachment> getTaskAttachments(ITask task) throws CoreException {
        TaskData taskData = TasksUi.getTaskDataManager().getTaskData(task);
        ArrayList<ITaskAttachment> attachments = new ArrayList<ITaskAttachment>();
        List attributes = taskData.getAttributeMapper().getAttributesByType(taskData, "attachment");
        if (attributes != null) {
            for (TaskAttribute taskAttribute : attributes) {
                ITaskAttachment taskAttachment = TasksUiPlugin.getRepositoryModel().createTaskAttachment(taskAttribute);
                taskData.getAttributeMapper().updateTaskAttachment(taskAttachment, taskAttribute);
                attachments.add(taskAttachment);
            }
        }
        return attachments;
    }

    public static void assertTicketEquals(XmlRpcServer.Ticket expectedTicket, TracTicket actualTicket) throws Exception {
        Assert.assertTrue((boolean)actualTicket.isValid());
        Map<?, ?> expectedValues = expectedTicket.getValues();
        Map values = actualTicket.getValues();
        for (String key : values.keySet()) {
            Object expected = expectedValues.get(key);
            String actual = (String)values.get(key);
            if (key.equals("reporter")) {
                String expectedString;
                int i;
                if (actual != null && actual.endsWith("\u2026") && expected instanceof String && (i = (expectedString = (String)expected).indexOf("@")) != -1) {
                    expected = String.valueOf(expectedString.substring(0, i + 1)) + "\u2026";
                }
            } else if (key.startsWith("_")) continue;
            Assert.assertEquals((String)("Values for key '" + key + "' did not match"), expected, (Object)actual);
        }
    }

    public static void assertTicketEquals(ITracClient.Version accessMode, TracTicket expectedTicket, TracTicket actualTicket) throws Exception {
        Assert.assertTrue((boolean)actualTicket.isValid());
        Map expectedValues = expectedTicket.getValues();
        Map actualValues = actualTicket.getValues();
        for (String key : actualValues.keySet()) {
            Object expected = expectedValues.get(key);
            String actual = (String)actualValues.get(key);
            if (key.equals("reporter")) {
                String expectedString;
                int i;
                if (actual != null && actual.endsWith("\u2026") && expected instanceof String && (i = (expectedString = (String)expected).indexOf("@")) != -1) {
                    expected = String.valueOf(expectedString.substring(0, i + 1)) + "\u2026";
                }
            } else if (key.startsWith("_")) continue;
            if (accessMode == ITracClient.Version.TRAC_0_9 && expected == null && "".equals(actual)) continue;
            Assert.assertEquals((String)("Values for key '" + key + "' did not match"), expected, (Object)actual);
        }
    }

    public static void assertTicketEquals(TracTicket expectedTicket, TracTicket actualTicket) throws Exception {
        TracTestUtil.assertTicketEquals(null, expectedTicket, actualTicket);
    }
}

