/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.trac.tests.client;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Random;
import junit.framework.TestCase;
import org.apache.commons.httpclient.HttpClient;
import org.apache.xmlrpc.XmlRpcException;
import org.apache.xmlrpc.client.XmlRpcClient;
import org.apache.xmlrpc.client.XmlRpcClientConfig;
import org.apache.xmlrpc.client.XmlRpcClientConfigImpl;
import org.apache.xmlrpc.client.XmlRpcTransportFactory;
import org.eclipse.mylyn.commons.repositories.core.auth.UserCredentials;
import org.eclipse.mylyn.commons.sdk.util.CommonTestUtil;
import org.eclipse.mylyn.internal.trac.core.util.TracHttpClientTransportFactory;
import org.eclipse.mylyn.trac.tests.support.TracFixture;

public class TracXmlRpcTest
extends TestCase {
    public static final String XMLRPC_URL = "/login/xmlrpc";
    private XmlRpcClient xmlrpc;
    private String username;
    private Random random;
    private ArrayList<Integer> tickets;

    protected void setUp() throws Exception {
        super.setUp();
        this.random = new Random();
        UserCredentials credentials = CommonTestUtil.getCredentials((CommonTestUtil.PrivilegeLevel)CommonTestUtil.PrivilegeLevel.ADMIN);
        this.createConnection(new URL(String.valueOf(TracFixture.current().getRepositoryUrl()) + XMLRPC_URL), credentials.getUserName(), credentials.getPassword());
        this.tickets = new ArrayList();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        for (int id : this.tickets) {
            this.call("ticket.delete", id);
        }
    }

    private void createConnection(URL url, String username, String password) throws Exception {
        XmlRpcClientConfigImpl config = new XmlRpcClientConfigImpl();
        config.setEncoding("UTF-8");
        config.setBasicUserName(username);
        config.setBasicPassword(password);
        config.setServerURL(url);
        this.xmlrpc = new XmlRpcClient();
        this.xmlrpc.setConfig((XmlRpcClientConfig)config);
        TracHttpClientTransportFactory factory = new TracHttpClientTransportFactory(this.xmlrpc, new HttpClient());
        this.xmlrpc.setTransportFactory((XmlRpcTransportFactory)factory);
        this.username = username;
    }

    private int createTicket(String summary, String description, Map<String, Object> attributes) throws XmlRpcException, IOException {
        int id = (Integer)this.call("ticket.create", summary, description, attributes);
        this.tickets.add(id);
        return id;
    }

    private Object call(String method, Object ... parameters) throws XmlRpcException, IOException {
        Object result = this.xmlrpc.execute(method, parameters);
        if (result instanceof XmlRpcException) {
            throw (XmlRpcException)result;
        }
        return result;
    }

    public Map<String, Object> createMultiCall(String methodName, Object ... parameters) throws XmlRpcException, IOException {
        Hashtable<String, Object> table = new Hashtable<String, Object>();
        table.put("methodName", methodName);
        table.put("params", parameters);
        return table;
    }

    private void internalTestCrud(String module) throws XmlRpcException, IOException {
        try {
            this.call(String.valueOf(module) + ".delete", "foo");
        }
        catch (XmlRpcException xmlRpcException) {
            // empty catch block
        }
        this.call(String.valueOf(module) + ".create", "foo", "bar");
        try {
            this.assertHasValue((Object[])this.call(String.valueOf(module) + ".getAll", new Object[0]), "foo");
            TracXmlRpcTest.assertEquals((String)"bar", (String)((String)this.call(String.valueOf(module) + ".get", "foo")));
            this.call(String.valueOf(module) + ".update", "foo", "baz");
            TracXmlRpcTest.assertEquals((String)"baz", (String)((String)this.call(String.valueOf(module) + ".get", "foo")));
        }
        catch (Throwable throwable) {
            this.call(String.valueOf(module) + ".delete", "foo");
            throw throwable;
        }
        this.call(String.valueOf(module) + ".delete", "foo");
    }

    private Object createValue(Object fieldName, Object clazz) {
        if (clazz == String.class) {
            return String.valueOf(fieldName.toString()) + this.random.nextInt();
        }
        if (clazz == Date.class) {
            return new Date();
        }
        if (clazz == Boolean.class) {
            return this.random.nextBoolean();
        }
        if (clazz == Double.class) {
            return this.random.nextDouble();
        }
        if (clazz == Integer.class) {
            return this.random.nextInt();
        }
        throw new RuntimeException("Invalid test data: " + fieldName + ", " + clazz);
    }

    private void internalTestComponent(String module, Object ... fields) throws XmlRpcException, IOException {
        try {
            this.call(String.valueOf(module) + ".delete", "foo");
        }
        catch (XmlRpcException xmlRpcException) {
            // empty catch block
        }
        Hashtable<String, Object> attributes = new Hashtable<String, Object>();
        int i = 0;
        while (i < fields.length) {
            attributes.put((String)fields[i], this.createValue(fields[i], fields[i + 1]));
            i += 2;
        }
        this.call(String.valueOf(module) + ".create", "foo", attributes);
        try {
            this.assertHasValue((Object[])this.call(String.valueOf(module) + ".getAll", new Object[0]), "foo");
            Map values = (Map)this.call(String.valueOf(module) + ".get", "foo");
            for (String attribute : attributes.keySet()) {
                TracXmlRpcTest.assertEquals(attributes.get(attribute), values.get(attribute));
            }
            int i2 = 0;
            while (i2 < fields.length) {
                attributes.put((String)fields[i2], this.createValue(fields[i2], fields[i2 + 1]));
                i2 += 2;
            }
            this.call(String.valueOf(module) + ".update", "foo", attributes);
            values = (Map)this.call(String.valueOf(module) + ".get", "foo");
            for (String attribute : attributes.keySet()) {
                TracXmlRpcTest.assertEquals(attributes.get(attribute), values.get(attribute));
            }
        }
        catch (Throwable throwable) {
            this.call(String.valueOf(module) + ".delete", "foo");
            throw throwable;
        }
        this.call(String.valueOf(module) + ".delete", "foo");
    }

    public void testMilestoneDate() throws XmlRpcException, IOException {
        try {
            this.call("ticket.milestone.delete", "foo");
        }
        catch (XmlRpcException xmlRpcException) {
            // empty catch block
        }
        int due = (int)(System.currentTimeMillis() / 1000L) + 1000;
        int completed = (int)(System.currentTimeMillis() / 1000L);
        Hashtable<String, Object> attributes = new Hashtable<String, Object>();
        attributes.put("description", "description");
        attributes.put("due", due);
        attributes.put("completed", completed);
        this.call("ticket.milestone.create", "foo", attributes);
        Map values = (Map)this.call("ticket.milestone.get", "foo");
        TracXmlRpcTest.assertEquals((Object)new Integer(due), values.get("due"));
        TracXmlRpcTest.assertEquals((Object)new Integer(completed), values.get("completed"));
        this.call("ticket.milestone.delete", "foo");
    }

    private void assertHasValue(Object[] items, Object value) {
        Object[] objectArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            Object item = objectArray[n2];
            if (item.equals(value)) {
                return;
            }
            ++n2;
        }
        TracXmlRpcTest.fail((String)("Could not find expected value: " + value));
    }

    private void assertTicketHasAttributes(Map<String, Object> attributes, int id, Object[] ticket) {
        this.assertTicketHasAttributes(attributes, id, ticket, true);
    }

    private void assertTicketHasAttributes(Map<String, Object> attributes, int id, Object[] ticket, boolean newTicket) {
        TracXmlRpcTest.assertEquals((Object)id, (Object)ticket[0]);
        TracXmlRpcTest.assertTrue((boolean)(ticket[1] instanceof Integer));
        if (newTicket) {
            TracXmlRpcTest.assertEquals((Object)ticket[1], (Object)ticket[2]);
        } else {
            TracXmlRpcTest.assertTrue(((Integer)ticket[2] >= (Integer)ticket[1] ? 1 : 0) != 0);
        }
        Map values = (Map)ticket[3];
        for (String attribute : attributes.keySet()) {
            TracXmlRpcTest.assertEquals((Object)attributes.get(attribute), values.get(attribute));
        }
    }

    public void testGetTicket() throws XmlRpcException, IOException {
        Hashtable<String, Object> attributes = new Hashtable<String, Object>();
        attributes.put("type", "task");
        attributes.put("status", "closed");
        int id = this.createTicket("summary", "description", attributes);
        attributes.put("summary", "summary");
        attributes.put("description", "description");
        Object[] ticket = (Object[])this.call("ticket.get", id);
        this.assertTicketHasAttributes(attributes, id, ticket);
    }

    public void testGetTicketNonExistant() throws XmlRpcException, IOException {
        try {
            this.call("ticket.delete", Integer.MAX_VALUE);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            List ticket = (List)this.call("ticket.get", Integer.MAX_VALUE);
            TracXmlRpcTest.fail((String)("Expected XmlRpcException, got ticket instead: " + ticket));
        }
        catch (XmlRpcException xmlRpcException) {
            // empty catch block
        }
    }

    public void testGetTicketUmlaute() throws XmlRpcException, IOException {
        Hashtable<String, Object> attributes = new Hashtable<String, Object>();
        int id = this.createTicket("summarya\u0308O\u030b", "\u00d8", attributes);
        attributes.put("summary", "summarya\u0308O\u030b");
        attributes.put("description", "\u00d8");
        Object[] ticket = (Object[])this.call("ticket.get", id);
        this.assertTicketHasAttributes(attributes, id, ticket);
    }

    public void testUpdateTicket() throws XmlRpcException, IOException {
        int id = this.createTicket("summary", "description", new Hashtable<String, Object>());
        Hashtable<String, String> attributes = new Hashtable<String, String>();
        attributes.put("summary", "changed");
        this.call("ticket.update", id, "my comment", attributes);
        attributes.put("description", "description");
        Object[] ticket = (Object[])this.call("ticket.get", id);
        Map values = (Map)ticket[3];
        for (String attribute : attributes.keySet()) {
            TracXmlRpcTest.assertEquals(attributes.get(attribute), values.get(attribute));
        }
    }

    public void testTicketCustomFields() throws XmlRpcException, IOException {
        Hashtable<String, Object> attributes = new Hashtable<String, Object>();
        attributes.put("custom_text_field", "myvalue");
        int id = this.createTicket("summary", "description", attributes);
        attributes.put("custom_checkbox_field", "1");
        attributes.put("custom_select_field", "two");
        attributes.put("custom_radio_field", "baz");
        attributes.put("custom_textarea_field", "default text");
        Object[] ticket = (Object[])this.call("ticket.get", id);
        this.assertTicketHasAttributes(attributes, id, ticket);
        attributes.put("custom_text_field", "myvalue2");
        attributes.put("custom_checkbox_field", "0");
        attributes.put("custom_select_field", "one");
        attributes.put("custom_radio_field", "foo");
        attributes.put("custom_textarea_field", "mytext");
        this.call("ticket.update", id, "my comment", attributes);
        ticket = (Object[])this.call("ticket.get", id);
        this.assertTicketHasAttributes(attributes, id, ticket, false);
    }

    public void testGetChangeLog() throws XmlRpcException, IOException {
        int id = this.createTicket("summary", "description", new Hashtable<String, Object>());
        Hashtable<String, String> attributes = new Hashtable<String, String>();
        attributes.put("summary", "changed");
        this.call("ticket.update", id, "my comment", attributes);
        Object[] log = (Object[])this.call("ticket.changeLog", id, 0);
        Object[] entry = (Object[])log[0];
        TracXmlRpcTest.assertTrue((boolean)(entry[0] instanceof Integer));
        TracXmlRpcTest.assertEquals((Object)this.username, (Object)entry[1]);
        TracXmlRpcTest.assertEquals((Object)"summary", (Object)entry[2]);
        TracXmlRpcTest.assertEquals((Object)"summary", (Object)entry[3]);
        TracXmlRpcTest.assertEquals((Object)"changed", (Object)entry[4]);
    }

    public void testMultiGetTicket() throws XmlRpcException, IOException {
        int id1 = this.createTicket("summary1", "description1", new Hashtable<String, Object>());
        int id2 = this.createTicket("summary2", "description2", new Hashtable<String, Object>());
        ArrayList<Map<String, Object>> calls = new ArrayList<Map<String, Object>>();
        calls.add(this.createMultiCall("ticket.get", id1));
        calls.add(this.createMultiCall("ticket.get", id2));
        Object[] ret = (Object[])this.call("system.multicall", calls);
        Object[] ticket = (Object[])((Object[])ret[0])[0];
        Hashtable<String, Object> attributes = new Hashtable<String, Object>();
        attributes.put("summary", "summary1");
        attributes.put("description", "description1");
        this.assertTicketHasAttributes(attributes, id1, ticket);
        ticket = (Object[])((Object[])ret[1])[0];
        attributes.clear();
        attributes.put("summary", "summary2");
        attributes.put("description", "description2");
        this.assertTicketHasAttributes(attributes, id2, ticket);
    }

    public void testAttachment() throws XmlRpcException, IOException {
        int id = this.createTicket("summary", "description", new Hashtable<String, Object>());
        String filename = (String)this.call("ticket.putAttachment", id, "attach.txt", "description", "data".getBytes(), true);
        Object[] ret = (Object[])this.call("ticket.listAttachments", id);
        TracXmlRpcTest.assertEquals((int)1, (int)ret.length);
        Object[] attachment = (Object[])ret[0];
        TracXmlRpcTest.assertEquals((Object)"attach.txt", (Object)attachment[0]);
        TracXmlRpcTest.assertEquals((Object)"description", (Object)attachment[1]);
        TracXmlRpcTest.assertEquals((Object)4, (Object)attachment[2]);
        TracXmlRpcTest.assertEquals((Object)this.username, (Object)attachment[4]);
        byte[] bytes = (byte[])this.call("ticket.getAttachment", id, filename);
        String data = new String(bytes);
        TracXmlRpcTest.assertEquals((String)"data", (String)data);
        String filename2 = (String)this.call("ticket.putAttachment", id, filename, "newdescription", "newdata".getBytes(), true);
        TracXmlRpcTest.assertEquals((String)filename, (String)filename2);
        ret = (Object[])this.call("ticket.listAttachments", id);
        TracXmlRpcTest.assertEquals((int)1, (int)ret.length);
        attachment = (Object[])ret[0];
        TracXmlRpcTest.assertEquals((Object)"attach.txt", (Object)attachment[0]);
        TracXmlRpcTest.assertEquals((Object)"newdescription", (Object)attachment[1]);
        TracXmlRpcTest.assertEquals((Object)7, (Object)attachment[2]);
        TracXmlRpcTest.assertEquals((Object)this.username, (Object)attachment[4]);
        bytes = (byte[])this.call("ticket.getAttachment", id, filename);
        data = new String(bytes);
        TracXmlRpcTest.assertEquals((String)"newdata", (String)data);
        String filename3 = (String)this.call("ticket.putAttachment", id, "attach.txt", "description", "data".getBytes(), false);
        TracXmlRpcTest.assertFalse((boolean)"attach.txt".equals(filename3));
        ret = (Object[])this.call("ticket.listAttachments", id);
        TracXmlRpcTest.assertEquals((int)2, (int)ret.length);
    }

    public void testDeleteAttachment() throws XmlRpcException, IOException {
        int id = this.createTicket("summary", "description", new Hashtable<String, Object>());
        String filename = (String)this.call("ticket.putAttachment", id, "attach.txt", "description", "data".getBytes(), true);
        Object[] ret = (Object[])this.call("ticket.listAttachments", id);
        TracXmlRpcTest.assertEquals((int)1, (int)ret.length);
        this.call("ticket.deleteAttachment", id, filename);
        ret = (Object[])this.call("ticket.listAttachments", id);
        TracXmlRpcTest.assertEquals((int)0, (int)ret.length);
    }

    public void testDuplicateAttachment() throws XmlRpcException, IOException {
        int id1 = this.createTicket("summary", "description", new Hashtable<String, Object>());
        int id2 = this.createTicket("summary", "description", new Hashtable<String, Object>());
        String filename1 = (String)this.call("ticket.putAttachment", id1, "attach.txt", "description", "data".getBytes(), true);
        String filename2 = (String)this.call("ticket.putAttachment", id2, "attach.txt", "description", "data2".getBytes(), true);
        TracXmlRpcTest.assertEquals((String)"attach.txt", (String)filename1);
        TracXmlRpcTest.assertEquals((String)filename1, (String)filename2);
        byte[] bytes = (byte[])this.call("ticket.getAttachment", id1, "attach.txt");
        String data = new String(bytes);
        TracXmlRpcTest.assertEquals((String)"data", (String)data);
        bytes = (byte[])this.call("ticket.getAttachment", id2, "attach.txt");
        data = new String(bytes);
        TracXmlRpcTest.assertEquals((String)"data2", (String)data);
    }

    public void testQuery() throws XmlRpcException, IOException {
        Object[] ret;
        Object[] objectArray = ret = (Object[])this.call("ticket.query", "summary~=foo|bar|baz");
        int n = ret.length;
        int n2 = 0;
        while (n2 < n) {
            Object id = objectArray[n2];
            this.call("ticket.delete", (Integer)id);
            ++n2;
        }
        int id1 = this.createTicket("foobarsum1", "description", new Hashtable<String, Object>());
        int id2 = this.createTicket("foobaz sum2", "description", new Hashtable<String, Object>());
        int id3 = this.createTicket("foobarbaz3", "foobarbaz description3", new Hashtable<String, Object>());
        ret = (Object[])this.call("ticket.query", "summary=foobarsum1|foobaz sum2");
        TracXmlRpcTest.assertEquals((int)2, (int)ret.length);
        TracXmlRpcTest.assertEquals((Object)id1, (Object)ret[0]);
        TracXmlRpcTest.assertEquals((Object)id2, (Object)ret[1]);
        ret = (Object[])this.call("ticket.query", "summary~=foobarsum1&summary~=foobaz sum2");
        TracXmlRpcTest.assertEquals((int)1, (int)ret.length);
        TracXmlRpcTest.assertEquals((Object)id2, (Object)ret[0]);
        ret = (Object[])this.call("ticket.query", "summary~=bar|baz");
        TracXmlRpcTest.assertEquals((int)3, (int)ret.length);
        ret = (Object[])this.call("ticket.query", "description~=foobarbaz description3");
        TracXmlRpcTest.assertEquals((int)1, (int)ret.length);
        TracXmlRpcTest.assertEquals((Object)id3, (Object)ret[0]);
    }

    public void testQueryAll() throws XmlRpcException, IOException {
        int id = this.createTicket("foo", "description", new Hashtable<String, Object>());
        Object[] ret = (Object[])this.call("ticket.query", "order=id");
        TracXmlRpcTest.assertTrue((ret.length > 0 ? 1 : 0) != 0);
        this.assertHasValue(ret, id);
    }

    public void testPriorities() throws XmlRpcException, IOException {
        this.internalTestCrud("ticket.priority");
    }

    public void testSeverities() throws XmlRpcException, IOException {
        this.internalTestCrud("ticket.severity");
    }

    public void testType() throws XmlRpcException, IOException {
        this.internalTestCrud("ticket.type");
    }

    public void testStatus() throws XmlRpcException, IOException {
        this.internalTestCrud("ticket.status");
    }

    public void testResolutions() throws XmlRpcException, IOException {
        this.internalTestCrud("ticket.resolution");
    }

    public void testVersions() throws XmlRpcException, IOException {
        this.internalTestComponent("ticket.version", "time", Integer.class, "description", String.class);
    }

    public void testComponents() throws XmlRpcException, IOException {
        this.internalTestComponent("ticket.component", "owner", String.class, "description", String.class);
    }

    public void testMilestones() throws XmlRpcException, IOException {
        this.internalTestComponent("ticket.milestone", "due", Integer.class, "completed", Integer.class, "description", String.class);
    }
}

