/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.trac.tests.client;

import junit.framework.TestCase;
import org.eclipse.mylyn.internal.trac.core.model.TracSearch;

public class TracSearchTest
extends TestCase {
    private static final String QUERY1 = "&status=new|assigned|reopened&milestone~=0.1";
    private static final String URL1 = "&status=new&status=assigned&status=reopened&milestone=%7E0.1";
    private TracSearch search1;

    protected void setUp() throws Exception {
        super.setUp();
        this.search1 = new TracSearch();
        this.search1.addFilter("status", "new");
        this.search1.addFilter("status", "assigned");
        this.search1.addFilter("status", "reopened");
        this.search1.addFilter("milestone", "~0.1");
    }

    public void testToQuery() {
        TracSearchTest.assertEquals((String)QUERY1, (String)this.search1.toQuery());
    }

    public void testToQueryEmpty() {
        TracSearchTest.assertEquals((String)"", (String)new TracSearch().toQuery());
    }

    public void testToQueryOperators1() {
        TracSearch search = new TracSearch();
        search.addFilter("is", "a");
        search.addFilter("contains", "~b");
        search.addFilter("starts", "^c");
        search.addFilter("ends", "$d");
        search.addFilter("nis", "!e");
        search.addFilter("ncontains", "!~f");
        search.addFilter("nstarts", "!^g");
        search.addFilter("nends", "!$h");
        TracSearchTest.assertEquals((String)"&is=a&contains~=b&starts^=c&ends$=d&nis!=e&ncontains!~=f&nstarts!^=g&nends!$=h", (String)search.toQuery());
    }

    public void testToQueryOperators2() {
        TracSearch search = new TracSearch();
        search.addFilter("nstarts", "!^g");
        search.addFilter("nis", "!e");
        search.addFilter("is", "a");
        TracSearchTest.assertEquals((String)"&nstarts!^=g&nis!=e&is=a", (String)search.toQuery());
    }

    public void testToQuerySortOrder() {
        this.search1.setOrderBy("id");
        TracSearchTest.assertEquals((String)"&order=id&status=new|assigned|reopened&milestone~=0.1", (String)this.search1.toQuery());
        this.search1.setAscending(false);
        TracSearchTest.assertEquals((String)"&order=id&desc=1&status=new|assigned|reopened&milestone~=0.1", (String)this.search1.toQuery());
        this.search1.setOrderBy("summary");
        this.search1.setAscending(true);
        TracSearchTest.assertEquals((String)"&order=summary&status=new|assigned|reopened&milestone~=0.1", (String)this.search1.toQuery());
    }

    public void testToUrl() {
        TracSearchTest.assertEquals((String)URL1, (String)this.search1.toUrl());
    }

    public void testToUrlEmpty() {
        TracSearchTest.assertEquals((String)"&order=id", (String)new TracSearch().toUrl());
    }

    public void testToUrlEncoding() {
        this.search1.addFilter("encoded", "&");
        TracSearchTest.assertEquals((String)"&status=new&status=assigned&status=reopened&milestone=%7E0.1&encoded=%26", (String)this.search1.toUrl());
    }

    public void testToUrlOperators1() {
        TracSearch search = new TracSearch();
        search.addFilter("is", "a");
        search.addFilter("contains", "~b");
        search.addFilter("starts", "^c");
        search.addFilter("ends", "$d");
        search.addFilter("nis", "!e");
        search.addFilter("ncontains", "!~f");
        search.addFilter("nstarts", "!^g");
        search.addFilter("nends", "!$h");
        TracSearchTest.assertEquals((String)"&is=a&contains=%7Eb&starts=%5Ec&ends=%24d&nis=%21e&ncontains=%21%7Ef&nstarts=%21%5Eg&nends=%21%24h", (String)search.toUrl());
    }

    public void testToUrlOperators2() {
        TracSearch search = new TracSearch();
        search.addFilter("nstarts", "!^g");
        search.addFilter("nis", "!e");
        search.addFilter("is", "a");
        TracSearchTest.assertEquals((String)"&nstarts=%21%5Eg&nis=%21e&is=a", (String)search.toUrl());
    }

    public void testToUrlSortOrder() {
        this.search1.setOrderBy("id");
        TracSearchTest.assertEquals((String)"&order=id&status=new|assigned|reopened&milestone~=0.1", (String)this.search1.toQuery());
        this.search1.setAscending(false);
        TracSearchTest.assertEquals((String)"&order=id&desc=1&status=new|assigned|reopened&milestone~=0.1", (String)this.search1.toQuery());
        this.search1.setOrderBy("summary");
        this.search1.setAscending(true);
        TracSearchTest.assertEquals((String)"&order=summary&status=new|assigned|reopened&milestone~=0.1", (String)this.search1.toQuery());
    }

    public void testToQueryAmpersand() {
        TracSearch search = new TracSearch();
        search.addFilter("milestone", "mile&stone&");
        TracSearchTest.assertEquals((String)"&milestone=mile\\&stone\\&", (String)search.toQuery());
    }

    public void testToQueryPipe() {
        TracSearch search = new TracSearch();
        search.addFilter("field", "|pipes||");
        TracSearchTest.assertEquals((String)"&field=\\|pipes\\|\\|", (String)search.toQuery());
    }

    public void testToQueryPipeAmpersand() {
        TracSearch search = new TracSearch();
        search.addFilter("pipe", "|");
        search.addFilter("amp", "&");
        search.addFilter("amppipe", "|&");
        TracSearchTest.assertEquals((String)"&pipe=\\|&amp=\\&&amppipe=\\|\\&", (String)search.toQuery());
    }
}

