/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.tasks.tests.ui;

import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import junit.framework.TestCase;
import org.eclipse.mylyn.internal.tasks.core.AbstractTask;
import org.eclipse.mylyn.internal.tasks.core.DateRange;
import org.eclipse.mylyn.internal.tasks.core.DayDateRange;
import org.eclipse.mylyn.internal.tasks.core.LocalTask;
import org.eclipse.mylyn.internal.tasks.core.ScheduledTaskContainer;
import org.eclipse.mylyn.internal.tasks.core.TaskActivityManager;
import org.eclipse.mylyn.internal.tasks.core.TaskActivityUtil;
import org.eclipse.mylyn.internal.tasks.core.WeekDateRange;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.tests.TaskTestUtil;

public class ScheduledTaskContainerTest
extends TestCase {
    private TaskActivityManager taskActivityManager;
    private long taskID;
    private TaskRepository repository;
    private final long instant = 1334355143000L;

    protected void setUp() throws Exception {
        this.taskActivityManager = TasksUiPlugin.getTaskActivityManager();
        TaskTestUtil.resetTaskListAndRepositories();
        this.repository = new TaskRepository("mock", "http://mockrepository.test");
        TasksUiPlugin.getRepositoryManager().addRepository(this.repository);
    }

    protected void tearDown() throws Exception {
        this.taskActivityManager.clear();
    }

    public void testUSHawaiiDay() {
        this.runDayTest("US/Hawaii");
    }

    public void testCanadaPacificDay() {
        this.runDayTest("Canada/Pacific");
    }

    public void testBrazilWestDay() {
        this.runDayTest("Brazil/West");
    }

    public void testEuropeDublinDay() {
        this.runDayTest("Europe/Dublin");
    }

    public void testGreenwichDay() {
        this.runDayTest("Greenwich");
    }

    public void testPortugalDay() {
        this.runDayTest("Portugal");
    }

    public void testUniversalDay() {
        this.runDayTest("Universal");
    }

    public void testEuropeViennaDay() {
        this.runDayTest("Europe/Vienna");
    }

    public void testAsiaIstanbulDay() {
        this.runDayTest("Asia/Istanbul");
    }

    public void testAsiaDubaiDay() {
        this.runDayTest("Asia/Dubai");
    }

    public void testIndianComoroDay() {
        this.runDayTest("Indian/Comoro");
    }

    public void testAsiaMacauDay() {
        this.runDayTest("Asia/Macau");
    }

    public void testAustraliaSouthDay() {
        this.runDayTest("Australia/South");
    }

    public void testAsiaTokyoDay() {
        this.runDayTest("Asia/Tokyo");
    }

    public void testUSHawaiiWeek() {
        this.runWeekTest("US/Hawaii");
    }

    public void testCanadaPacificWeek() {
        this.runWeekTest("Canada/Pacific");
    }

    public void testBrazilWestWeek() {
        this.runWeekTest("Brazil/West");
    }

    public void testEuropeDublinWeek() {
        this.runWeekTest("Europe/Dublin");
    }

    public void testGreenwichWeek() {
        this.runWeekTest("Greenwich");
    }

    public void testPortugalWeek() {
        this.runWeekTest("Portugal");
    }

    public void testUniversalWeek() {
        this.runWeekTest("Universal");
    }

    public void testEuropeViennaWeek() {
        this.runWeekTest("Europe/Vienna");
    }

    public void testAsiaIstanbulWeek() {
        this.runWeekTest("Asia/Istanbul");
    }

    public void testAsiaDubaiWeek() {
        this.runWeekTest("Asia/Dubai");
    }

    public void testIndianComoroWeek() {
        this.runWeekTest("Indian/Comoro");
    }

    public void testAsiaMacauWeek() {
        this.runWeekTest("Asia/Macau");
    }

    public void testAustraliaSouthWeek() {
        this.runWeekTest("Australia/South");
    }

    public void testAsiaTokyoWeek() {
        this.runWeekTest("Asia/Tokyo");
    }

    protected void runDayTest(String localTimezone) {
        AbstractTask taskUSHawaii = this.createTaskScheduledForDay(1334355143000L, "US/Hawaii");
        AbstractTask taskCanadaPacific = this.createTaskScheduledForDay(1334355143000L, "Canada/Pacific");
        AbstractTask taskCanadaEastern = this.createTaskScheduledForDay(1334355143000L, "Canada/Eastern");
        AbstractTask taskEuropeWarsaw = this.createTaskScheduledForDay(1334355143000L, "Europe/Warsaw");
        AbstractTask taskIndianComoro = this.createTaskScheduledForDay(1334355143000L, "Indian/Comoro");
        AbstractTask taskAsiaTokyo = this.createTaskScheduledForDay(1334355143000L, "Asia/Tokyo");
        AbstractTask taskAustraliaSydney = this.createTaskScheduledForDay(1334355143000L, "Australia/Sydney");
        AbstractTask taskUSHawaiiDue = this.createTaskDueForDay(1334355143000L, "US/Hawaii");
        AbstractTask taskCanadaPacificDue = this.createTaskDueForDay(1334355143000L, "Canada/Pacific");
        AbstractTask taskCanadaEasternDue = this.createTaskDueForDay(1334355143000L, "Canada/Eastern");
        AbstractTask taskEuropeWarsawDue = this.createTaskDueForDay(1334355143000L, "Europe/Warsaw");
        AbstractTask taskIndianComoroDue = this.createTaskDueForDay(1334355143000L, "Indian/Comoro");
        AbstractTask taskAsiaTokyoDue = this.createTaskDueForDay(1334355143000L, "Asia/Tokyo");
        AbstractTask taskAustraliaSydneyDue = this.createTaskDueForDay(1334355143000L, "Australia/Sydney");
        ScheduledTaskContainer dayContainer = new ScheduledTaskContainer(this.taskActivityManager, (DateRange)this.getDayOf(1334355143000L, localTimezone));
        ScheduledTaskContainerTest.assertTrue((boolean)dayContainer.getChildren().contains(taskUSHawaii));
        ScheduledTaskContainerTest.assertTrue((boolean)dayContainer.getChildren().contains(taskCanadaPacific));
        ScheduledTaskContainerTest.assertTrue((boolean)dayContainer.getChildren().contains(taskCanadaEastern));
        ScheduledTaskContainerTest.assertTrue((boolean)dayContainer.getChildren().contains(taskEuropeWarsaw));
        ScheduledTaskContainerTest.assertTrue((boolean)dayContainer.getChildren().contains(taskIndianComoro));
        ScheduledTaskContainerTest.assertTrue((boolean)dayContainer.getChildren().contains(taskAsiaTokyo));
        ScheduledTaskContainerTest.assertTrue((boolean)dayContainer.getChildren().contains(taskAustraliaSydney));
        ScheduledTaskContainerTest.assertTrue((boolean)dayContainer.getChildren().contains(taskUSHawaiiDue));
        ScheduledTaskContainerTest.assertTrue((boolean)dayContainer.getChildren().contains(taskCanadaPacificDue));
        ScheduledTaskContainerTest.assertTrue((boolean)dayContainer.getChildren().contains(taskCanadaEasternDue));
        ScheduledTaskContainerTest.assertTrue((boolean)dayContainer.getChildren().contains(taskEuropeWarsawDue));
        ScheduledTaskContainerTest.assertTrue((boolean)dayContainer.getChildren().contains(taskIndianComoroDue));
        ScheduledTaskContainerTest.assertTrue((boolean)dayContainer.getChildren().contains(taskAsiaTokyoDue));
        ScheduledTaskContainerTest.assertTrue((boolean)dayContainer.getChildren().contains(taskAustraliaSydneyDue));
        DayDateRange previousDay = this.getDayOf(1334355143000L, localTimezone);
        this.snapForwardNumDays(previousDay, -1);
        ScheduledTaskContainer previousDayContainer = new ScheduledTaskContainer(this.taskActivityManager, (DateRange)previousDay);
        ScheduledTaskContainerTest.assertTrue((boolean)previousDayContainer.getChildren().isEmpty());
        DayDateRange nextDay = this.getDayOf(1334355143000L, localTimezone);
        this.snapForwardNumDays(nextDay, 1);
        ScheduledTaskContainer nextDayContainer = new ScheduledTaskContainer(this.taskActivityManager, (DateRange)nextDay);
        ScheduledTaskContainerTest.assertTrue((boolean)nextDayContainer.getChildren().isEmpty());
    }

    protected void runWeekTest(String localTimezone) {
        AbstractTask taskUSHawaii = this.createTaskScheduledForWeek(1334355143000L, "US/Hawaii");
        AbstractTask taskCanadaPacific = this.createTaskScheduledForWeek(1334355143000L, "Canada/Pacific");
        AbstractTask taskCanadaEastern = this.createTaskScheduledForWeek(1334355143000L, "Canada/Eastern");
        AbstractTask taskEuropeWarsaw = this.createTaskScheduledForWeek(1334355143000L, "Europe/Warsaw");
        AbstractTask taskIndianComoro = this.createTaskScheduledForWeek(1334355143000L, "Indian/Comoro");
        AbstractTask taskAsiaTokyo = this.createTaskScheduledForWeek(1334355143000L, "Asia/Tokyo");
        AbstractTask taskAustraliaSydney = this.createTaskScheduledForWeek(1334355143000L, "Australia/Sydney");
        ScheduledTaskContainer weekContainer = new ScheduledTaskContainer(this.taskActivityManager, this.getWeekOf(1334355143000L, localTimezone));
        ScheduledTaskContainerTest.assertTrue((boolean)weekContainer.getChildren().contains(taskUSHawaii));
        ScheduledTaskContainerTest.assertTrue((boolean)weekContainer.getChildren().contains(taskCanadaPacific));
        ScheduledTaskContainerTest.assertTrue((boolean)weekContainer.getChildren().contains(taskCanadaEastern));
        ScheduledTaskContainerTest.assertTrue((boolean)weekContainer.getChildren().contains(taskEuropeWarsaw));
        ScheduledTaskContainerTest.assertTrue((boolean)weekContainer.getChildren().contains(taskIndianComoro));
        ScheduledTaskContainerTest.assertTrue((boolean)weekContainer.getChildren().contains(taskAsiaTokyo));
        ScheduledTaskContainerTest.assertTrue((boolean)weekContainer.getChildren().contains(taskAustraliaSydney));
        DayDateRange previousDay = TaskActivityUtil.getDayOf((Date)weekContainer.getDateRange().getStartDate().getTime());
        this.snapForwardNumDays(previousDay, -1);
        ScheduledTaskContainer previousDayContainer = new ScheduledTaskContainer(this.taskActivityManager, (DateRange)previousDay);
        ScheduledTaskContainerTest.assertTrue((boolean)previousDayContainer.getChildren().isEmpty());
        DayDateRange nextDay = TaskActivityUtil.getDayOf((Date)weekContainer.getDateRange().getEndDate().getTime());
        this.snapForwardNumDays(nextDay, 1);
        ScheduledTaskContainer nextDayContainer = new ScheduledTaskContainer(this.taskActivityManager, (DateRange)nextDay);
        ScheduledTaskContainerTest.assertTrue((boolean)nextDayContainer.getChildren().isEmpty());
        WeekDateRange previousWeek = TaskActivityUtil.getWeekOf((Date)previousDay.getStartDate().getTime());
        ScheduledTaskContainer previousWeekContainer = new ScheduledTaskContainer(this.taskActivityManager, (DateRange)previousWeek);
        ScheduledTaskContainerTest.assertTrue((boolean)previousWeekContainer.getChildren().isEmpty());
        WeekDateRange nextWeek = TaskActivityUtil.getWeekOf((Date)nextDay.getStartDate().getTime());
        ScheduledTaskContainer nextWeekContainer = new ScheduledTaskContainer(this.taskActivityManager, (DateRange)nextWeek);
        ScheduledTaskContainerTest.assertTrue((boolean)nextWeekContainer.getChildren().isEmpty());
    }

    protected void snapForwardNumDays(DayDateRange previousDay, int num) {
        previousDay.getStartDate().add(5, num);
        previousDay.getEndDate().add(5, num);
    }

    protected AbstractTask createTaskScheduledForDay(long date, String timezone) {
        LocalTask task = new LocalTask(String.valueOf(this.taskID++), "task " + this.taskID);
        this.taskActivityManager.setScheduledFor((AbstractTask)task, (DateRange)this.getDayOf(date, timezone));
        return task;
    }

    protected AbstractTask createTaskDueForDay(long date, String timezone) {
        LocalTask task = new LocalTask(String.valueOf(this.taskID++), "task " + this.taskID);
        this.taskActivityManager.setDueDate((ITask)task, this.getDayOf(date, timezone).getStartDate().getTime());
        return task;
    }

    protected AbstractTask createTaskScheduledForWeek(long date, String timezone) {
        LocalTask task = new LocalTask(String.valueOf(this.taskID++), "task " + this.taskID);
        this.taskActivityManager.setScheduledFor((AbstractTask)task, this.getWeekOf(date, timezone));
        return task;
    }

    protected DateRange getWeekOf(long date, String timezoneString) {
        TimeZone timeZone = TimeZone.getTimeZone(timezoneString);
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(date);
        Calendar start = this.getSameDayInTimeZone(cal, timeZone);
        TaskActivityUtil.snapStartOfWorkWeek((Calendar)start);
        Calendar end = this.getSameDayInTimeZone(cal, timeZone);
        TaskActivityUtil.snapEndOfWeek((Calendar)end);
        WeekDateRange weekInTimezone = new WeekDateRange(start, end);
        return weekInTimezone;
    }

    protected DayDateRange getDayOf(long date, String timezoneString) {
        TimeZone timeZone = TimeZone.getTimeZone(timezoneString);
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(date);
        Calendar start = this.getSameDayInTimeZone(cal, timeZone);
        Calendar end = this.getSameDayInTimeZone(cal, timeZone);
        TaskActivityUtil.snapEndOfDay((Calendar)end);
        DayDateRange dayInTimezone = new DayDateRange(start, end);
        return dayInTimezone;
    }

    protected Calendar getSameDayInTimeZone(Calendar cal, TimeZone timeZone) {
        Calendar day = Calendar.getInstance(timeZone);
        day.set(1, cal.get(1));
        day.set(2, cal.get(2));
        day.set(5, cal.get(5));
        TaskActivityUtil.snapStartOfDay((Calendar)day);
        return day;
    }
}

