/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.core.data;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.internal.tasks.core.data.TaskDataExternalizer;
import org.eclipse.mylyn.internal.tasks.core.data.TaskDataState;
import org.eclipse.mylyn.tasks.core.IRepositoryManager;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.xml.sax.SAXException;

public class TaskDataStore {
    private static final String FILE_NAME_INTERNAL = "data.xml";
    private final TaskDataExternalizer externalizer;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();

    public TaskDataStore(IRepositoryManager taskRepositoryManager) {
        this(new TaskDataExternalizer(taskRepositoryManager));
    }

    TaskDataStore(TaskDataExternalizer externalizer) {
        this.externalizer = externalizer;
    }

    public TaskDataState discardEdits(File file) throws CoreException {
        TaskDataState state = this.readState(file);
        if (state != null) {
            state.setEditsData(null);
        }
        this.writeState(file, state);
        return state;
    }

    public TaskDataState getTaskDataState(File file) throws CoreException {
        return this.readState(file);
    }

    public void putEdits(File file, TaskData data) throws CoreException {
        Assert.isNotNull((Object)file);
        Assert.isNotNull((Object)data);
        TaskDataState state = this.readState(file);
        if (state == null) {
            state = new TaskDataState(data.getConnectorKind(), data.getRepositoryUrl(), data.getTaskId());
        }
        state.setEditsData(data);
        this.writeState(file, state);
    }

    public TaskDataState putTaskData(File file, TaskData data, boolean setLastRead, boolean user) throws CoreException {
        TaskDataState state;
        block4: {
            Assert.isNotNull((Object)file);
            Assert.isNotNull((Object)data);
            state = null;
            try {
                state = this.readState(file);
            }
            catch (CoreException e) {
                if (user) break block4;
                throw new CoreException((IStatus)new Status(4, "org.eclipse.mylyn.tasks.core", "Reading of existing task data failed. Forcing synchronization will override outgoing changes.", (Throwable)e));
            }
        }
        if (state == null) {
            state = new TaskDataState(data.getConnectorKind(), data.getRepositoryUrl(), data.getTaskId());
        }
        if (setLastRead) {
            state.setLastReadData(state.getRepositoryData());
        }
        state.setRepositoryData(data);
        this.writeState(file, state);
        return state;
    }

    public TaskDataState setTaskData(File file, TaskData data) throws CoreException {
        Assert.isNotNull((Object)file);
        Assert.isNotNull((Object)data);
        TaskDataState state = new TaskDataState(data.getConnectorKind(), data.getRepositoryUrl(), data.getTaskId());
        state.setRepositoryData(data);
        state.setEditsData(null);
        state.setLastReadData(data);
        this.writeState(file, state);
        return state;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private TaskDataState readStateInternal(File file, boolean xml11) throws IOException, SAXException {
        Throwable throwable = null;
        Object var4_5 = null;
        try {
            TaskDataState taskDataState;
            ZipInputStream in = new ZipInputStream(new BufferedInputStream(new FileInputStream(file)));
            try {
                in.getNextEntry();
                if (xml11) {
                    taskDataState = this.externalizer.readState(new TaskDataExternalizer.Xml11InputStream(in));
                    return taskDataState;
                }
                return this.externalizer.readState(in);
            }
            catch (Throwable throwable2) {
                throw throwable2;
            }
            finally {
                if (in == null) return taskDataState;
                in.close();
            }
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            }
            if (throwable == throwable3) throw throwable;
            throwable.addSuppressed(throwable3);
            throw throwable;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private TaskDataState readState(File file) throws CoreException {
        this.lock.readLock().lock();
        try {
            if (!file.exists()) return null;
            try {
                TaskDataState taskDataState = this.readStateInternal(file, false);
                return taskDataState;
            }
            catch (SAXException e) {
                block11: {
                    if (e.getMessage() == null || !e.getMessage().contains("invalid XML character") && !e.getMessage().contains(" \"&#")) break block11;
                    TaskDataState taskDataState = this.readStateInternal(file, true);
                    this.lock.readLock().unlock();
                    return taskDataState;
                }
                try {
                    try {
                        throw e;
                    }
                    catch (SAXException e2) {
                        throw new IOException("Error parsing task data: " + e2.getMessage());
                    }
                }
                catch (IOException e2) {
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.mylyn.tasks.core", "Error reading task data", (Throwable)e2));
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    private void writeState(File file, TaskDataState state) throws CoreException {
        this.lock.writeLock().lock();
        try {
            try {
                Throwable throwable = null;
                Object var4_6 = null;
                try (ZipOutputStream out = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(file)));){
                    out.setMethod(8);
                    ZipEntry entry = new ZipEntry(FILE_NAME_INTERNAL);
                    out.putNextEntry(entry);
                    this.externalizer.writeState(out, state);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.mylyn.tasks.core", "Error writing task data", (Throwable)e));
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void putTaskData(File file, TaskDataState state) throws CoreException {
        this.writeState(file, state);
    }

    public boolean deleteTaskData(File file) {
        this.lock.writeLock().lock();
        try {
            boolean bl = file.delete();
            return bl;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }
}

