/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.commons.notifications.feed;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.commons.notifications.core.IFilterable;
import org.eclipse.mylyn.commons.notifications.core.NotificationEnvironment;
import org.eclipse.mylyn.internal.commons.notifications.feed.FeedEntry;
import org.eclipse.mylyn.internal.commons.notifications.feed.RSS;
import org.eclipse.mylyn.internal.commons.notifications.feed.RSSItem;

public class FeedReader {
    private final NotificationEnvironment environment;
    private final List<FeedEntry> entries;
    private final String eventId;

    public FeedReader(String eventId, NotificationEnvironment environment) {
        this.eventId = eventId;
        this.environment = environment;
        this.entries = new ArrayList<FeedEntry>();
    }

    public IStatus parse(InputStream in, IProgressMonitor monitor) {
        try {
            JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{RSS.class});
            Unmarshaller unmarshaller = jc.createUnmarshaller();
            JAXBElement rss = unmarshaller.unmarshal((Source)new StreamSource(in), RSS.class);
            for (RSSItem rssItem : ((RSS)rss.getValue()).getItems()) {
                final FeedEntry entry = this.createEntry(rssItem);
                if (!this.environment.matches(new IAdaptable(){

                    public Object getAdapter(Class adapter) {
                        if (adapter == IFilterable.class) {
                            return new IFilterable(){

                                public List<String> getFilters(String key) {
                                    return entry.getFilters(key);
                                }

                                public String getFilter(String key) {
                                    return entry.getFilter(key);
                                }
                            };
                        }
                        if (adapter == FeedEntry.class) {
                            return entry;
                        }
                        return null;
                    }
                }, monitor)) continue;
                this.entries.add(entry);
            }
            IStatus iStatus = Status.OK_STATUS;
            return iStatus;
        }
        catch (Exception e) {
            Status status = new Status(4, "org.eclipse.mylyn.commons.notifications.feed", 4, "Failed to parse RSS feed", (Throwable)e);
            return status;
        }
        finally {
            try {
                in.close();
            }
            catch (IOException iOException) {}
        }
    }

    protected FeedEntry createEntry(RSSItem rssItem) {
        return new FeedEntry(this.eventId, rssItem);
    }

    public List<FeedEntry> getEntries() {
        return this.entries;
    }
}

