/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.gerrit.ui.wizards;

import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.TextContentAdapter;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.mylyn.commons.workbench.forms.SectionComposite;
import org.eclipse.mylyn.internal.gerrit.core.GerritConnector;
import org.eclipse.mylyn.internal.gerrit.core.GerritCorePlugin;
import org.eclipse.mylyn.internal.gerrit.core.client.GerritClient;
import org.eclipse.mylyn.internal.gerrit.ui.wizards.Messages;
import org.eclipse.mylyn.internal.gerrit.ui.wizards.ProjectNameContentProposalProvider;
import org.eclipse.mylyn.tasks.core.IRepositoryQuery;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.wizards.AbstractRepositoryQueryPage2;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.fieldassist.ContentAssistCommandAdapter;

public class GerritCustomQueryPage
extends AbstractRepositoryQueryPage2 {
    private Button myChangesButton;
    private Button watchedChangesButton;
    private Button allOpenChangesButton;
    private Button byProjectButton;
    private Button customQueryButton;
    private Text projectText;
    private Text queryText;

    public GerritCustomQueryPage(TaskRepository repository, String pageName, IRepositoryQuery query) {
        super(pageName, repository, query);
        this.setDescription(Messages.GerritCustomQueryPage_Enter_title_and_select_query_type);
        this.setNeedsClear(true);
        this.setNeedsRefresh(true);
    }

    protected void createPageContent(SectionComposite parent) {
        Composite composite = parent.getContent();
        composite.setLayout((Layout)new GridLayout(2, false));
        ModifyListener modifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                GerritCustomQueryPage.this.updateButtons();
            }
        };
        Group group = new Group(composite, 0);
        group.setText(Messages.GerritCustomQueryPage_Query_type);
        GridLayoutFactory.swtDefaults().numColumns(2).spacing(7, 5).applyTo((Composite)group);
        GridDataFactory.fillDefaults().grab(true, false).span(2, 1).applyTo((Control)group);
        this.myChangesButton = new Button((Composite)group, 16);
        this.myChangesButton.setText(Messages.GerritCustomQueryPage_My_changes);
        GridDataFactory.fillDefaults().span(2, 1).applyTo((Control)this.myChangesButton);
        this.watchedChangesButton = new Button((Composite)group, 16);
        this.watchedChangesButton.setText(Messages.GerritCustomQueryPage_My_watched_changes);
        GridDataFactory.fillDefaults().span(2, 1).applyTo((Control)this.watchedChangesButton);
        this.allOpenChangesButton = new Button((Composite)group, 16);
        this.allOpenChangesButton.setText(Messages.GerritCustomQueryPage_All_open_changes);
        GridDataFactory.fillDefaults().span(2, 1).applyTo((Control)this.allOpenChangesButton);
        this.byProjectButton = new Button((Composite)group, 16);
        this.byProjectButton.setText(Messages.GerritCustomQueryPage_Open_changes_by_project);
        this.projectText = new Text((Composite)group, 2048);
        this.projectText.setLayoutData((Object)new GridData(768));
        this.projectText.addModifyListener(modifyListener);
        this.addProjectNameContentProposal(this.projectText);
        new Label(composite, 0);
        this.customQueryButton = new Button((Composite)group, 16);
        this.customQueryButton.setText(Messages.GerritCustomQueryPage_Custom_query);
        this.queryText = new Text((Composite)group, 2048);
        this.queryText.setLayoutData((Object)new GridData(768));
        this.queryText.addModifyListener(modifyListener);
        SelectionAdapter buttonSelectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GerritCustomQueryPage.this.updateButtons();
            }
        };
        this.myChangesButton.addSelectionListener((SelectionListener)buttonSelectionListener);
        this.watchedChangesButton.addSelectionListener((SelectionListener)buttonSelectionListener);
        this.allOpenChangesButton.addSelectionListener((SelectionListener)buttonSelectionListener);
        this.byProjectButton.addSelectionListener((SelectionListener)buttonSelectionListener);
        this.customQueryButton.addSelectionListener((SelectionListener)buttonSelectionListener);
    }

    private void addProjectNameContentProposal(Text text) {
        ProjectNameContentProposalProvider proposalProvider = new ProjectNameContentProposalProvider(GerritCorePlugin.getDefault().getConnector(), this.getTaskRepository());
        ContentAssistCommandAdapter adapter = new ContentAssistCommandAdapter((Control)text, (IControlContentAdapter)new TextContentAdapter(), (IContentProposalProvider)proposalProvider, null, new char[0], true);
        adapter.setProposalAcceptanceStyle(2);
    }

    private GerritClient getGerritClient() {
        GerritConnector connector = GerritCorePlugin.getDefault().getConnector();
        return connector.getClient(this.getTaskRepository());
    }

    protected void updateButtons() {
        this.projectText.setEnabled(this.byProjectButton.getSelection());
        this.queryText.setEnabled(this.customQueryButton.getSelection());
        IWizardContainer c = this.getContainer();
        if (c != null && c.getCurrentPage() != null) {
            c.updateButtons();
        }
    }

    public boolean isPageComplete() {
        boolean ret;
        boolean bl = ret = this.getQueryTitle() != null && this.getQueryTitle().trim().length() > 0;
        if (this.byProjectButton != null && this.byProjectButton.getSelection()) {
            ret &= this.projectText != null && this.projectText.getText().length() > 0;
        }
        if (this.customQueryButton != null && this.customQueryButton.getSelection()) {
            ret &= this.queryText != null && this.queryText.getText().length() > 0;
        }
        return ret;
    }

    public void applyTo(IRepositoryQuery query) {
        query.setSummary(this.getQueryTitle());
        if (this.myChangesButton.getSelection()) {
            query.setAttribute("gerrit query type", "my changes");
        } else if (this.watchedChangesButton.getSelection()) {
            query.setAttribute("gerrit query type", "my watched changes");
        } else if (this.byProjectButton.getSelection()) {
            query.setAttribute("gerrit query type", "open changes by project");
        } else if (this.customQueryButton.getSelection()) {
            query.setAttribute("gerrit query type", "custom");
        } else {
            query.setAttribute("gerrit query type", "all open changes");
        }
        query.setAttribute("gerrit query project", this.projectText.getText());
        query.setAttribute("gerrit query string", this.queryText.getText());
    }

    protected void doRefreshControls() {
    }

    protected boolean hasRepositoryConfiguration() {
        return this.getGerritClient().getConfiguration() != null;
    }

    protected void doClearControls() {
        this.restoreState(null);
    }

    protected boolean restoreState(IRepositoryQuery query) {
        if (query != null) {
            this.setQueryTitle(query.getSummary());
            if ("my changes".equals(query.getAttribute("gerrit query type"))) {
                this.myChangesButton.setSelection(true);
            } else if ("my watched changes".equals(query.getAttribute("gerrit query type"))) {
                this.watchedChangesButton.setSelection(true);
            } else if ("open changes by project".equals(query.getAttribute("gerrit query type"))) {
                this.byProjectButton.setSelection(true);
            } else if ("custom".equals(query.getAttribute("gerrit query type"))) {
                this.customQueryButton.setSelection(true);
            } else {
                this.allOpenChangesButton.setSelection(true);
            }
            if (query.getAttribute("gerrit query project") != null) {
                this.projectText.setText(query.getAttribute("gerrit query project"));
            }
            if (query.getAttribute("gerrit query string") != null) {
                this.queryText.setText(query.getAttribute("gerrit query string"));
            }
        } else {
            this.myChangesButton.setSelection(true);
            this.watchedChangesButton.setSelection(false);
            this.byProjectButton.setSelection(false);
            this.customQueryButton.setSelection(false);
            this.allOpenChangesButton.setSelection(false);
            this.projectText.setText("");
            this.queryText.setText("");
        }
        this.updateButtons();
        return true;
    }

    protected String suggestQueryTitle() {
        if (this.myChangesButton.isDisposed()) {
            return "";
        }
        if (this.myChangesButton.getSelection()) {
            return Messages.GerritCustomQueryPage_My_changes;
        }
        if (this.watchedChangesButton.getSelection()) {
            return Messages.GerritCustomQueryPage_My_watched_changes;
        }
        if (this.allOpenChangesButton.getSelection()) {
            return Messages.GerritCustomQueryPage_All_open_changes;
        }
        if (this.byProjectButton.getSelection()) {
            return NLS.bind((String)Messages.GerritCustomQueryPage_Open_Changes_in_X, (Object)this.projectText.getText());
        }
        return "";
    }
}

