/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.tasks.tests.core;

import com.google.common.collect.ImmutableSet;
import java.util.HashMap;
import java.util.Map;
import junit.framework.TestCase;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.mylyn.commons.ui.CommonImages;
import org.eclipse.mylyn.internal.tasks.core.TaskRepositoryManager;
import org.eclipse.mylyn.internal.tasks.core.TaskTask;
import org.eclipse.mylyn.internal.tasks.ui.IBrandManager;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.tests.support.MockRepositoryConnectorAdapter;
import org.eclipse.mylyn.tasks.tests.support.MockRepositoryConnectorDescriptor;
import org.eclipse.mylyn.tasks.ui.AbstractRepositoryConnectorUi;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.swt.graphics.Image;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class RepositoryConnectorContributorTest
extends TestCase {
    private final IBrandManager manager = TasksUiPlugin.getDefault().getBrandManager();
    private final MockRepositoryConnectorDescriptor.DynamicMockRepositoryConnector connector = new MockRepositoryConnectorDescriptor.DynamicMockRepositoryConnector();
    private final Map<String, TaskRepository> repositories = new HashMap<String, TaskRepository>();
    private final Map<String, ITask> tasks = new HashMap<String, ITask>();
    private TaskRepository repositoryForConnectorWithNoBrands;
    private TaskTask taskForConnectorWithNoBrands;

    @Before
    protected void setUp() throws Exception {
        this.setUpBrand("org.mylyn");
        this.setUpBrand("org.eclipse");
        this.setUpBrand("unknown");
        this.setUpBrand("exceptional");
        this.setUpBrand(null);
        String repositoryUrl = "http://mock-connector-with-no-brands";
        this.repositoryForConnectorWithNoBrands = new TaskRepository("mock-connector-with-no-brands", repositoryUrl);
        this.repositoryForConnectorWithNoBrands.setProperty("org.eclipse.mylyn.brand.id", "org.mylyn");
        TasksUi.getRepositoryManager().addRepository(this.repositoryForConnectorWithNoBrands);
        this.taskForConnectorWithNoBrands = new TaskTask("mock-connector-with-no-brands", repositoryUrl, "1");
    }

    private void setUpBrand(String brand) {
        String repositoryUrl = "http://mock-" + brand;
        TaskRepository repository = new TaskRepository(this.connector.getConnectorKind(), repositoryUrl);
        repository.setProperty("org.eclipse.mylyn.brand.id", brand);
        TasksUi.getRepositoryManager().addRepository(repository);
        this.repositories.put(brand, repository);
        this.tasks.put(brand, (ITask)new TaskTask(this.connector.getConnectorKind(), repositoryUrl, "1"));
    }

    @After
    protected void tearDown() throws Exception {
        for (TaskRepository repository : this.repositories.values()) {
            ((TaskRepositoryManager)TasksUi.getRepositoryManager()).removeRepository(repository);
        }
        ((TaskRepositoryManager)TasksUi.getRepositoryManager()).removeRepository(this.repositoryForConnectorWithNoBrands);
    }

    @Test
    public void testConnectorContributed() {
        AbstractRepositoryConnector connector = TasksUi.getRepositoryConnector((String)"mock.dynamic");
        RepositoryConnectorContributorTest.assertNotNull((String)"Expected dynamically contributed mock connector", (Object)connector);
        RepositoryConnectorContributorTest.assertEquals(MockRepositoryConnectorDescriptor.DynamicMockRepositoryConnector.class, connector.getClass());
        RepositoryConnectorContributorTest.assertEquals((String)"mock.dynamic", (String)connector.getConnectorKind());
    }

    @Test
    public void testConnectorUiContributed() {
        AbstractRepositoryConnectorUi connector = TasksUi.getRepositoryConnectorUi((String)"mock.dynamic");
        RepositoryConnectorContributorTest.assertNotNull((String)"Expected connector UI contributed by MockRepositoryConnectorAdapter", (Object)connector);
        RepositoryConnectorContributorTest.assertEquals(MockRepositoryConnectorAdapter.DynamicMockRepositoryConnectorUi.class, connector.getClass());
        RepositoryConnectorContributorTest.assertEquals((String)"mock.dynamic", (String)connector.getConnectorKind());
    }

    @Test
    public void testDefaultBrandingIcon() {
        Image brandingImage = TasksUiPlugin.getDefault().getBrandManager().getDefaultBrandingIcon("mock.dynamic");
        RepositoryConnectorContributorTest.assertNotNull((String)"Expected branding image contributed by MockRepositoryConnectorAdapter", (Object)brandingImage);
        RepositoryConnectorContributorTest.assertEquals((int)16, (int)brandingImage.getImageData().height);
    }

    @Test
    public void testDefaultOverlayIcon() {
        ImageDescriptor overlay = TasksUiPlugin.getDefault().getBrandManager().getDefaultOverlayIcon("mock.dynamic");
        RepositoryConnectorContributorTest.assertNotNull((String)"Expected overlay image contributed by MockRepositoryConnectorAdapter", (Object)overlay);
        RepositoryConnectorContributorTest.assertEquals((int)8, (int)overlay.getImageData().height);
    }

    @Test
    public void testGetBrands() throws Exception {
        RepositoryConnectorContributorTest.assertEquals((Object)ImmutableSet.of((Object)"org.mylyn", (Object)"org.eclipse"), (Object)this.manager.getBrands(this.connector.getConnectorKind()));
    }

    @Test
    public void testGetConnectorLabel() {
        RepositoryConnectorContributorTest.assertEquals((String)"Label for org.mylyn", (String)this.manager.getConnectorLabel((AbstractRepositoryConnector)this.connector, "org.mylyn"));
        RepositoryConnectorContributorTest.assertEquals((String)"Label for org.eclipse", (String)this.manager.getConnectorLabel((AbstractRepositoryConnector)this.connector, "org.eclipse"));
        RepositoryConnectorContributorTest.assertEquals((String)this.connector.getLabel(), (String)this.manager.getConnectorLabel((AbstractRepositoryConnector)this.connector, "unknown"));
        RepositoryConnectorContributorTest.assertEquals((String)this.connector.getLabel(), (String)this.manager.getConnectorLabel((AbstractRepositoryConnector)this.connector, "exceptional"));
        RepositoryConnectorContributorTest.assertEquals((String)this.connector.getLabel(), (String)this.manager.getConnectorLabel((AbstractRepositoryConnector)this.connector, null));
        MockRepositoryConnectorDescriptor.DynamicMockRepositoryConnector mockConnector = new MockRepositoryConnectorDescriptor.DynamicMockRepositoryConnector(){

            @Override
            public String getConnectorKind() {
                return "mock-connector-with-no-brands";
            }
        };
        RepositoryConnectorContributorTest.assertEquals((String)this.connector.getLabel(), (String)this.manager.getConnectorLabel((AbstractRepositoryConnector)mockConnector, "org.mylyn"));
    }

    @Test
    public void testGetBrandingIcon() {
        this.assertBrandingIconHeight(3, "org.mylyn");
        this.assertBrandingIconHeight(2, "org.eclipse");
        this.assertBrandingIconHeight(16, "unknown");
        this.assertBrandingIconHeight(16, "exceptional");
        this.assertBrandingIconHeight(16, null);
        RepositoryConnectorContributorTest.assertNull((Object)this.manager.getBrandingIcon(this.repositoryForConnectorWithNoBrands.getConnectorKind(), "org.mylyn"));
        RepositoryConnectorContributorTest.assertNull((Object)this.manager.getBrandingIcon(this.repositoryForConnectorWithNoBrands));
    }

    private void assertBrandingIconHeight(int expectedHeight, String brand) {
        this.assertIconHeight(expectedHeight, this.manager.getBrandingIcon(this.connector.getConnectorKind(), brand));
        this.assertIconHeight(expectedHeight, this.manager.getBrandingIcon(this.repositories.get(brand)));
    }

    @Test
    public void testGetOverlayIcon() {
        this.assertOverlayIconHeight(5, "org.mylyn");
        this.assertOverlayIconHeight(4, "org.eclipse");
        this.assertOverlayIconHeight(8, "unknown");
        this.assertOverlayIconHeight(8, "exceptional");
        this.assertOverlayIconHeight(8, null);
        RepositoryConnectorContributorTest.assertNull((Object)this.manager.getOverlayIcon(this.repositoryForConnectorWithNoBrands.getConnectorKind(), "org.mylyn"));
        RepositoryConnectorContributorTest.assertNull((Object)this.manager.getOverlayIcon(this.repositoryForConnectorWithNoBrands));
        RepositoryConnectorContributorTest.assertNull((Object)this.manager.getOverlayIcon((ITask)this.taskForConnectorWithNoBrands));
    }

    private void assertOverlayIconHeight(int expectedHeight, String brand) {
        this.assertIconHeight(expectedHeight, this.manager.getOverlayIcon(this.connector.getConnectorKind(), brand));
        this.assertIconHeight(expectedHeight, this.manager.getOverlayIcon(this.repositories.get(brand)));
        this.assertIconHeight(expectedHeight, this.manager.getOverlayIcon(this.tasks.get(brand)));
    }

    private void assertIconHeight(int expectedHeight, Image image) {
        RepositoryConnectorContributorTest.assertEquals((int)expectedHeight, (int)image.getImageData().height);
    }

    private void assertIconHeight(int expectedHeight, ImageDescriptor descriptor) {
        RepositoryConnectorContributorTest.assertEquals((int)expectedHeight, (int)CommonImages.getImage((ImageDescriptor)descriptor).getImageData().height);
    }
}

