/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.tasks.tests.core;

import junit.framework.TestCase;
import org.eclipse.mylyn.tasks.core.ITask;

public class PriorityLevelTest
extends TestCase {
    public void testFromValueThreePriorities() {
        Priority p1 = new Priority(1);
        Priority p2 = new Priority(2);
        Priority p3 = new Priority(3);
        ITask.IPriorityValue[] priorities = new Priority[]{p1, p2, p3};
        PriorityLevelTest.assertEquals((String)"P1", (String)ITask.PriorityLevel.fromValue((ITask.IPriorityValue[])priorities, (ITask.IPriorityValue)new Priority(1)).toString());
        PriorityLevelTest.assertEquals((String)"P3", (String)ITask.PriorityLevel.fromValue((ITask.IPriorityValue[])priorities, (ITask.IPriorityValue)new Priority(2)).toString());
        PriorityLevelTest.assertEquals((String)"P5", (String)ITask.PriorityLevel.fromValue((ITask.IPriorityValue[])priorities, (ITask.IPriorityValue)new Priority(3)).toString());
        PriorityLevelTest.assertEquals((String)"P3", (String)ITask.PriorityLevel.fromValue((ITask.IPriorityValue[])priorities, (ITask.IPriorityValue)new Priority(10)).toString());
        PriorityLevelTest.assertEquals((String)"P3", (String)ITask.PriorityLevel.fromValue((ITask.IPriorityValue[])priorities, null).toString());
    }

    public void testFromValueSinglePriority() {
        Priority p1 = new Priority(10);
        ITask.IPriorityValue[] priorities = new Priority[]{p1};
        PriorityLevelTest.assertEquals((String)"P1", (String)ITask.PriorityLevel.fromValue((ITask.IPriorityValue[])priorities, (ITask.IPriorityValue)new Priority(10)).toString());
        PriorityLevelTest.assertEquals((String)"P3", (String)ITask.PriorityLevel.fromValue((ITask.IPriorityValue[])priorities, (ITask.IPriorityValue)new Priority(11)).toString());
        PriorityLevelTest.assertEquals((String)"P3", (String)ITask.PriorityLevel.fromValue((ITask.IPriorityValue[])priorities, null).toString());
    }

    public void testFromValueSixPriorites() {
        Priority p1 = new Priority(10);
        Priority p2 = new Priority(20);
        Priority p3 = new Priority(30);
        Priority p4 = new Priority(40);
        Priority p5 = new Priority(70);
        Priority p6 = new Priority(100);
        ITask.IPriorityValue[] priorities = new Priority[]{p1, p2, p3, p4, p5, p6};
        PriorityLevelTest.assertEquals((String)"P1", (String)ITask.PriorityLevel.fromValue((ITask.IPriorityValue[])priorities, (ITask.IPriorityValue)new Priority(10)).toString());
        PriorityLevelTest.assertEquals((String)"P1", (String)ITask.PriorityLevel.fromValue((ITask.IPriorityValue[])priorities, (ITask.IPriorityValue)new Priority(20)).toString());
        PriorityLevelTest.assertEquals((String)"P2", (String)ITask.PriorityLevel.fromValue((ITask.IPriorityValue[])priorities, (ITask.IPriorityValue)new Priority(30)).toString());
        PriorityLevelTest.assertEquals((String)"P2", (String)ITask.PriorityLevel.fromValue((ITask.IPriorityValue[])priorities, (ITask.IPriorityValue)new Priority(40)).toString());
        PriorityLevelTest.assertEquals((String)"P4", (String)ITask.PriorityLevel.fromValue((ITask.IPriorityValue[])priorities, (ITask.IPriorityValue)new Priority(70)).toString());
        PriorityLevelTest.assertEquals((String)"P5", (String)ITask.PriorityLevel.fromValue((ITask.IPriorityValue[])priorities, (ITask.IPriorityValue)new Priority(100)).toString());
    }

    private static class Priority
    implements ITask.IPriorityValue {
        private final int value;

        public Priority(int value) {
            this.value = value;
        }

        public int getPriorityValue() {
            return this.value;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.value;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Priority other = (Priority)obj;
            return this.value == other.value;
        }
    }
}

