/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.tasks.tests;

import java.io.File;
import java.io.RandomAccessFile;
import junit.framework.TestCase;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.internal.tasks.core.TaskAttachment;
import org.eclipse.mylyn.internal.tasks.core.TaskRepositoryManager;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.internal.tasks.ui.util.CopyAttachmentToClipboardJob;
import org.eclipse.mylyn.internal.tasks.ui.util.DownloadAttachmentJob;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.ITaskAttachment;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.TaskAttributeMapper;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.eclipse.mylyn.tasks.tests.connector.MockAttachmentHandler;
import org.eclipse.mylyn.tasks.tests.connector.MockRepositoryConnector;
import org.eclipse.mylyn.tasks.tests.connector.MockTask;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.ui.PlatformUI;

public class TaskAttachmentTest
extends TestCase {
    private TaskRepositoryManager manager;
    private MockRepositoryConnector connector;
    private MockAttachmentHandler attachmentHandler;
    private TaskRepository repository;
    private ITaskAttachment attachment;

    protected void setUp() throws Exception {
        super.setUp();
        this.manager = TasksUiPlugin.getRepositoryManager();
        this.repository = new TaskRepository("mock", "http://mockrepository.test");
        this.manager.addRepository(this.repository);
        this.attachmentHandler = new MockAttachmentHandler();
        this.connector = new MockRepositoryConnector();
        this.connector.setTaskAttachmentHandler(this.attachmentHandler);
        this.manager.addRepositoryConnector((AbstractRepositoryConnector)this.connector);
        TaskData taskData = new TaskData(new TaskAttributeMapper(this.repository), "mock", "http://mockrepository.test", "1");
        this.attachment = new TaskAttachment(this.repository, (ITask)new MockTask("1"), taskData.getRoot().createAttribute("attachment"));
    }

    protected void tearDown() throws Exception {
        this.manager.removeRepository(this.repository);
    }

    public void testCopyToClipboardAction() throws Exception {
        String expected = "attachment content";
        this.attachmentHandler.setAttachmentData(expected.getBytes());
        CopyAttachmentToClipboardJob job = new CopyAttachmentToClipboardJob(this.attachment);
        job.schedule();
        job.join();
        Clipboard clipboard = new Clipboard(PlatformUI.getWorkbench().getDisplay());
        TaskAttachmentTest.assertEquals((Object)expected, (Object)clipboard.getContents((Transfer)TextTransfer.getInstance()));
    }

    public void testDownloadAttachmentJob() throws Exception {
        File file = File.createTempFile("mylyn", null);
        file.deleteOnExit();
        String expected = "attachment\ncontent";
        this.attachmentHandler.setAttachmentData(expected.getBytes());
        DownloadAttachmentJob job = new DownloadAttachmentJob(this.attachment, file);
        job.schedule();
        job.join();
        TaskAttachmentTest.assertEquals((Object)Status.OK_STATUS, (Object)job.getResult());
        byte[] data = new byte[expected.getBytes().length];
        try (RandomAccessFile raf = new RandomAccessFile(file, "r");){
            raf.readFully(data);
        }
        TaskAttachmentTest.assertEquals((String)expected, (String)new String(data));
    }

    public void testDownloadAttachmentJobExceptionThrown() throws Exception {
        File file = File.createTempFile("mylyn", null);
        file.delete();
        this.attachmentHandler.setException(new CoreException(Status.CANCEL_STATUS));
        DownloadAttachmentJob job = new DownloadAttachmentJob(this.attachment, file);
        job.schedule();
        job.join();
        TaskAttachmentTest.assertEquals((Object)Status.OK_STATUS, (Object)job.getResult());
        TaskAttachmentTest.assertFalse((boolean)file.exists());
    }
}

