/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.tasks.ui.editors;

import org.eclipse.mylyn.internal.tasks.ui.editors.BooleanAttributeEditor;
import org.eclipse.mylyn.internal.tasks.ui.editors.DoubleAttributeEditor;
import org.eclipse.mylyn.internal.tasks.ui.editors.IntegerAttributeEditor;
import org.eclipse.mylyn.internal.tasks.ui.editors.LongAttributeEditor;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.TaskAttributeMapper;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.eclipse.mylyn.tasks.core.data.TaskDataModel;
import org.eclipse.mylyn.tasks.ui.editors.AbstractAttributeEditor;
import org.eclipse.mylyn.tasks.ui.editors.AttributeEditorFactory;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Mockito;

public class AttributeEditorFactoryTest {
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    private final TaskData data = new TaskData((TaskAttributeMapper)Mockito.mock(TaskAttributeMapper.class), "kind", "url", "id");
    private final AttributeEditorFactory factory = new AttributeEditorFactory((TaskDataModel)Mockito.mock(TaskDataModel.class), new TaskRepository("kind", "url"));

    @Test
    public void createBooleanAttributeEditor() {
        AbstractAttributeEditor editor = this.factory.createEditor("boolean", this.data.getRoot());
        Assert.assertEquals(BooleanAttributeEditor.class, editor.getClass());
    }

    @Test
    public void createDoubleAttributeEditor() {
        AbstractAttributeEditor editor = this.factory.createEditor("double", this.data.getRoot());
        Assert.assertEquals(DoubleAttributeEditor.class, editor.getClass());
    }

    @Test
    public void createLongAttributeEditor() {
        AbstractAttributeEditor editor = this.factory.createEditor("long", this.data.getRoot());
        Assert.assertEquals(LongAttributeEditor.class, editor.getClass());
    }

    @Test
    public void createIntegerAttributeEditor() {
        AbstractAttributeEditor editor = this.factory.createEditor("integer", this.data.getRoot());
        Assert.assertEquals(IntegerAttributeEditor.class, editor.getClass());
    }

    @Test
    public void createAttributeEditorForUnknownType() {
        this.thrown.expect(IllegalArgumentException.class);
        this.factory.createEditor("unknown type", this.data.getRoot());
    }
}

