/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.editors;

import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.mylyn.internal.tasks.ui.editors.LongAttributeEditor;
import org.eclipse.mylyn.tasks.core.data.TaskAttributeMapper;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.eclipse.mylyn.tasks.core.data.TaskDataModel;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class LongAttributeEditorTest {
    private final TaskData data = new TaskData((TaskAttributeMapper)Mockito.mock(TaskAttributeMapper.class), "kind", "url", "id");
    private final LongAttributeEditor editor = new LongAttributeEditor((TaskDataModel)Mockito.mock(TaskDataModel.class), this.data.getRoot());

    @Test
    public void validateEmptyInput() {
        IInputValidator validator = this.editor.getAttributeTypeValidator();
        Assert.assertNull((Object)validator.isValid(""));
    }

    @Test
    public void validateNumbers() {
        IInputValidator validator = this.editor.getAttributeTypeValidator();
        Assert.assertNull((Object)validator.isValid("1"));
        Assert.assertNull((Object)validator.isValid("0"));
        Assert.assertNull((Object)validator.isValid("-2"));
        Assert.assertNull((Object)validator.isValid(Long.toString(Long.MAX_VALUE)));
        Assert.assertNull((Object)validator.isValid(Long.toString(Long.MIN_VALUE)));
    }

    @Test
    public void validateText() {
        IInputValidator validator = this.editor.getAttributeTypeValidator();
        Assert.assertEquals((Object)"This field requires a long value.", (Object)validator.isValid("abc"));
        Assert.assertEquals((Object)"This field requires a long value.", (Object)validator.isValid("1.0"));
        Assert.assertEquals((Object)"This field requires a long value.", (Object)validator.isValid(String.valueOf(Long.toString(Long.MAX_VALUE)) + "1"));
        Assert.assertEquals((Object)"This field requires a long value.", (Object)validator.isValid(String.valueOf(Long.toString(Long.MIN_VALUE)) + "1"));
    }
}

