/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.editors;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.eclipse.mylyn.internal.tasks.core.data.TaskDataState;
import org.eclipse.mylyn.internal.tasks.ui.editors.LabelsAttributeEditor;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.ITaskDataWorkingCopy;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskAttributeMapper;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.eclipse.mylyn.tasks.core.data.TaskDataModel;
import org.eclipse.mylyn.tasks.tests.TaskTestUtil;
import org.eclipse.mylyn.tasks.tests.connector.MockTask;
import org.eclipse.mylyn.tasks.ui.editors.LayoutHint;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class LabelsAttributeEditorTest {
    private TaskData taskData;
    private TaskDataModel model;
    private LabelsAttributeEditor editor;
    private TaskAttribute singleSelectAttribute;
    private TaskAttribute multiSelectAttribute;

    @Before
    public void setUp() {
        TaskRepository repository = TaskTestUtil.createMockRepository();
        this.taskData = new TaskData(new TaskAttributeMapper(repository), "kind", "url", "id");
        MockTask task = new MockTask("taskId");
        TaskDataState state = new TaskDataState("kind", "url", "taskId");
        state.setEditsData(this.taskData);
        state.setLocalTaskData(this.taskData);
        this.model = new TaskDataModel(repository, (ITask)task, (ITaskDataWorkingCopy)state);
    }

    @Test
    public void testSingleSelectEmpty() {
        this.createSingleSelect("");
        this.assertSingleSelectValue("");
        this.editor.setValue("test");
        this.assertSingleSelectValue("test");
        this.editor.setValue("");
        this.assertSingleSelectValue("");
    }

    @Test
    public void testSingleSelect() {
        this.createSingleSelect("test option");
        this.assertSingleSelectValue("test option");
        this.editor.setValue("testing option");
        this.assertSingleSelectValue("testing option");
    }

    @Test
    public void testSingleSelectWithSeparator() {
        this.createSingleSelect("one,two ,      three, four");
        this.assertSingleSelectValue("one,two ,      three, four");
        this.editor.setValue("one,two ,      three, four ,five     ,");
        this.assertSingleSelectValue("one,two ,      three, four ,five     ,");
    }

    @Test
    public void testMultiSelectEmpty() {
        this.createMultiSelect((List<String>)ImmutableList.of());
        this.assertMultiSelectValue("", (List<String>)ImmutableList.of());
        this.editor.setValue("one,two");
        this.assertMultiSelectValue("one, two", (List<String>)ImmutableList.of((Object)"one", (Object)"two"));
        this.editor.setValue("");
        this.assertMultiSelectValue("", (List<String>)ImmutableList.of());
    }

    @Test
    public void testMultiSelect() {
        this.createMultiSelect((List<String>)ImmutableList.of((Object)"one", (Object)"two"));
        this.assertMultiSelectValue("one, two", (List<String>)ImmutableList.of((Object)"one", (Object)"two"));
        this.editor.setValue("one,two,three,four");
        this.assertMultiSelectValue("one, two, three, four", (List<String>)ImmutableList.of((Object)"one", (Object)"two", (Object)"three", (Object)"four"));
        this.editor.setValue("one");
        this.assertMultiSelectValue("one", (List<String>)ImmutableList.of((Object)"one"));
        this.editor.setValue("one,two ,      three,  four  ,five     ,,        ,");
        this.assertMultiSelectValue("one, two, three, four, five", (List<String>)ImmutableList.of((Object)"one", (Object)"two", (Object)"three", (Object)"four", (Object)"five"));
    }

    private void createSingleSelect(String value) {
        this.singleSelectAttribute = this.taskData.getRoot().createAttribute("singleSelect");
        this.singleSelectAttribute.getMetaData().setType("singleSelect");
        this.singleSelectAttribute.setValue(value);
        this.editor = new LabelsAttributeEditor(this.model, this.singleSelectAttribute);
        this.assertLayoutHint(false);
    }

    private void createMultiSelect(List<String> values) {
        this.multiSelectAttribute = this.taskData.getRoot().createAttribute("multiSelect");
        this.multiSelectAttribute.getMetaData().setType("multiSelect");
        this.multiSelectAttribute.setValues((List)ImmutableList.copyOf(values));
        this.editor = new LabelsAttributeEditor(this.model, this.multiSelectAttribute);
        this.assertLayoutHint(true);
    }

    private void assertSingleSelectValue(String value) {
        Assert.assertEquals((Object)value, (Object)this.editor.getValue());
        Assert.assertEquals((Object)value, (Object)this.singleSelectAttribute.getValue());
    }

    private void assertLayoutHint(boolean isMultiSelect) {
        Assert.assertEquals((Object)LayoutHint.ColumnSpan.SINGLE, (Object)this.editor.getLayoutHint().columnSpan);
        Assert.assertEquals((Object)(isMultiSelect ? LayoutHint.RowSpan.MULTIPLE : LayoutHint.RowSpan.SINGLE), (Object)this.editor.getLayoutHint().rowSpan);
    }

    private void assertMultiSelectValue(String stringValue, List<String> values) {
        Assert.assertEquals((Object)stringValue, (Object)this.editor.getValue());
        Assert.assertEquals(values, (Object)this.multiSelectAttribute.getValues());
    }
}

