/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.tasks.ui.wizards;

import com.google.common.base.Throwables;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.tests.connector.MockRepositoryConnector;
import org.eclipse.mylyn.tasks.ui.wizards.AbstractRepositorySettingsPage;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.PlatformUI;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

public class AbstractRepositorySettingsPageTest {
    @Test
    public void proxyPortTriggersValidation() throws Exception {
        TestRepositorySettingsPage page = new TestRepositorySettingsPage(this.createTaskRepository());
        IWizardContainer container = this.applyWizardContainer(page);
        page.createControl((Composite)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
        ((IWizardContainer)Mockito.verify((Object)container, (VerificationMode)Mockito.times((int)2))).updateButtons();
        page.proxyPortEditor.setStringValue("123");
        ((IWizardContainer)Mockito.verify((Object)container, (VerificationMode)Mockito.times((int)3))).updateButtons();
    }

    @Test
    public void validatesWithNoCredentials() throws Exception {
        RepositorySettingsPageWithNoCredentials page = new RepositorySettingsPageWithNoCredentials(this.createTaskRepository());
        this.applyWizardContainer(page);
        page.createControl((Composite)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
        page.validateSettings();
    }

    @Test
    public void labelAndUrlUpdatedWhenNoCredentials() throws Exception {
        TaskRepository repository = this.createTaskRepository();
        RepositorySettingsPageWithNoCredentials page = new RepositorySettingsPageWithNoCredentials(repository);
        this.applyWizardContainer(page);
        page.createControl((Composite)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
        Assert.assertEquals((Object)repository.getRepositoryUrl(), (Object)page.getRepositoryUrl());
        Assert.assertEquals((Object)repository.getRepositoryLabel(), (Object)page.getRepositoryLabel());
    }

    @Test
    public void labelAndUrlNotUpdatedWhenNoTaskRepository() throws Exception {
        RepositorySettingsPageWithNoCredentials page = new RepositorySettingsPageWithNoCredentials(null);
        this.applyWizardContainer(page);
        page.createControl((Composite)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
        Assert.assertEquals((Object)"", (Object)page.getRepositoryUrl());
        Assert.assertEquals((Object)"", (Object)page.getRepositoryLabel());
    }

    @Test
    public void applyToNewRepository() {
        TaskRepository repository = this.createTaskRepository();
        repository.removeProperty("org.eclipse.mylyn.brand.id");
        AbstractRepositorySettingsPage page = this.createPageWithNoCredentials(null);
        Assert.assertNull((Object)repository.getProperty("org.eclipse.mylyn.brand.id"));
        page.applyTo(repository);
        Assert.assertNull((Object)repository.getProperty("org.eclipse.mylyn.brand.id"));
        page.setBrand("org.mylyn");
        page.applyTo(repository);
        Assert.assertEquals((Object)"org.mylyn", (Object)repository.getProperty("org.eclipse.mylyn.brand.id"));
    }

    @Test
    public void applyToExistingRepository() {
        TaskRepository repository = this.createTaskRepository();
        repository.setProperty("org.eclipse.mylyn.brand.id", "existing.brand");
        AbstractRepositorySettingsPage page = this.createPageWithNoCredentials(repository);
        page.setBrand("org.mylyn");
        page.applyTo(repository);
        Assert.assertEquals((Object)"org.mylyn", (Object)repository.getProperty("org.eclipse.mylyn.brand.id"));
    }

    @Test
    public void applyNullBrandToExistingRepository() {
        TaskRepository repository = this.createTaskRepository();
        repository.setProperty("org.eclipse.mylyn.brand.id", "existing.brand");
        AbstractRepositorySettingsPage page = this.createPageWithNoCredentials(repository);
        page.setBrand(null);
        page.applyTo(repository);
        Assert.assertEquals((Object)"existing.brand", (Object)repository.getProperty("org.eclipse.mylyn.brand.id"));
    }

    @Test
    public void setsTitleFromBrand() {
        AbstractRepositorySettingsPage page = this.createPageWithNoCredentials(null);
        Assert.assertEquals((Object)"Title", (Object)page.getTitle());
        page.setBrand("org.mylyn");
        Assert.assertEquals((Object)"Label for org.mylyn", (Object)page.getTitle());
    }

    @Test
    public void setsTitleFromBrandedRepository() {
        TaskRepository repository = this.createTaskRepository();
        repository.setProperty("org.eclipse.mylyn.brand.id", "org.mylyn");
        AbstractRepositorySettingsPage page = this.createPageWithNoCredentials(repository);
        Assert.assertEquals((Object)"Label for org.mylyn", (Object)page.getTitle());
    }

    @Test
    public void setsTitleFromUnbrandedRepository() {
        TaskRepository repository = this.createTaskRepository();
        repository.removeProperty("org.eclipse.mylyn.brand.id");
        AbstractRepositorySettingsPage page = this.createPageWithNoCredentials(repository);
        Assert.assertEquals((Object)"Title", (Object)page.getTitle());
    }

    @Test
    public void setUrlReadOnlyNotCalled() throws Exception {
        TestRepositorySettingsPage page = new TestRepositorySettingsPage(this.createTaskRepository());
        page.createControl((Composite)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
        Combo serverUrlCombo = page.getServerUrlCombo();
        Assert.assertTrue((boolean)serverUrlCombo.isEnabled());
    }

    @Test
    public void setUrlReadOnlyTrue() throws Exception {
        TestRepositorySettingsPage page = new TestRepositorySettingsPage(this.createTaskRepository());
        page.setUrlReadOnly(true);
        page.createControl((Composite)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
        Combo serverUrlCombo = page.getServerUrlCombo();
        Assert.assertFalse((boolean)serverUrlCombo.isEnabled());
    }

    @Test
    public void setUrlReadOnlyFalse() throws Exception {
        TestRepositorySettingsPage page = new TestRepositorySettingsPage(this.createTaskRepository());
        page.setUrlReadOnly(false);
        page.createControl((Composite)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
        Combo serverUrlCombo = page.getServerUrlCombo();
        Assert.assertTrue((boolean)serverUrlCombo.isEnabled());
    }

    @Test
    public void setNeedsRepositoryCredentialsInitializeFalse() throws Exception {
        TestRepositorySettingsPage page = new TestRepositorySettingsPage(this.createTaskRepository());
        page.setNeedsRepositoryCredentials(false);
        page.createControl((Composite)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
        Assert.assertFalse((boolean)page.needsRepositoryCredentials());
        Assert.assertNull((Object)page.repositoryUserNameEditor);
        Assert.assertNull((Object)page.repositoryPasswordEditor);
    }

    @Test
    public void setNeedsRepositoryCredentialsInitializeTrue() throws Exception {
        TestRepositorySettingsPage page = new TestRepositorySettingsPage(this.createTaskRepository());
        page.setNeedsRepositoryCredentials(true);
        page.createControl((Composite)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
        Assert.assertTrue((boolean)page.needsRepositoryCredentials());
        this.assertCredentialsEnabled(page);
        this.assertPasswordIsSecret(page);
    }

    @Test
    public void setNeedsRepositoryCredentialsFalse() throws Exception {
        TestRepositorySettingsPage page = new TestRepositorySettingsPage(this.createTaskRepository());
        page.setNeedsRepositoryCredentials(true);
        page.createControl((Composite)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
        this.assertCredentialsEnabled(page);
        this.assertPasswordIsSecret(page);
        page.setNeedsRepositoryCredentials(false);
        this.assertCredentialsDisabled(page);
        this.assertPasswordIsSecret(page);
    }

    @Test
    public void setNeedsRepositoryCredentialsTrue() throws Exception {
        TestRepositorySettingsPage page = new TestRepositorySettingsPage(this.createTaskRepository());
        page.setNeedsRepositoryCredentials(true);
        page.createControl((Composite)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
        page.setNeedsRepositoryCredentials(false);
        this.assertCredentialsDisabled(page);
        this.assertPasswordIsSecret(page);
        page.setNeedsRepositoryCredentials(true);
        this.assertCredentialsEnabled(page);
        this.assertPasswordIsSecret(page);
    }

    @Test
    public void repositoryCredentialsEnabledOnlyIfNeededAndNotAnonymous() throws Exception {
        TestRepositorySettingsPage page = new TestRepositorySettingsPage(this.createTaskRepository());
        page.setNeedsRepositoryCredentials(true);
        page.setNeedsAnonymousLogin(true);
        page.createControl((Composite)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
        Assert.assertTrue((boolean)page.needsRepositoryCredentials());
        Assert.assertTrue((boolean)page.isAnonymousAccess());
        this.assertCredentialsDisabled(page);
        this.assertPasswordIsSecret(page);
        page.setAnonymous(false);
        page.setNeedsRepositoryCredentials(false);
        this.assertCredentialsDisabled(page);
        this.assertPasswordIsSecret(page);
        page.setNeedsRepositoryCredentials(true);
        this.assertCredentialsEnabled(page);
        this.assertPasswordIsSecret(page);
    }

    @Test
    public void isUrlReadOnly() throws Exception {
        TestRepositorySettingsPage page = new TestRepositorySettingsPage(this.createTaskRepository());
        Assert.assertFalse((boolean)page.isUrlReadOnly());
        page.setUrlReadOnly(true);
        Assert.assertTrue((boolean)page.isUrlReadOnly());
        page.setUrlReadOnly(false);
        Assert.assertFalse((boolean)page.isUrlReadOnly());
    }

    @Test
    public void preFinish() {
        TaskRepository repository = this.createTaskRepository();
        TestRepositorySettingsPage page = this.createPage(repository, false, Status.OK_STATUS);
        Assert.assertTrue((boolean)page.preFinish(repository));
        Assert.assertFalse((boolean)page.ranValidator());
        page = this.createPage(repository, false, Status.CANCEL_STATUS);
        Assert.assertTrue((boolean)page.preFinish(repository));
        Assert.assertFalse((boolean)page.ranValidator());
    }

    @Test
    public void preFinishValidateOnFinish() {
        TaskRepository repository = this.createTaskRepository();
        TestRepositorySettingsPage page = this.createPage(repository, true, Status.OK_STATUS);
        Assert.assertTrue((boolean)page.preFinish(repository));
        Assert.assertTrue((boolean)page.ranValidator());
        page = this.createPage(repository, true, Status.CANCEL_STATUS);
        Assert.assertFalse((boolean)page.preFinish(repository));
        Assert.assertTrue((boolean)page.ranValidator());
    }

    private TestRepositorySettingsPage createPage(TaskRepository repository, boolean shouldValidateOnFinish, IStatus validationStatus) {
        TestRepositorySettingsPage page = (TestRepositorySettingsPage)((Object)Mockito.spy((Object)((Object)new TestRepositorySettingsPage(repository, shouldValidateOnFinish, validationStatus))));
        IWizard wizard = (IWizard)Mockito.mock(IWizard.class);
        IWizardContainer container = (IWizardContainer)Mockito.mock(IWizardContainer.class);
        try {
            ((IWizardContainer)Mockito.doAnswer((Answer)new Answer<Void>(){

                public Void answer(InvocationOnMock invocation) throws Throwable {
                    IRunnableWithProgress runnable = (IRunnableWithProgress)invocation.getArguments()[2];
                    runnable.run((IProgressMonitor)new NullProgressMonitor());
                    return null;
                }
            }).when((Object)container)).run(Matchers.anyBoolean(), Matchers.anyBoolean(), (IRunnableWithProgress)Matchers.any());
        }
        catch (InterruptedException | InvocationTargetException e) {
            Throwables.propagate((Throwable)e);
        }
        Mockito.when((Object)wizard.getContainer()).thenReturn((Object)container);
        page.setWizard(wizard);
        ((TestRepositorySettingsPage)((Object)Mockito.doReturn((Object)"http://mock/").when((Object)page))).getRepositoryUrl();
        ((TestRepositorySettingsPage)((Object)Mockito.doReturn((Object)"label").when((Object)page))).getRepositoryLabel();
        ((TestRepositorySettingsPage)((Object)Mockito.doReturn((Object)false).when((Object)page))).needsAdvanced();
        ((TestRepositorySettingsPage)((Object)Mockito.doReturn((Object)false).when((Object)page))).needsProxy();
        ((TestRepositorySettingsPage)((Object)Mockito.doReturn((Object)false).when((Object)page))).needsRepositoryCredentials();
        return page;
    }

    private AbstractRepositorySettingsPage createPageWithNoCredentials(TaskRepository repository) {
        AbstractRepositorySettingsPage page = (AbstractRepositorySettingsPage)Mockito.spy((Object)((Object)new RepositorySettingsPageWithNoCredentials(repository)));
        ((AbstractRepositorySettingsPage)Mockito.doReturn((Object)"label").when((Object)page)).getRepositoryLabel();
        Mockito.when((Object)page.needsProxy()).thenReturn((Object)false);
        return page;
    }

    private IWizardContainer applyWizardContainer(TestRepositorySettingsPage page) {
        IWizard wizard = (IWizard)Mockito.mock(IWizard.class);
        IWizardContainer container = (IWizardContainer)Mockito.mock(IWizardContainer.class);
        Mockito.when((Object)wizard.getContainer()).thenReturn((Object)container);
        page.setWizard(wizard);
        return container;
    }

    private TaskRepository createTaskRepository() {
        TaskRepository repository = new TaskRepository("mock", "url");
        repository.setRepositoryLabel("label");
        return repository;
    }

    private void assertCredentialsEnabled(TestRepositorySettingsPage page) {
        Assert.assertTrue((boolean)page.repositoryUserNameEditor.getTextControl(page.compositeContainer).isEnabled());
        Assert.assertTrue((boolean)page.repositoryPasswordEditor.getTextControl(page.compositeContainer).isEnabled());
    }

    private void assertCredentialsDisabled(TestRepositorySettingsPage page) {
        Assert.assertFalse((boolean)page.repositoryUserNameEditor.getTextControl(page.compositeContainer).isEnabled());
        Assert.assertFalse((boolean)page.repositoryPasswordEditor.getTextControl(page.compositeContainer).isEnabled());
    }

    private void assertPasswordIsSecret(TestRepositorySettingsPage page) {
        StringFieldEditor passwordEditor = page.repositoryPasswordEditor;
        Assert.assertEquals((long)42L, (long)passwordEditor.getTextControl(page.compositeContainer).getEchoChar());
    }

    public static class RepositorySettingsPageWithNoCredentials
    extends TestRepositorySettingsPage {
        public RepositorySettingsPageWithNoCredentials(TaskRepository taskRepository) {
            super(taskRepository);
            this.setNeedsRepositoryCredentials(false);
        }
    }

    public static class TestRepositorySettingsPage
    extends AbstractRepositorySettingsPage {
        private final boolean shouldValidateOnFinish;
        private final IStatus validationStatus;
        private boolean ranValidator;

        public TestRepositorySettingsPage(TaskRepository taskRepository, boolean shouldValidateOnFinish, IStatus validationStatus) {
            super("Title", "Description", taskRepository, (AbstractRepositoryConnector)MockRepositoryConnector.getDefault());
            this.setNeedsProxy(true);
            this.shouldValidateOnFinish = shouldValidateOnFinish;
            this.validationStatus = validationStatus;
        }

        public TestRepositorySettingsPage(TaskRepository taskRepository) {
            this(taskRepository, false, Status.OK_STATUS);
        }

        protected AbstractRepositorySettingsPage.Validator getValidator(TaskRepository repository) {
            AbstractRepositorySettingsPage.Validator validator = new AbstractRepositorySettingsPage.Validator(this){

                public void run(IProgressMonitor monitor) throws CoreException {
                    ranValidator = true;
                }
            };
            validator.setStatus(this.validationStatus);
            return validator;
        }

        public String getConnectorKind() {
            return "mock";
        }

        protected void createAdditionalControls(Composite parent) {
        }

        Combo getServerUrlCombo() {
            return this.serverUrlCombo;
        }

        public boolean shouldValidateOnFinish() {
            return this.shouldValidateOnFinish;
        }

        public boolean ranValidator() {
            return this.ranValidator;
        }
    }
}

