/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.gerrit.core;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.mylyn.reviews.internal.core.BuildResult;

public class HudsonCommentParser {
    private static final Pattern URL_PATTERN = Pattern.compile("([a-zA-Z][a-zA-Z+.-]{0,10}://[a-zA-Z0-9%._~!$&?#'()*+,;:@/=-]*[a-zA-Z0-9%_~!$&?#'(*+;:@/=-])");
    private static final Pattern PatcherSetNumber_Pattern = Pattern.compile("(\\d+)");

    public ImmutableList<BuildResult> getBuildResult(String commentDescription) {
        int patchSetNumber = this.extractPatchSetNumberFromText(commentDescription);
        if (patchSetNumber == -1) {
            return ImmutableList.of();
        }
        String[] lines = commentDescription.split("[\\r\\n]+");
        ArrayList results = Lists.newArrayList();
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            BuildResult result = this.createBuildResultFromLine(patchSetNumber, line);
            if (result != null) {
                results.add(result);
            }
            ++n2;
        }
        return ImmutableList.copyOf((Collection)results);
    }

    private BuildResult createBuildResultFromLine(int patchSetNumber, String line) {
        if (line.trim().startsWith(">")) {
            return null;
        }
        String url = this.extractFirstUrlFromText(line);
        if (url == null) {
            return null;
        }
        int buildNumber = this.extractBuildNumberFromUrl(url);
        if (buildNumber == -1) {
            return null;
        }
        String jobName = url.substring(0, url.lastIndexOf(Integer.toString(buildNumber)) - 1);
        BuildResult.BuildStatus buildStatus = this.extractBuildStatusFromText(line);
        if (buildStatus == null) {
            return null;
        }
        return new BuildResult(buildNumber, url, buildStatus, patchSetNumber, jobName);
    }

    private BuildResult.BuildStatus extractBuildStatusFromText(String descriptionLastLine) {
        if (descriptionLastLine.startsWith("Build Started")) {
            return BuildResult.BuildStatus.STARTED;
        }
        String[] urlFragments = descriptionLastLine.split(" :");
        if (urlFragments.length > 1) {
            try {
                return BuildResult.BuildStatus.valueOf((String)urlFragments[1].trim());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return null;
            }
        }
        return null;
    }

    private int extractBuildNumberFromUrl(String url) {
        String[] segments = url.split("/");
        String lastSegment = segments[segments.length - 1];
        try {
            return Integer.parseInt(lastSegment);
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }

    private String extractFirstUrlFromText(String text) {
        Matcher matcher = URL_PATTERN.matcher(text);
        if (matcher.find()) {
            return matcher.group(0);
        }
        return null;
    }

    private int extractPatchSetNumberFromText(String text) {
        String firstLineToSearch = text.split("[\\r\\n]+")[0];
        Matcher matcher = PatcherSetNumber_Pattern.matcher(firstLineToSearch);
        if (matcher.find()) {
            try {
                return Integer.parseInt(matcher.group(0));
            }
            catch (NumberFormatException numberFormatException) {
                return -1;
            }
        }
        return -1;
    }
}

