/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.core.parser.outline;

import junit.framework.TestCase;
import org.eclipse.mylyn.wikitext.core.parser.markup.MarkupLanguage;
import org.eclipse.mylyn.wikitext.core.parser.outline.OutlineItem;
import org.eclipse.mylyn.wikitext.core.parser.outline.OutlineParser;
import org.eclipse.mylyn.wikitext.mediawiki.core.MediaWikiLanguage;
import org.eclipse.mylyn.wikitext.textile.core.TextileLanguage;

public class OutlineParserTest
extends TestCase {
    private OutlineParser outlineParser;

    public void setUp() {
        this.outlineParser = new OutlineParser((MarkupLanguage)new TextileLanguage());
    }

    public void testSimple() {
        OutlineItem outline = this.outlineParser.parse("h1. First Header\n\nh2. Second Header\n\nh1. Third Header\n");
        OutlineParserTest.assertEquals((int)2, (int)outline.getChildren().size());
        OutlineParserTest.assertEquals((int)1, (int)((OutlineItem)outline.getChildren().get(0)).getChildren().size());
        OutlineParserTest.assertEquals((int)0, (int)((OutlineItem)outline.getChildren().get(1)).getChildren().size());
    }

    public void testNearestItem() {
        String textile = "h1. First Header\n\nh2. Second Header\n\nh1. Third Header\n";
        OutlineItem outline = this.outlineParser.parse(textile);
        int idxOfH2 = textile.indexOf("h2. Second");
        OutlineParserTest.assertTrue((idxOfH2 != -1 ? 1 : 0) != 0);
        OutlineItem h2Item = outline.findNearestMatchingOffset(idxOfH2);
        OutlineParserTest.assertNotNull((Object)h2Item);
        OutlineParserTest.assertSame(outline.getChildren().get(0), (Object)h2Item.getParent());
        OutlineParserTest.assertEquals((int)2, (int)h2Item.getLevel());
        OutlineItem h1Item = outline.findNearestMatchingOffset(idxOfH2 - 1);
        OutlineParserTest.assertNotNull((Object)h1Item);
        OutlineParserTest.assertSame(outline.getChildren().get(0), (Object)h1Item);
        OutlineParserTest.assertEquals((int)1, (int)h1Item.getLevel());
        int secondIdxOfH1 = textile.indexOf("h1. Third");
        OutlineItem secondH1Item = outline.findNearestMatchingOffset(secondIdxOfH1);
        OutlineParserTest.assertNotNull((Object)secondH1Item);
        OutlineParserTest.assertSame(outline.getChildren().get(1), (Object)secondH1Item);
        OutlineParserTest.assertEquals((int)1, (int)secondH1Item.getLevel());
        OutlineItem h2Item2 = outline.findNearestMatchingOffset(secondIdxOfH1 - 1);
        OutlineParserTest.assertSame((Object)h2Item, (Object)h2Item2);
    }

    public void testPrevious() {
        String textile = "h1. First Header\n\nh2. Second Header\n\nh1. Third Header\n";
        OutlineItem outline = this.outlineParser.parse(textile);
        OutlineParserTest.assertNull((Object)outline.getPrevious());
        OutlineParserTest.assertSame((Object)outline, (Object)((OutlineItem)outline.getChildren().get(0)).getPrevious());
        OutlineParserTest.assertSame(outline.getChildren().get(0), (Object)((OutlineItem)outline.getChildren().get(1)).getPrevious());
        OutlineParserTest.assertSame(outline.getChildren().get(0), (Object)((OutlineItem)((OutlineItem)outline.getChildren().get(0)).getChildren().get(0)).getPrevious());
    }

    public void testMoveChildren() {
        String textile = "h1. First Header\n\nh2. Second Header\n\nh1. Third Header\n";
        OutlineItem outline = this.outlineParser.parse(textile);
        OutlineParserTest.assertEquals((int)2, (int)outline.getChildren().size());
        OutlineItem outline2 = this.outlineParser.createRootItem();
        outline2.moveChildren(outline);
        OutlineParserTest.assertEquals((int)0, (int)outline.getChildren().size());
        OutlineParserTest.assertEquals((int)2, (int)outline2.getChildren().size());
        OutlineParserTest.assertSame((Object)outline2, (Object)((OutlineItem)outline2.getChildren().get(0)).getParent());
        OutlineParserTest.assertSame((Object)outline2, (Object)((OutlineItem)outline2.getChildren().get(1)).getParent());
        outline = this.outlineParser.parse(textile);
        outline.moveChildren(outline2);
        OutlineParserTest.assertEquals((int)0, (int)outline2.getChildren().size());
        OutlineParserTest.assertEquals((int)4, (int)outline.getChildren().size());
        OutlineParserTest.assertSame((Object)outline, (Object)((OutlineItem)outline.getChildren().get(0)).getParent());
        OutlineParserTest.assertSame((Object)outline, (Object)((OutlineItem)outline.getChildren().get(1)).getParent());
        OutlineParserTest.assertSame((Object)outline, (Object)((OutlineItem)outline.getChildren().get(2)).getParent());
        OutlineParserTest.assertSame((Object)outline, (Object)((OutlineItem)outline.getChildren().get(3)).getParent());
    }

    public void testHeadersWithHtmlTags() {
        this.outlineParser = new OutlineParser((MarkupLanguage)new MediaWikiLanguage());
        OutlineItem outline = this.outlineParser.parse("= <span style=\"font-family:monospace\">Heading Text</span> =\n\n text");
        OutlineParserTest.assertEquals((int)1, (int)outline.getChildren().size());
        OutlineItem headingItem = (OutlineItem)outline.getChildren().get(0);
        OutlineParserTest.assertEquals((String)"Heading_Text", (String)headingItem.getId());
        OutlineParserTest.assertEquals((String)"Heading Text", (String)headingItem.getLabel());
    }
}

