/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.logging.Logger;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.core.runtime.Platform;
import org.eclipse.mylyn.internal.wikitext.ui.WikiTextUiPlugin;
import org.eclipse.mylyn.wikitext.core.parser.MarkupParser;
import org.eclipse.mylyn.wikitext.core.parser.markup.MarkupLanguage;
import org.eclipse.mylyn.wikitext.core.util.ServiceLocator;
import org.eclipse.mylyn.wikitext.tests.NoDiscovery;
import org.eclipse.mylyn.wikitext.tests.TestUtil;
import org.junit.Assert;
import org.osgi.framework.Bundle;

public class MarkupFilesTest
extends TestSuite {
    private static final String MARKUP_LANGUAGE_TESTS = "markupLanguageTests";

    public MarkupFilesTest() {
        this.setName(MarkupFilesTest.class.getSimpleName());
        this.discoverTests();
    }

    public static Test suite() {
        return new MarkupFilesTest();
    }

    private void discoverTests() {
        Logger log = Logger.getLogger(MarkupFilesTest.class.getName());
        log.info("******************* Discovering tests....");
        if (Platform.isRunning()) {
            Assert.assertNotNull((Object)WikiTextUiPlugin.getDefault());
            Bundle bundle = Platform.getBundle((String)"org.eclipse.mylyn.wikitext.tests");
            Enumeration entries = bundle.findEntries("/markupLanguageTests", null, false);
            while (entries.hasMoreElements()) {
                URL entry = (URL)entries.nextElement();
                String path = entry.getPath();
                if (path.endsWith("/")) {
                    path = path.substring(0, path.length() - 1);
                }
                String lastName = path.substring(path.lastIndexOf(47) + 1, path.length());
                log.info("Discovered: " + lastName);
                this.addTest((Test)new MarkupLanguageTestSuite(lastName, bundle));
            }
        } else {
            File file;
            String classPath;
            String className = String.valueOf(MarkupFilesTest.class.getSimpleName()) + ".class";
            URL classResource = MarkupFilesTest.class.getResource(className);
            String path = classResource.getPath();
            if (!path.endsWith(classPath = String.valueOf(MarkupFilesTest.class.getName().replace('.', '/')) + ".class")) {
                throw new IllegalStateException(path);
            }
            if (!"file".equals(classResource.getProtocol())) {
                throw new IllegalStateException(String.valueOf(classResource.getProtocol()) + " is not supported");
            }
            path = path.substring(0, path.length() - classPath.length());
            try {
                file = new File(URLDecoder.decode(path, "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalStateException(e);
            }
            if (file.getName().equals("bin")) {
                file = file.getParentFile();
            } else if (file.getName().equals("classes") && file.getParentFile().getName().equals("target")) {
                file = file.getParentFile().getParentFile();
            }
            file = new File(file, MARKUP_LANGUAGE_TESTS);
            log.info("Inspecting: " + file);
            if (!file.exists() || !file.isDirectory()) {
                throw new IllegalStateException(file.toString());
            }
            File[] languageDirectories = file.listFiles();
            if (languageDirectories == null || languageDirectories.length == 0) {
                throw new IllegalStateException(file.toString());
            }
            File[] fileArray = languageDirectories;
            int n = languageDirectories.length;
            int n2 = 0;
            while (n2 < n) {
                File languageDir = fileArray[n2];
                log.info("Discovered: " + languageDir);
                this.addTest((Test)new MarkupLanguageTestSuite(languageDir.getName(), languageDir));
                ++n2;
            }
        }
        log.info(String.format("Found %s tests", this.countTestCases()));
    }

    @NoDiscovery
    private static abstract class AbstractMarkupFileCase
    extends TestCase {
        protected final MarkupLanguage markupLanguage;

        public AbstractMarkupFileCase(MarkupLanguage markupLanguage) {
            this.markupLanguage = markupLanguage.clone();
        }

        protected void runTest() throws Throwable {
            String markupContent = this.readMarkupContent();
            String expectedContent = this.readExpectedContent();
            MarkupParser parser = new MarkupParser(this.markupLanguage);
            String html = parser.parseToHtml(markupContent);
            TestUtil.println("**************\nTesting - " + this.getName());
            TestUtil.println("Generated:\n" + html);
            TestUtil.println("Expecting:\n" + expectedContent);
            AbstractMarkupFileCase.assertTrue((boolean)html.contains(expectedContent));
        }

        protected abstract String readExpectedContent() throws IOException;

        protected abstract String readMarkupContent() throws IOException;

        protected String readFully(InputStream in) throws IOException {
            try (InputStreamReader reader = new InputStreamReader(in);){
                int i;
                StringWriter writer = new StringWriter();
                while ((i = ((Reader)reader).read()) != -1) {
                    writer.write(i);
                }
                String string = writer.toString();
                return string;
            }
        }
    }

    @NoDiscovery
    private static class MarkupFileCase
    extends AbstractMarkupFileCase {
        private final File file;
        private final File resultsFile;

        public MarkupFileCase(MarkupLanguage markupLanguage, File file) {
            super(markupLanguage);
            this.file = file;
            this.setName(file.getName());
            String resultsFileName = String.valueOf(file.getName().substring(0, file.getName().lastIndexOf(46))) + ".txt";
            this.resultsFile = new File(file.getParentFile(), resultsFileName);
            MarkupFileCase.assertTrue((String)("Expected to find file: " + this.resultsFile), (file.exists() && file.isFile() ? 1 : 0) != 0);
        }

        private String readFully(File file) throws IOException {
            try (FileInputStream in = new FileInputStream(file);){
                String string = this.readFully(in);
                return string;
            }
        }

        @Override
        protected String readExpectedContent() throws IOException {
            return this.readFully(this.resultsFile);
        }

        @Override
        protected String readMarkupContent() throws IOException {
            return this.readFully(this.file);
        }
    }

    @NoDiscovery
    private static class MarkupLanguageTestSuite
    extends TestSuite {
        public MarkupLanguageTestSuite(String name, File languageDir) {
            MarkupLanguage markupLanguage = ServiceLocator.getInstance().getMarkupLanguage(name);
            this.setName(markupLanguage.getName());
            this.discoverLanguageTests(markupLanguage, languageDir);
        }

        public MarkupLanguageTestSuite(String name, Bundle bundle) {
            MarkupLanguage markupLanguage = ServiceLocator.getInstance().getMarkupLanguage(name);
            this.setName(markupLanguage.getName());
            this.discoverLanguageTests(markupLanguage, bundle, "/markupLanguageTests/" + name + "/");
        }

        private void discoverLanguageTests(MarkupLanguage markupLanguage, Bundle bundle, String bundlePath) {
            String markupFileExtension = String.valueOf('.') + markupLanguage.getName().toLowerCase();
            Logger.getLogger(MarkupFilesTest.class.getName()).info(String.format("Looking for %s tests in bundle %s using path %s", markupLanguage.getName(), bundle.getSymbolicName(), bundlePath));
            Enumeration entries = bundle.findEntries(bundlePath, null, false);
            while (entries.hasMoreElements()) {
                String name;
                URL testElement = (URL)entries.nextElement();
                try {
                    name = testElement.toURI().toString();
                }
                catch (URISyntaxException e) {
                    throw new IllegalStateException(e);
                }
                if (name.endsWith(markupFileExtension)) {
                    name = name.substring(name.lastIndexOf(47) + 1, name.length());
                    name = name.substring(0, name.lastIndexOf(46));
                    String expectedOutcomePath = String.valueOf(bundlePath) + "/" + name + ".txt";
                    URL expectedOutcome = bundle.getEntry(expectedOutcomePath);
                    if (expectedOutcome == null) {
                        Logger.getLogger(MarkupFilesTest.class.getName()).severe("Cannot find file: " + name + " for test input: " + testElement);
                        continue;
                    }
                    this.addTest((Test)new PlatformMarkupFileCase(markupLanguage, name, testElement, expectedOutcome));
                    continue;
                }
                if (name.endsWith(".txt")) continue;
                Logger.getLogger(MarkupFilesTest.class.getName()).severe("Unexpected file: " + name);
            }
            Logger.getLogger(MarkupFilesTest.class.getName()).info(String.format("Found %s %s tests", this.countTestCases(), markupLanguage.getName()));
        }

        private void discoverLanguageTests(MarkupLanguage markupLanguage, File languageDir) {
            File[] testFiles = languageDir.listFiles();
            if (testFiles != null) {
                String markupFileExtension = String.valueOf('.') + markupLanguage.getName().toLowerCase();
                File[] fileArray = testFiles;
                int n = testFiles.length;
                int n2 = 0;
                while (n2 < n) {
                    File file = fileArray[n2];
                    if (file.getName().toLowerCase().endsWith(markupFileExtension)) {
                        this.addTest((Test)new MarkupFileCase(markupLanguage, file));
                    } else if (!file.getName().toLowerCase().endsWith(".txt")) {
                        Logger.getLogger(MarkupFilesTest.class.getName()).severe("Unexpected file: " + file);
                    }
                    ++n2;
                }
            }
        }
    }

    @NoDiscovery
    private static class PlatformMarkupFileCase
    extends AbstractMarkupFileCase {
        private final URL testElement;
        private final URL expectedOutcome;

        public PlatformMarkupFileCase(MarkupLanguage markupLanguage, String name, URL testElement, URL expectedOutcome) {
            super(markupLanguage);
            this.testElement = testElement;
            this.expectedOutcome = expectedOutcome;
            this.setName(name);
        }

        @Override
        protected String readExpectedContent() throws IOException {
            try (InputStream in = this.expectedOutcome.openStream();){
                String string = this.readFully(in);
                return string;
            }
        }

        @Override
        protected String readMarkupContent() throws IOException {
            try (InputStream in = this.testElement.openStream();){
                String string = this.readFully(in);
                return string;
            }
        }
    }
}

